/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.gzip;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.Compressor;

public class GZipCompressor
extends Compressor {
    protected void compress() throws ArchiverException {
        DeflaterOutputStream zOut = null;
        try {
            zOut = new GZIPOutputStream(new FileOutputStream(this.getDestFile()));
            this.compressFile(this.getSourceFile(), zOut);
        }
        catch (IOException ioe) {
            String msg = "Problem creating gzip " + ioe.getMessage();
            throw new ArchiverException(msg, ioe);
        }
        finally {
            if (zOut != null) {
                try {
                    zOut.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

