/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.keytool.GenkeyMojo;
import org.codehaus.mojo.webstart.JarSignMojo2;
import org.codehaus.mojo.webstart.JarSignerMojo;
import org.codehaus.mojo.webstart.SignConfig;

public class JarSignMojoConfig
implements SignConfig {
    protected Log log;
    protected File workDirectory;
    protected boolean verbose;
    private KeystoreConfig keystoreConfig;
    private String keystore;
    private String keyalg;
    private String keysize;
    private String sigalg;
    private String sigfile;
    private String storetype;
    private String storepass;
    private String keypass;
    private String validity;
    private String dnameCn;
    private String dnameOu;
    private String dnameL;
    private String dnameSt;
    private String dnameO;
    private String dnameC;
    private String alias;
    private boolean verify;

    public JarSignerMojo getJarSignerMojo() {
        JarSignMojo2 signJar = new JarSignMojo2();
        signJar.setAlias(this.getAlias());
        signJar.setKeypass(this.getKeypass());
        signJar.setKeystore(this.getKeystore());
        signJar.setSkipAttachSignedArtifact(true);
        signJar.setSigFile(this.getSigfile());
        signJar.setStorepass(this.getStorepass());
        signJar.setType(this.getStoretype());
        signJar.setVerify(this.getVerify());
        signJar.setWorkingDir(this.workDirectory);
        signJar.setVerbose(this.verbose);
        signJar.setLog(this.log);
        return signJar;
    }

    public void init(Log log, File workDirectory, boolean verbose) throws MojoExecutionException, MojoFailureException {
        this.log = log;
        this.workDirectory = workDirectory;
        this.verbose = verbose;
        if (this.keystoreConfig != null && this.keystoreConfig.isGen()) {
            if (this.keystoreConfig.isDelete()) {
                this.deleteKeyStore();
            }
            this.genKeyStore();
        }
    }

    public void setKeystoreConfig(KeystoreConfig keystoreConfig) {
        this.keystoreConfig = keystoreConfig;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setKeyalg(String keyalg) {
        this.keyalg = keyalg;
    }

    public void setKeysize(String keysize) {
        this.keysize = keysize;
    }

    public void setSigalg(String sigalg) {
        this.sigalg = sigalg;
    }

    public void setSigfile(String sigfile) {
        this.sigfile = sigfile;
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setValidity(String validity) {
        this.validity = validity;
    }

    public void setDnameCn(String dnameCn) {
        this.dnameCn = dnameCn;
    }

    public void setDnameOu(String dnameOu) {
        this.dnameOu = dnameOu;
    }

    public void setDnameL(String dnameL) {
        this.dnameL = dnameL;
    }

    public void setDnameSt(String dnameSt) {
        this.dnameSt = dnameSt;
    }

    public void setDnameO(String dnameO) {
        this.dnameO = dnameO;
    }

    public void setDnameC(String dnameC) {
        this.dnameC = dnameC;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public String getKeystore() {
        return this.keystore;
    }

    public String getKeyalg() {
        return this.keyalg;
    }

    public String getKeysize() {
        return this.keysize;
    }

    public String getSigalg() {
        return this.sigalg;
    }

    public String getSigfile() {
        return this.sigfile;
    }

    public String getStoretype() {
        return this.storetype;
    }

    public String getStorepass() {
        return this.storepass;
    }

    public String getKeypass() {
        return this.keypass;
    }

    public String getValidity() {
        return this.validity;
    }

    public String getDnameCn() {
        return this.dnameCn;
    }

    public String getDnameOu() {
        return this.dnameOu;
    }

    public String getDnameL() {
        return this.dnameL;
    }

    public String getDnameSt() {
        return this.dnameSt;
    }

    public String getDnameO() {
        return this.dnameO;
    }

    public String getDnameC() {
        return this.dnameC;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean getVerify() {
        return this.verify;
    }

    public String getDname() {
        StringBuffer buffer = new StringBuffer(128);
        this.appendToDnameBuffer(this.dnameCn, buffer, "CN");
        this.appendToDnameBuffer(this.dnameOu, buffer, "OU");
        this.appendToDnameBuffer(this.dnameL, buffer, "L");
        this.appendToDnameBuffer(this.dnameSt, buffer, "ST");
        this.appendToDnameBuffer(this.dnameO, buffer, "O");
        this.appendToDnameBuffer(this.dnameC, buffer, "C");
        return buffer.toString();
    }

    private void appendToDnameBuffer(String property, StringBuffer buffer, String prefix) {
        if (property != null) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(prefix).append("=");
            buffer.append(property);
        }
    }

    private void genKeyStore() throws MojoExecutionException {
        GenkeyMojo genKeystore = new GenkeyMojo();
        genKeystore.setAlias(this.getAlias());
        genKeystore.setDname(this.getDname());
        genKeystore.setKeyalg(this.getKeyalg());
        genKeystore.setKeypass(this.getKeypass());
        genKeystore.setKeysize(this.getKeysize());
        genKeystore.setKeystore(this.getKeystore());
        genKeystore.setSigalg(this.getSigalg());
        genKeystore.setStorepass(this.getStorepass());
        genKeystore.setStoretype(this.getStoretype());
        genKeystore.setValidity(this.getValidity());
        genKeystore.setVerbose(this.verbose);
        genKeystore.setWorkingDir(this.workDirectory);
        genKeystore.setLog(this.log);
        genKeystore.execute();
    }

    private void deleteKeyStore() {
        File keyStore = null;
        if (this.getKeystore() != null) {
            keyStore = new File(this.getKeystore());
        }
        if (keyStore == null) {
            return;
        }
        if (keyStore.exists()) {
            if (keyStore.delete()) {
                this.log.debug((CharSequence)("deleted keystore from: " + keyStore.getAbsolutePath()));
            } else {
                this.log.warn((CharSequence)("Couldn't delete keystore from: " + keyStore.getAbsolutePath()));
            }
        } else {
            this.log.debug((CharSequence)("Skipping deletion of non existing keystore: " + keyStore.getAbsolutePath()));
        }
    }

    public static class KeystoreConfig {
        private boolean delete;
        private boolean gen;

        public boolean isDelete() {
            return this.delete;
        }

        public void setDelete(boolean delete) {
            this.delete = delete;
        }

        public boolean isGen() {
            return this.gen;
        }

        public void setGen(boolean gen) {
            this.gen = gen;
        }
    }
}

