/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon.shared;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.shared.WagonUpload;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class DefaultWagonUpload
implements WagonUpload {
    public void upload(Wagon wagon, FileSet fileset, Log logger) throws WagonException {
        FileSetManager fileSetManager = new FileSetManager(logger, logger.isDebugEnabled());
        String[] files = fileSetManager.getIncludedFiles(fileset);
        String url = wagon.getRepository().getUrl() + "/";
        if (files.length == 0) {
            logger.info((CharSequence)"Nothing to upload.");
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            String relativeDestPath = StringUtils.replace((String)files[i], (String)"\\", (String)"/");
            if (!StringUtils.isBlank((String)fileset.getOutputDirectory())) {
                relativeDestPath = fileset.getOutputDirectory() + "/" + relativeDestPath;
            }
            File source = new File(fileset.getDirectory(), files[i]);
            logger.info((CharSequence)("Uploading " + source + " to " + url + relativeDestPath + " ..."));
            wagon.put(source, relativeDestPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(Wagon wagon, FileSet fileset, boolean optimize, Log logger) throws WagonException, IOException {
        if (!optimize) {
            this.upload(wagon, fileset, logger);
            return;
        }
        if (!(wagon instanceof CommandExecutor)) {
            throw new UnsupportedProtocolException("Wagon " + wagon.getRepository().getProtocol() + " does not support optimize upload");
        }
        logger.info((CharSequence)("Uploading " + fileset));
        File zipFile = File.createTempFile("wagon", ".zip");
        try {
            FileSetManager fileSetManager = new FileSetManager(logger, logger.isDebugEnabled());
            String[] files = fileSetManager.getIncludedFiles(fileset);
            if (files.length == 0) {
                logger.info((CharSequence)"Nothing to upload.");
                return;
            }
            logger.info((CharSequence)("Creating " + zipFile + " ..."));
            DefaultWagonUpload.createZip(files, zipFile, fileset.getDirectory());
            String remoteFile = zipFile.getName();
            String remoteDir = fileset.getOutputDirectory();
            if (!StringUtils.isBlank((String)remoteDir)) {
                remoteFile = remoteDir + "/" + remoteFile;
            }
            logger.info((CharSequence)("Uploading " + zipFile + " to " + wagon.getRepository().getUrl() + "/" + remoteFile + " ..."));
            wagon.put(zipFile, remoteFile);
            String command = "unzip -o -qq -d " + remoteDir + " " + remoteFile;
            try {
                logger.info((CharSequence)("Remote: " + command));
                ((CommandExecutor)wagon).executeCommand(command);
            }
            finally {
                command = "rm -f " + remoteFile;
                logger.info((CharSequence)("Remote: " + command));
                ((CommandExecutor)wagon).executeCommand(command);
            }
        }
        finally {
            zipFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createZip(String[] files, File zipName, String basedir) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipName));
        try {
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                file = file.replace('\\', '/');
                DefaultWagonUpload.writeZipEntry(zos, new File(basedir, file), file);
            }
        }
        finally {
            IOUtil.close((OutputStream)zos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeZipEntry(ZipOutputStream jar, File source, String entryName) throws IOException {
        byte[] buffer = new byte[1024];
        FileInputStream is = new FileInputStream(source);
        try {
            int bytesRead;
            ZipEntry entry = new ZipEntry(entryName);
            jar.putNextEntry(entry);
            while ((bytesRead = is.read(buffer)) != -1) {
                jar.write(buffer, 0, bytesRead);
            }
        }
        finally {
            is.close();
        }
    }
}

