/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;

public class UpdateMaven3Mojo
extends AbstractMojo {
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private List<ArtifactRepository> remoteRepositories;
    private ArtifactRepository localRepository;
    private String commonsIoVersion = "2.2";
    private String commonsLangVersion = "2.6";
    private String jsoupVersion = "1.7.2";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.updateMavenLib(this.artifactFactory.createBuildArtifact("commons-io", "commons-io", this.commonsIoVersion, "jar"));
        this.updateMavenLib(this.artifactFactory.createBuildArtifact("commons-lang", "commons-lang", this.commonsLangVersion, "jar"));
        this.updateMavenLib(this.artifactFactory.createBuildArtifact("org.jsoup", "jsoup", this.jsoupVersion, "jar"));
    }

    private void updateMavenLib(Artifact artifact) throws MojoExecutionException {
        try {
            File mavenLibDir = new File(System.getProperty("maven.home"), "lib/ext");
            this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            this.getLog().info((CharSequence)("Copy " + artifact.getFile() + " to " + mavenLibDir));
            FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)mavenLibDir);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to download artifact", e);
        }
    }
}

