/*
 * Decompiled with CFR 0.152.
 */
package com.codehaus.mojo.vfs;

import com.codehaus.mojo.vfs.AbstractVfsMojo;
import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.vfs.internal.DefaultMergeVfsMavenRepositories;

@Mojo(name="merge-maven-repositories", requiresProject=false, threadSafe=true)
public class MergeMavenReposVfsMojo
extends AbstractVfsMojo {
    @Parameter(property="source", required=true)
    private String source;
    @Parameter(property="sourceId", required=false)
    private String sourceId;
    @Parameter(property="destination", required=true)
    private String destination;
    @Parameter(property="destinationId", required=false)
    private String destinationId;
    @Parameter(property="stagingDirectory", required=false, defaultValue="${project.build.directory}/merge-staging")
    private File stagingDirectory;
    @Parameter(property="dryRun", required=false, defaultValue="false")
    private boolean dryRun = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            try {
                FileSystemOptions sourceOpts = this.getFileSystemOptions(this.sourceId, this.source);
                FileSystemOptions destOpts = this.getFileSystemOptions(this.destinationId, this.destination);
                FileObject sourceRepo = this.getFileSystemManager().resolveFile(this.source, sourceOpts);
                FileObject destRepo = this.getFileSystemManager().resolveFile(this.destination, destOpts);
                DefaultMergeVfsMavenRepositories repoMerger = new DefaultMergeVfsMavenRepositories();
                repoMerger.merge(sourceRepo, destRepo, this.stagingDirectory, this.dryRun);
                if (!this.dryRun) return;
                this.getLog().info((CharSequence)("Merging operetion stopped before pushing the final contents at " + this.stagingDirectory + this.destination));
                return;
            }
            catch (Exception e) {
                throw new MojoFailureException("Unable to perform a repositories merge operation", (Throwable)e);
            }
        } else {
            this.getLog().info((CharSequence)"Skip VFS Maven repositories merge operation");
        }
    }
}

