/*
 * Decompiled with CFR 0.152.
 */
package com.codehaus.mojo.vfs;

import com.codehaus.mojo.vfs.AbstractVfsActionMojo;
import com.codehaus.mojo.vfs.MojoVfsFileSet;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.mojo.vfs.BaseFileSet;
import org.codehaus.mojo.vfs.VfsFileSet;
import org.codehaus.mojo.vfs.internal.DefaultVfsFileSetManager;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="copy", requiresProject=true, threadSafe=true)
public class CopyVfsMojo
extends AbstractVfsActionMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.initialize()) {
            return;
        }
        for (MojoVfsFileSet fileset : this.filesets) {
            try {
                FileSystemOptions sourceOpts = this.getFileSystemOptions(fileset.getSourceId(), fileset.getSource());
                FileSystemOptions destOpts = this.getFileSystemOptions(fileset.getDestinationId(), fileset.getDestination());
                VfsFileSet vfsFileSet = new VfsFileSet();
                vfsFileSet.copyBase((BaseFileSet)fileset);
                FileObject sourceObj = this.getFileSystemManager().resolveFile(fileset.getSource(), sourceOpts);
                vfsFileSet.setSource(sourceObj);
                FileObject destObj = this.getFileSystemManager().resolveFile(fileset.getDestination(), destOpts);
                vfsFileSet.setDestination(destObj);
                DefaultVfsFileSetManager fileSetManager = new DefaultVfsFileSetManager();
                fileSetManager.copy(vfsFileSet);
            }
            catch (FileSystemException e) {
                throw new MojoFailureException("Unable to perform a copy operation", (Throwable)e);
            }
            catch (SecDispatcherException e) {
                throw new MojoFailureException("Unable to perform a copy operation", (Throwable)e);
            }
        }
    }
}

