/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.tools.SiteTool;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.testing.stubs.DefaultArtifactHandlerStub;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.utils.VersionStub;
import org.codehaus.plexus.i18n.I18N;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MockUtils {
    private static final Map<String, String[]> DEFAULT_VERSION_MAP = new HashMap<String, String[]>(){
        {
            this.put("artifactA", new String[]{"1.0.0", "2.0.0"});
            this.put("artifactB", new String[]{"1.0.0", "1.1.0"});
            this.put("artifactC", new String[]{"1.0.0"});
        }
    };

    public static RepositorySystem mockAetherRepositorySystem() {
        return MockUtils.mockAetherRepositorySystem(DEFAULT_VERSION_MAP);
    }

    public static RepositorySystem mockAetherRepositorySystem(Map<String, String[]> versionMap) {
        RepositorySystem repositorySystem = (RepositorySystem)Mockito.mock(RepositorySystem.class);
        try {
            Mockito.when((Object)repositorySystem.resolveVersionRange((RepositorySystemSession)ArgumentMatchers.any(), (VersionRangeRequest)ArgumentMatchers.any(VersionRangeRequest.class))).then(invocation -> {
                VersionRangeRequest request = (VersionRangeRequest)invocation.getArgument(1);
                return versionMap.entrySet().stream().filter(e -> ((String)e.getKey()).equals(request.getArtifact().getArtifactId())).findAny().map(e -> Arrays.stream((Object[])e.getValue()).map(VersionStub::new).collect(() -> new ArrayList(), ArrayList::add, ArrayList::addAll)).map(versions -> new VersionRangeResult(request).setVersions((List)versions)).orElse(null);
            });
            Mockito.when((Object)repositorySystem.resolveArtifact((RepositorySystemSession)ArgumentMatchers.any(RepositorySystemSession.class), (ArtifactRequest)ArgumentMatchers.any(ArtifactRequest.class))).then(invocation -> {
                ArtifactRequest request = (ArtifactRequest)invocation.getArgument(1);
                DefaultArtifact copiedArtifact = new DefaultArtifact(request.getArtifact().getGroupId(), request.getArtifact().getArtifactId(), request.getArtifact().getClassifier(), request.getArtifact().getExtension(), request.getArtifact().getVersion());
                copiedArtifact.setFile((File)Mockito.mock(File.class));
                return new ArtifactResult(request).setArtifact((Artifact)copiedArtifact);
            });
        }
        catch (ArtifactResolutionException | VersionRangeResolutionException e) {
            throw new RuntimeException(e);
        }
        return repositorySystem;
    }

    public static I18N mockI18N() {
        I18N i18n = (I18N)Mockito.mock(I18N.class);
        Mockito.when((Object)i18n.getString(ArgumentMatchers.anyString(), (Locale)ArgumentMatchers.any(), ArgumentMatchers.anyString())).thenAnswer(invocation -> invocation.getArgument(2));
        return i18n;
    }

    public static SiteTool mockSiteTool() {
        org.apache.maven.artifact.Artifact skinArtifact = (org.apache.maven.artifact.Artifact)Mockito.mock(org.apache.maven.artifact.Artifact.class);
        Mockito.when((Object)skinArtifact.getId()).thenReturn((Object)"");
        SiteTool siteTool = (SiteTool)Mockito.mock(SiteTool.class);
        try {
            Mockito.when((Object)siteTool.getSkinArtifactFromRepository((ArtifactRepository)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (DecorationModel)ArgumentMatchers.any())).thenReturn((Object)skinArtifact);
        }
        catch (SiteToolException e) {
            throw new RuntimeException(e);
        }
        return siteTool;
    }

    public static org.apache.maven.repository.RepositorySystem mockRepositorySystem() {
        org.apache.maven.repository.RepositorySystem repositorySystem = (org.apache.maven.repository.RepositorySystem)Mockito.mock(org.apache.maven.repository.RepositorySystem.class);
        Mockito.when((Object)repositorySystem.createDependencyArtifact((Dependency)ArgumentMatchers.any(Dependency.class))).thenAnswer(invocation -> {
            Dependency dependency = (Dependency)invocation.getArgument(0);
            return new org.apache.maven.artifact.DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType(), dependency.getClassifier(), (ArtifactHandler)new DefaultArtifactHandlerStub("default"));
        });
        return repositorySystem;
    }

    public static MavenSession mockMavenSession() {
        MavenSession session = (MavenSession)Mockito.mock(MavenSession.class);
        Mockito.when((Object)session.getRepositorySession()).thenReturn(Mockito.mock(RepositorySystemSession.class));
        Mockito.when((Object)session.getCurrentProject()).thenReturn(Mockito.mock(MavenProject.class));
        Mockito.when((Object)session.getCurrentProject().getRemotePluginRepositories()).thenReturn(Collections.emptyList());
        Mockito.when((Object)session.getCurrentProject().getRemoteProjectRepositories()).thenReturn(Collections.emptyList());
        return session;
    }
}

