/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting.model.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.codehaus.mojo.versions.reporting.model.PropertyAssociation;
import org.codehaus.mojo.versions.reporting.model.PropertyInfo;
import org.codehaus.mojo.versions.reporting.model.PropertyReportSummary;
import org.codehaus.mojo.versions.reporting.model.PropertyUpdatesReport;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class PropertyUpdatesReportXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public PropertyUpdatesReportXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public PropertyUpdatesReportXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public PropertyUpdatesReport read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public PropertyUpdatesReport read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public PropertyUpdatesReport read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict);
    }

    public PropertyUpdatesReport read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in));
    }

    private PropertyAssociation parsePropertyAssociation(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PropertyAssociation propertyAssociation = new PropertyAssociation();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                propertyAssociation.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                propertyAssociation.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return propertyAssociation;
    }

    private PropertyInfo parsePropertyInfo(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PropertyInfo propertyInfo = new PropertyInfo();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "propertyName", null, parsed)) {
                propertyInfo.setPropertyName(this.interpolatedTrimmed(parser.nextText(), "propertyName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "propertyAssociations", null, parsed)) {
                ArrayList<PropertyAssociation> propertyAssociations = new ArrayList<PropertyAssociation>();
                propertyInfo.setPropertyAssociations(propertyAssociations);
                while (parser.nextTag() == 2) {
                    if ("propertyAssociation".equals(parser.getName())) {
                        propertyAssociations.add(this.parsePropertyAssociation(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "currentVersion", null, parsed)) {
                propertyInfo.setCurrentVersion(this.interpolatedTrimmed(parser.nextText(), "currentVersion"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "lastVersion", null, parsed)) {
                propertyInfo.setLastVersion(this.interpolatedTrimmed(parser.nextText(), "lastVersion"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "any", null, parsed)) {
                ArrayList<String> any = new ArrayList<String>();
                propertyInfo.setAny(any);
                while (parser.nextTag() == 2) {
                    if ("any".equals(parser.getName())) {
                        any.add(this.interpolatedTrimmed(parser.nextText(), "any"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "incrementals", null, parsed)) {
                ArrayList<String> incrementals = new ArrayList<String>();
                propertyInfo.setIncrementals(incrementals);
                while (parser.nextTag() == 2) {
                    if ("incremental".equals(parser.getName())) {
                        incrementals.add(this.interpolatedTrimmed(parser.nextText(), "incrementals"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "minors", null, parsed)) {
                ArrayList<String> minors = new ArrayList<String>();
                propertyInfo.setMinors(minors);
                while (parser.nextTag() == 2) {
                    if ("minor".equals(parser.getName())) {
                        minors.add(this.interpolatedTrimmed(parser.nextText(), "minors"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "majors", null, parsed)) {
                ArrayList<String> majors = new ArrayList<String>();
                propertyInfo.setMajors(majors);
                while (parser.nextTag() == 2) {
                    if ("major".equals(parser.getName())) {
                        majors.add(this.interpolatedTrimmed(parser.nextText(), "majors"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "status", null, parsed)) {
                propertyInfo.setStatus(this.interpolatedTrimmed(parser.nextText(), "status"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return propertyInfo;
    }

    private PropertyReportSummary parsePropertyReportSummary(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PropertyReportSummary propertyReportSummary = new PropertyReportSummary();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "usingLastVersion", null, parsed)) {
                propertyReportSummary.setUsingLastVersion(this.interpolatedTrimmed(parser.nextText(), "usingLastVersion"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nextVersionAvailable", null, parsed)) {
                propertyReportSummary.setNextVersionAvailable(this.interpolatedTrimmed(parser.nextText(), "nextVersionAvailable"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nextIncrementalAvailable", null, parsed)) {
                propertyReportSummary.setNextIncrementalAvailable(this.interpolatedTrimmed(parser.nextText(), "nextIncrementalAvailable"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nextMinorAvailable", null, parsed)) {
                propertyReportSummary.setNextMinorAvailable(this.interpolatedTrimmed(parser.nextText(), "nextMinorAvailable"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "nextMajorAvailable", null, parsed)) {
                propertyReportSummary.setNextMajorAvailable(this.interpolatedTrimmed(parser.nextText(), "nextMajorAvailable"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return propertyReportSummary;
    }

    private PropertyUpdatesReport parsePropertyUpdatesReport(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PropertyUpdatesReport propertyUpdatesReport = new PropertyUpdatesReport();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "summary", null, parsed)) {
                propertyUpdatesReport.setSummary(this.parsePropertyReportSummary(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                ArrayList<PropertyInfo> properties = new ArrayList<PropertyInfo>();
                propertyUpdatesReport.setProperties(properties);
                while (parser.nextTag() == 2) {
                    if ("property".equals(parser.getName())) {
                        properties.add(this.parsePropertyInfo(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return propertyUpdatesReport;
    }

    private PropertyUpdatesReport read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        PropertyUpdatesReport propertyUpdatesReport = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"PropertyUpdatesReport".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'PropertyUpdatesReport' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'PropertyUpdatesReport'", parser, null);
                }
                propertyUpdatesReport = this.parsePropertyUpdatesReport(parser, strict);
                propertyUpdatesReport.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return propertyUpdatesReport;
        }
        throw new XmlPullParserException("Expected root element 'PropertyUpdatesReport' but found no element at all: invalid XML document", parser, null);
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

