/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.maven.enforcer.rule.api.EnforcerLevel;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRule2;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.filtering.DependencyFilter;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.MavenProjectUtils;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class MaxDependencyUpdates
implements EnforcerRule2 {
    protected int maxUpdates = 0;
    protected boolean processDependencies = true;
    protected boolean processDependencyManagement = true;
    protected boolean processDependencyManagementTransitive = true;
    protected boolean processPluginDependencies = true;
    protected boolean processPluginDependenciesInPluginManagement = true;
    protected boolean ignoreMinorUpdates = false;
    protected boolean ignoreIncrementalUpdates = false;
    protected boolean ignoreSubIncrementalUpdates = false;
    protected List<String> dependencyIncludes = Collections.singletonList("*");
    protected List<String> dependencyExcludes = Collections.emptyList();
    protected List<String> dependencyManagementIncludes = Collections.singletonList("*");
    protected List<String> dependencyManagementExcludes = Collections.emptyList();
    protected List<String> pluginDependencyIncludes = Collections.singletonList("*");
    protected List<String> pluginDependencyExcludes = Collections.emptyList();
    protected List<String> pluginManagementDependencyIncludes = Collections.singletonList("*");
    protected List<String> pluginManagementDependencyExcludes = Collections.emptyList();
    private String serverId;
    private String rulesUri;
    protected RuleSet ruleSet;
    protected boolean allowSnapshots;

    private static MavenProject getMavenProject(EnforcerRuleHelper ruleHelper) {
        try {
            return (MavenProject)ruleHelper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException e) {
            throw new RuntimeException("Cannot evaluate project metadata", e);
        }
    }

    private static VersionsHelper createVersionsHelper(EnforcerRuleHelper ruleHelper, String serverId, String rulesUri, RuleSet ruleSet) {
        try {
            return new DefaultVersionsHelper.Builder().withRepositorySystem((RepositorySystem)ruleHelper.getComponent(RepositorySystem.class)).withAetherRepositorySystem((org.eclipse.aether.RepositorySystem)ruleHelper.getComponent(org.eclipse.aether.RepositorySystem.class)).withWagonMap((Map)ruleHelper.getComponentMap(Wagon.class.getName()).entrySet().stream().filter(e -> e.getValue() instanceof Wagon).collect(HashMap::new, (m, e) -> m.put(e.getKey(), (Wagon)e.getValue()), HashMap::putAll)).withServerId(serverId).withRulesUri(rulesUri).withRuleSet(ruleSet).withIgnoredVersions(null).withLog(ruleHelper.getLog()).withMavenSession((MavenSession)ruleHelper.evaluate("${session}")).withMojoExecution((MojoExecution)ruleHelper.evaluate("${mojoExecution}")).build();
        }
        catch (ExpressionEvaluationException e2) {
            throw new RuntimeException("Cannot evaluate project metadata", e2);
        }
        catch (MojoExecutionException | ComponentLookupException e3) {
            throw new RuntimeException("Cannot resolve dependency", e3);
        }
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "Does not matter as not cacheable";
    }

    public void execute(EnforcerRuleHelper ruleHelper) throws EnforcerRuleException {
        VersionsHelper versionsHelper = MaxDependencyUpdates.createVersionsHelper(ruleHelper, this.serverId != null ? this.serverId : "serverId", this.rulesUri, this.ruleSet);
        MavenProject project = MaxDependencyUpdates.getMavenProject(ruleHelper);
        TreeSet dependencies = new TreeSet(DependencyComparator.INSTANCE);
        if (this.processDependencyManagement) {
            try {
                dependencies.addAll(DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractDependenciesFromDependencyManagement((MavenProject)project, (boolean)this.processDependencyManagementTransitive, (Log)ruleHelper.getLog()), this.dependencyManagementIncludes, this.dependencyManagementExcludes, (String)"Dependency Management", (Log)ruleHelper.getLog()));
            }
            catch (VersionRetrievalException e) {
                throw new EnforcerRuleException(e.getMessage());
            }
        }
        if (this.processPluginDependencies) {
            dependencies.addAll(DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractDependenciesFromPlugins((MavenProject)project), this.pluginDependencyIncludes, this.pluginDependencyExcludes, (String)"Plugin Dependencies", (Log)ruleHelper.getLog()));
        }
        if (this.processPluginDependenciesInPluginManagement) {
            dependencies.addAll(DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractPluginDependenciesFromPluginsInPluginManagement((MavenProject)project), this.pluginManagementDependencyIncludes, this.pluginManagementDependencyExcludes, (String)"Plugin Management Dependencies", (Log)ruleHelper.getLog()));
        }
        if (this.processDependencies) {
            dependencies.addAll(DependencyFilter.filterDependencies((Collection)project.getDependencies(), this.dependencyIncludes, this.dependencyExcludes, (String)"Dependencies", (Log)ruleHelper.getLog()));
        }
        try {
            Optional<Segment> ignoredSegment = this.ignoreSubIncrementalUpdates ? Optional.of(Segment.SUBINCREMENTAL) : (this.ignoreIncrementalUpdates ? Optional.of(Segment.INCREMENTAL) : (this.ignoreMinorUpdates ? Optional.of(Segment.MINOR) : Optional.empty()));
            List upgradable = versionsHelper.lookupDependenciesUpdates(dependencies, false, this.allowSnapshots).values().stream().filter(v -> v.getVersions(v.restrictionForIgnoreScope(ignoredSegment), true).length > 0).collect(Collectors.toList());
            if (upgradable.size() > this.maxUpdates) {
                throw new EnforcerRuleException("More than " + this.maxUpdates + " upgradable artifacts detected: " + upgradable.stream().map(av -> av.getArtifact() + " -> [" + Arrays.stream(av.getVersions(this.allowSnapshots)).map(Object::toString).collect(Collectors.joining(", ")) + "]").collect(Collectors.joining(", ")));
            }
        }
        catch (VersionRetrievalException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public EnforcerLevel getLevel() {
        return EnforcerLevel.ERROR;
    }
}

