/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.io.File;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;

@Named
public class ArtifactFactory {
    private final ArtifactHandlerManager artifactHandlerManager;

    @Inject
    public ArtifactFactory(ArtifactHandlerManager artifactHandlerManager) {
        this.artifactHandlerManager = artifactHandlerManager;
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String type, String classifier, String scope, boolean optional) {
        try {
            return new DefaultArtifact(groupId, artifactId, VersionRange.createFromVersionSpec((String)(StringUtils.isNotBlank((CharSequence)version) ? version : "[0,]")), scope, type, classifier, this.artifactHandlerManager.getArtifactHandler(type), optional);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    public Artifact createMavenPluginArtifact(String groupId, String artifactId, String version) {
        return this.createArtifact(groupId, artifactId, version, "maven-plugin", null, "runtime", false);
    }

    public Artifact createArtifact(Dependency dependency) {
        Artifact artifact = this.createArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getClassifier(), dependency.getScope(), false);
        if ("system".equals(dependency.getScope()) && dependency.getSystemPath() != null) {
            artifact.setFile(new File(dependency.getSystemPath()));
        }
        return artifact;
    }
}

