/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.filtering.DependencyFilter;
import org.codehaus.mojo.versions.internal.DependencyUpdatesLoggingHelper;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.MavenProjectUtils;
import org.codehaus.mojo.versions.utils.SegmentUtils;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="display-dependency-updates", threadSafe=true)
public class DisplayDependencyUpdatesMojo
extends AbstractVersionsDisplayMojo {
    @Parameter(property="processDependencyManagement", defaultValue="true")
    protected boolean processDependencyManagement = true;
    @Parameter(property="processDependencyManagementTransitive", defaultValue="true")
    protected boolean processDependencyManagementTransitive = true;
    @Parameter(property="showVersionless", defaultValue="true")
    protected boolean showVersionless = true;
    @Parameter(property="dependencyManagementIncludes", defaultValue="*")
    private List<String> dependencyManagementIncludes;
    @Parameter(property="dependencyManagementExcludes")
    private List<String> dependencyManagementExcludes;
    @Parameter(property="processDependencies", defaultValue="true")
    protected boolean processDependencies;
    @Parameter(property="dependencyIncludes", defaultValue="*")
    protected List<String> dependencyIncludes;
    @Parameter(property="dependencyExcludes")
    protected List<String> dependencyExcludes;
    @Parameter(property="processPluginDependencies", defaultValue="true")
    private boolean processPluginDependencies;
    @Parameter(property="processPluginDependenciesInPluginManagement", defaultValue="true")
    private boolean processPluginDependenciesInPluginManagement;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    protected boolean allowMajorUpdates = true;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    protected boolean allowMinorUpdates = true;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates = true;
    @Parameter(property="verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="pluginDependencyIncludes", defaultValue="*")
    private List<String> pluginDependencyIncludes;
    @Parameter(property="pluginDependencyExcludes")
    private List<String> pluginDependencyExcludes;
    @Parameter(property="pluginManagementDependencyIncludes", defaultValue="*")
    private List<String> pluginManagementDependencyIncludes;
    @Parameter(property="pluginManagementDependencyExcludes")
    private List<String> pluginManagementDependencyExcludes;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;

    @Inject
    public DisplayDependencyUpdatesMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    protected static boolean dependenciesMatch(Dependency dependency, Dependency managedDependency) {
        if (!managedDependency.getGroupId().equals(dependency.getGroupId())) {
            return false;
        }
        if (!managedDependency.getArtifactId().equals(dependency.getArtifactId())) {
            return false;
        }
        if (managedDependency.getScope() == null || Objects.equals(managedDependency.getScope(), dependency.getScope())) {
            return false;
        }
        if (managedDependency.getClassifier() == null || Objects.equals(managedDependency.getClassifier(), dependency.getClassifier())) {
            return false;
        }
        return dependency.getVersion() == null || managedDependency.getVersion() == null || Objects.equals(managedDependency.getVersion(), dependency.getVersion());
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.logInit();
        this.validateInput();
        try {
            Set dependencyManagement;
            if (this.processDependencyManagement) {
                dependencyManagement = DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractDependenciesFromDependencyManagement((MavenProject)this.getProject(), (boolean)this.processDependencyManagementTransitive, (Log)this.getLog()), this.dependencyManagementIncludes, this.dependencyManagementExcludes, (String)"Dependecy Management", (Log)this.getLog());
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(dependencyManagement.stream().filter(d -> d.getVersion() != null), false, this.allowSnapshots), "Dependency Management");
            } else {
                dependencyManagement = Collections.emptySet();
            }
            if (this.processDependencies) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(DependencyFilter.filterDependencies((Collection)this.getProject().getDependencies().stream().filter(dep -> dependencyManagement.stream().noneMatch(depMan -> DisplayDependencyUpdatesMojo.dependenciesMatch(dep, depMan))).filter(dep -> this.showVersionless || MavenProjectUtils.dependencyVersionLocalToReactor((Dependency)dep)).collect(() -> new TreeSet(DependencyComparator.INSTANCE), Set::add, Set::addAll), this.dependencyIncludes, this.dependencyExcludes, (String)"Dependencies", (Log)this.getLog()).stream().filter(d -> d.getVersion() != null), false, this.allowSnapshots), "Dependencies");
            }
            if (this.processPluginDependenciesInPluginManagement) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractPluginDependenciesFromPluginsInPluginManagement((MavenProject)this.getProject()), this.pluginManagementDependencyIncludes, this.pluginManagementDependencyExcludes, (String)"Plugin Management Dependencies", (Log)this.getLog()).stream().filter(d -> d.getVersion() != null), false, this.allowSnapshots), "pluginManagement of plugins");
            }
            if (this.processPluginDependencies) {
                this.logUpdates(this.getHelper().lookupDependenciesUpdates(DependencyFilter.filterDependencies((Collection)MavenProjectUtils.extractDependenciesFromPlugins((MavenProject)this.getProject()), this.pluginDependencyIncludes, this.pluginDependencyExcludes, (String)"Plugin Dependencies", (Log)this.getLog()).stream().filter(d -> d.getVersion() != null), false, this.allowSnapshots), "Plugin Dependencies");
            }
        }
        catch (VersionRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    protected void validateInput() throws MojoExecutionException {
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyIncludes, 6, "dependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyExcludes, 6, "dependencyExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyManagementIncludes, 6, "dependencyManagementIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.dependencyManagementExcludes, 6, "dependencyManagementExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginDependencyIncludes, 3, "pluginDependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginDependencyExcludes, 3, "pluginDependencyExcludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginManagementDependencyIncludes, 3, "pluginManagementDependencyIncludes");
        DisplayDependencyUpdatesMojo.validateGAVList(this.pluginManagementDependencyExcludes, 3, "pluginManagementDependencyExcludes");
    }

    static void validateGAVList(List<String> gavList, int numSections, String argumentName) throws MojoExecutionException {
        if (gavList != null && gavList.stream().anyMatch(gav -> StringUtils.countMatches((CharSequence)gav, (CharSequence)":") >= numSections)) {
            throw new MojoExecutionException(argumentName + " should not contain more than 6 segments");
        }
    }

    private void logUpdates(Map<Dependency, ArtifactVersions> versionMap, String section) {
        Optional unchangedSegment = SegmentUtils.determineUnchangedSegment((boolean)this.allowMajorUpdates, (boolean)this.allowMinorUpdates, (boolean)this.allowIncrementalUpdates, (Log)this.getLog());
        DependencyUpdatesLoggingHelper.DependencyUpdatesResult updates = DependencyUpdatesLoggingHelper.getDependencyUpdates(this.getProject(), versionMap, this.allowSnapshots, unchangedSegment, 72 + this.getOutputLineWidthOffset(), this.verbose);
        if (this.verbose) {
            if (updates.getUsingLatest().isEmpty()) {
                if (!updates.getWithUpdates().isEmpty()) {
                    this.logLine(false, "No dependencies in " + section + " are using the newest version.");
                    this.logLine(false, "");
                }
            } else {
                this.logLine(false, "The following dependencies in " + section + " are using the newest version:");
                updates.getUsingLatest().forEach(s -> this.logLine(false, (String)s));
                this.logLine(false, "");
            }
        }
        if (updates.getWithUpdates().isEmpty()) {
            if (!updates.getUsingLatest().isEmpty()) {
                this.logLine(false, "No dependencies in " + section + " have newer versions.");
                this.logLine(false, "");
            }
        } else {
            this.logLine(false, "The following dependencies in " + section + " have newer versions:");
            updates.getWithUpdates().forEach(s -> this.logLine(false, (String)s));
            this.logLine(false, "");
        }
    }

    @Override
    protected void update(MutableXMLStreamReader pom) {
    }
}

