/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.utils.DefaultArtifactVersionCache;
import org.codehaus.plexus.util.xml.Xpp3Dom;

class MinimalMavenBuildVersionFinder {
    private MinimalMavenBuildVersionFinder() {
    }

    static ArtifactVersion find(MavenProject mavenProject, String defaultVersion, Log log) {
        ArtifactVersion version = MinimalMavenBuildVersionFinder.getEnforcerMavenVersion(mavenProject, log);
        if (version == null && defaultVersion != null) {
            version = DefaultArtifactVersionCache.of((String)defaultVersion);
        }
        return version;
    }

    private static ArtifactVersion getEnforcerMavenVersion(MavenProject mavenProject, Log log) {
        List buildPlugins = mavenProject.getBuildPlugins();
        if (null == buildPlugins) {
            log.debug((CharSequence)"MinimalMavenBuildVersionFinder: No build plugins found");
            return null;
        }
        Plugin mavenEnforcerPlugin = MinimalMavenBuildVersionFinder.getMavenEnforcerPlugin(buildPlugins);
        if (null == mavenEnforcerPlugin) {
            log.debug((CharSequence)"MinimalMavenBuildVersionFinder: No maven-enforcer-plugin used");
            return null;
        }
        List pluginExecutions = mavenEnforcerPlugin.getExecutions();
        if (null == pluginExecutions) {
            log.debug((CharSequence)"MinimalMavenBuildVersionFinder: No executions of maven-enforcer-plugin found");
            return null;
        }
        List<PluginExecution> pluginExecutionsWithEnforceGoal = MinimalMavenBuildVersionFinder.getPluginExecutionsWithEnforceGoal(pluginExecutions);
        if (pluginExecutionsWithEnforceGoal.isEmpty()) {
            log.debug((CharSequence)"MinimalMavenBuildVersionFinder: No 'enforce' execution of maven-enforcer-plugin found");
            return null;
        }
        Xpp3Dom requireMavenVersionTag = MinimalMavenBuildVersionFinder.getRequireMavenVersionTag(pluginExecutionsWithEnforceGoal);
        if (null == requireMavenVersionTag) {
            log.debug((CharSequence)"MinimalMavenBuildVersionFinder: No 'requireMavenVersion' rule of maven-enforcer-plugin found");
            return null;
        }
        Xpp3Dom versionTag = requireMavenVersionTag.getChild("version");
        if (null == versionTag) {
            log.debug((CharSequence)"MinimalMavenBuildVersionFinder: No version specified in 'requireMavenVersion' rule of maven-enforcer-plugin");
            return null;
        }
        String versionTagValue = versionTag.getValue();
        if (null == versionTagValue || "".equals(versionTagValue)) {
            log.debug((CharSequence)"MinimalMavenBuildVersionFinder: Empty version specified in 'requireMavenVersion' rule of maven-enforcer-plugin");
            return null;
        }
        ArtifactVersion minimumVersion = MinimalMavenBuildVersionFinder.getMinimumVersionFromRange(versionTagValue);
        log.debug((CharSequence)("Calculated minimum version " + minimumVersion + " from version parameter value '" + versionTagValue + "'"));
        return minimumVersion;
    }

    private static Plugin getMavenEnforcerPlugin(List<Plugin> buildPlugins) {
        for (Plugin plugin : buildPlugins) {
            if (!"maven-enforcer-plugin".equals(plugin.getArtifactId()) || !"org.apache.maven.plugins".equals(plugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    private static List<PluginExecution> getPluginExecutionsWithEnforceGoal(List<PluginExecution> executions) {
        ArrayList<PluginExecution> pluginExecutions = new ArrayList<PluginExecution>();
        for (PluginExecution pluginExecution : executions) {
            List goals = pluginExecution.getGoals();
            if (goals == null || !goals.contains("enforce")) continue;
            pluginExecutions.add(pluginExecution);
        }
        return pluginExecutions;
    }

    private static Xpp3Dom getRequireMavenVersionTag(List<PluginExecution> executions) {
        for (PluginExecution pluginExecution : executions) {
            Xpp3Dom requireMavenVersionTag;
            Xpp3Dom rulesTag;
            Xpp3Dom configurationTag = (Xpp3Dom)pluginExecution.getConfiguration();
            if (null == configurationTag || null == (rulesTag = configurationTag.getChild("rules")) || null == (requireMavenVersionTag = rulesTag.getChild("requireMavenVersion"))) continue;
            return requireMavenVersionTag;
        }
        return null;
    }

    static ArtifactVersion getMinimumVersionFromRange(String versionRange) {
        int openIndicesCount = 0;
        int closeIndicesCount = 0;
        for (int i = 0; i < versionRange.length(); ++i) {
            char character = versionRange.charAt(i);
            if ('(' == character || '[' == character) {
                ++openIndicesCount;
                continue;
            }
            if (')' != character && ']' != character) continue;
            ++closeIndicesCount;
        }
        if (openIndicesCount != closeIndicesCount) {
            return null;
        }
        if (openIndicesCount == 0) {
            return DefaultArtifactVersionCache.of((String)versionRange);
        }
        if (versionRange.charAt(0) != '[' && versionRange.charAt(0) != '(' || versionRange.charAt(versionRange.length() - 1) != ']' && versionRange.charAt(versionRange.length() - 1) != ')') {
            return null;
        }
        if (openIndicesCount != 1) {
            return null;
        }
        String innerString = versionRange.substring(1, versionRange.length() - 1);
        int commaIndex = innerString.indexOf(44);
        if (commaIndex == -1) {
            if (versionRange.charAt(0) == '[' && versionRange.charAt(versionRange.length() - 1) == ']') {
                return DefaultArtifactVersionCache.of((String)innerString);
            }
            return null;
        }
        if (commaIndex == 0) {
            return null;
        }
        if (commaIndex == innerString.length() - 1) {
            String minimumVersion = innerString.substring(0, innerString.length() - 1);
            if (versionRange.charAt(0) == '[' && versionRange.charAt(versionRange.length() - 1) == ')') {
                return DefaultArtifactVersionCache.of((String)minimumVersion);
            }
            if (versionRange.charAt(0) == '(' && versionRange.charAt(versionRange.length() - 1) == ')') {
                return DefaultArtifactVersionCache.of((String)minimumVersion);
            }
            return null;
        }
        String minimumVersion = innerString.substring(0, commaIndex);
        if (versionRange.charAt(0) == '[') {
            return DefaultArtifactVersionCache.of((String)minimumVersion);
        }
        if (versionRange.charAt(0) == '(') {
            return DefaultArtifactVersionCache.of((String)minimumVersion);
        }
        return null;
    }
}

