/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Settings;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.DefaultVersionsHelper;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.model.RuleSet;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.recording.ChangeRecorder;
import org.codehaus.mojo.versions.recording.ChangeRecorderNull;
import org.codehaus.mojo.versions.recording.ChangeRecorderXML;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;

public abstract class AbstractVersionsUpdaterMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    protected RepositorySystem repositorySystem;
    protected MavenProjectBuilder projectBuilder;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    protected ArtifactMetadataSource artifactMetadataSource;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(defaultValue="${project.pluginArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> remotePluginRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    protected ArtifactRepository localRepository;
    private WagonManager wagonManager;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="maven.version.rules.serverId", defaultValue="serverId")
    private String serverId;
    @Parameter(property="maven.version.rules")
    private String rulesUri;
    @Parameter(property="generateBackupPoms", defaultValue="true")
    private boolean generateBackupPoms;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;
    private VersionsHelper helper;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    private MojoExecution mojoExecution;
    protected ArtifactResolver artifactResolver;
    @Parameter(property="changeRecorderFormat", defaultValue="none")
    private String changeRecorderFormat = "none";
    @Parameter(property="changeRecorderOutputFile", defaultValue="${project.build.directory}/versions-changes.xml")
    private File changeRecorderOutputFile;
    private ChangeRecorder changeRecorder;
    @Parameter
    protected RuleSet ruleSet;
    @Parameter(property="maven.version.ignore")
    protected Set<String> ignoredVersions;

    @Inject
    protected AbstractVersionsUpdaterMojo(RepositorySystem repositorySystem, MavenProjectBuilder projectBuilder, ArtifactMetadataSource artifactMetadataSource, WagonManager wagonManager, ArtifactResolver artifactResolver) {
        this.repositorySystem = repositorySystem;
        this.projectBuilder = projectBuilder;
        this.artifactMetadataSource = artifactMetadataSource;
        this.wagonManager = wagonManager;
        this.artifactResolver = artifactResolver;
    }

    public VersionsHelper getHelper() throws MojoExecutionException {
        if (this.helper == null) {
            this.helper = new DefaultVersionsHelper.Builder().withRepositorySystem(this.repositorySystem).withArtifactResolver(this.artifactResolver).withArtifactMetadataSource(this.artifactMetadataSource).withRemoteArtifactRepositories(this.remoteArtifactRepositories).withRemotePluginRepositories(this.remotePluginRepositories).withLocalRepository(this.localRepository).withWagonManager(this.wagonManager).withSettings(this.settings).withServerId(this.serverId).withRulesUri(this.rulesUri).withRuleSet(this.ruleSet).withIgnoredVersions(this.ignoredVersions).withLog(this.getLog()).withMavenSession(this.session).withMojoExecution(this.mojoExecution).build();
        }
        return this.helper;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getVersion() {
        return this.getProject() == null ? null : this.getProject().getVersion();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        File outFile = this.project.getFile();
        this.process(outFile);
    }

    protected ArtifactVersion findLatestVersion(Artifact artifact, VersionRange versionRange, Boolean allowingSnapshots, boolean usePluginRepositories) throws ArtifactMetadataRetrievalException, MojoExecutionException {
        boolean includeSnapshots = allowingSnapshots != null ? allowingSnapshots : this.allowSnapshots;
        ArtifactVersions artifactVersions = this.getHelper().lookupArtifactVersions(artifact, usePluginRepositories);
        return artifactVersions.getNewestVersion(versionRange, null, includeSnapshots, false);
    }

    protected String getPropertyValue(StringBuilder pom, String property) {
        return this.project.getProperties().getProperty(property);
    }

    protected void process(File outFile) throws MojoExecutionException, MojoFailureException {
        try {
            StringBuilder input = PomHelper.readXmlFile(outFile);
            ModifiedPomXMLEventReader newPom = this.newModifiedPomXER(input, outFile.getAbsolutePath());
            this.update(newPom);
            if (newPom.isModified()) {
                if (this.generateBackupPoms) {
                    File backupFile = new File(outFile.getParentFile(), outFile.getName() + ".versionsBackup");
                    if (!backupFile.exists()) {
                        this.getLog().debug((CharSequence)("Backing up " + outFile + " to " + backupFile));
                        FileUtils.copyFile((File)outFile, (File)backupFile);
                    } else {
                        this.getLog().debug((CharSequence)("Leaving existing backup " + backupFile + " unmodified"));
                    }
                } else {
                    this.getLog().debug((CharSequence)"Skipping generation of backup file");
                }
                this.writeFile(outFile, input);
            }
            this.saveChangeRecorderResults();
        }
        catch (IOException | XMLStreamException e) {
            this.getLog().error((Throwable)e);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected final ModifiedPomXMLEventReader newModifiedPomXER(StringBuilder input, String path) {
        ModifiedPomXMLEventReader newPom = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
            inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
            newPom = new ModifiedPomXMLEventReader(input, inputFactory, path);
        }
        catch (XMLStreamException e) {
            this.getLog().error((Throwable)e);
        }
        return newPom;
    }

    protected final void writeFile(File outFile, StringBuilder input) throws IOException {
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((File)outFile);){
            IOUtil.copy((String)input.toString(), (Writer)writer);
        }
    }

    protected abstract void update(ModifiedPomXMLEventReader var1) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException;

    @Deprecated
    protected boolean shouldApplyUpdate(Artifact artifact, String currentVersion, ArtifactVersion updateVersion) {
        return this.shouldApplyUpdate(artifact, currentVersion, updateVersion, false);
    }

    protected boolean shouldApplyUpdate(Artifact artifact, String currentVersion, ArtifactVersion updateVersion, boolean forceUpdate) {
        this.getLog().debug((CharSequence)("Proposal is to update from " + currentVersion + " to " + updateVersion));
        if (updateVersion == null) {
            this.getLog().warn((CharSequence)"Not updating version: could not resolve any versions");
            return false;
        }
        if (forceUpdate) {
            this.getLog().info((CharSequence)"Force update enabled. LATEST or RELEASE versions will be overwritten with real version");
            return true;
        }
        artifact.setVersion(updateVersion.toString());
        try {
            this.artifactResolver.resolveAlways(artifact, this.remoteArtifactRepositories, this.localRepository);
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Not updating version: could not resolve " + artifact), (Throwable)e);
            return false;
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().warn((CharSequence)("Not updating version: could not find " + artifact), (Throwable)e);
            return false;
        }
        if (currentVersion.equals(updateVersion.toString())) {
            this.getLog().info((CharSequence)("Current version of " + artifact + " is the latest."));
            return false;
        }
        return true;
    }

    protected ArtifactVersion updatePropertyToNewestVersion(ModifiedPomXMLEventReader pom, Property property, PropertyVersions version, String currentVersion, boolean allowDowngrade, Optional<Segment> unchangedSegment) throws XMLStreamException, InvalidVersionSpecificationException, InvalidSegmentException, MojoExecutionException {
        ArtifactVersion winner = version.getNewestVersion(currentVersion, property, this.allowSnapshots, this.reactorProjects, this.getHelper(), allowDowngrade, unchangedSegment);
        if (winner == null || currentVersion.equals(winner.toString())) {
            this.getLog().info((CharSequence)("Property ${" + property.getName() + "}: Leaving unchanged as " + currentVersion));
        } else if (PomHelper.setPropertyVersion(pom, version.getProfileId(), property.getName(), winner.toString())) {
            this.getLog().info((CharSequence)("Updated ${" + property.getName() + "} from " + currentVersion + " to " + winner));
        }
        return winner;
    }

    protected ChangeRecorder getChangeRecorder() throws MojoExecutionException {
        if (this.changeRecorder == null) {
            if ("none".equals(this.changeRecorderFormat)) {
                this.changeRecorder = ChangeRecorderNull.create();
            } else if ("xml".equals(this.changeRecorderFormat)) {
                this.changeRecorder = ChangeRecorderXML.create();
            } else {
                throw new MojoExecutionException("Only 'xml' or 'none' formats are supported for change recordings");
            }
        }
        return this.changeRecorder;
    }

    protected void saveChangeRecorderResults() throws IOException {
        if (this.changeRecorder == null) {
            return;
        }
        if ("none".equals(this.changeRecorderFormat)) {
            return;
        }
        this.getLog().debug((CharSequence)("writing change record to " + this.changeRecorderOutputFile));
        this.changeRecorderOutputFile.getParentFile().mkdirs();
        try (FileOutputStream outputStream = new FileOutputStream(this.changeRecorderOutputFile);){
            this.changeRecorder.serialize(outputStream);
        }
    }
}

