/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.DefaultArtifactAssociation;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;
import org.codehaus.mojo.versions.ordering.VersionComparator;

class PropertyVersionsBuilder {
    private final String name;
    private final String profileId;
    private final Set<ArtifactAssociation> associations;
    private final VersionsHelper helper;
    private final Map<String, Boolean> upperBounds = new LinkedHashMap<String, Boolean>();
    private final Map<String, Boolean> lowerBounds = new LinkedHashMap<String, Boolean>();

    public PropertyVersionsBuilder(String profileId, String name, VersionsHelper helper) {
        this.profileId = profileId;
        this.name = name;
        this.associations = new TreeSet<ArtifactAssociation>();
        this.helper = helper;
    }

    public void addAssociation(Artifact artifact, boolean usePluginRepositories) {
        this.associations.add(new DefaultArtifactAssociation(artifact, usePluginRepositories));
    }

    public void removeAssociation(Artifact artifact, boolean usePluginRepositories) {
        this.associations.remove(new DefaultArtifactAssociation(artifact, usePluginRepositories));
    }

    public void clearAssociations() {
        this.associations.clear();
    }

    public boolean isAssociated() {
        return !this.associations.isEmpty();
    }

    public ArtifactAssociation[] getAssociations() {
        return this.associations.toArray(new ArtifactAssociation[this.associations.size()]);
    }

    public PropertyVersions newPropertyVersions() throws ArtifactMetadataRetrievalException {
        return new PropertyVersions(this.profileId, this.name, this.helper, this.associations);
    }

    public String getName() {
        return this.name;
    }

    public String getVersionRange() {
        PropertyVersionComparator comparator = new PropertyVersionComparator();
        if (this.lowerBounds.isEmpty() && this.upperBounds.isEmpty()) {
            return null;
        }
        ArtifactVersion lowerBound = null;
        boolean includeLower = true;
        for (Map.Entry<String, Boolean> entry : this.lowerBounds.entrySet()) {
            ArtifactVersion candidate = this.helper.createArtifactVersion(entry.getKey());
            if (lowerBound == null) {
                lowerBound = candidate;
                includeLower = entry.getValue();
                continue;
            }
            int result = comparator.compare(lowerBound, candidate);
            if (result > 0) {
                lowerBound = candidate;
                includeLower = entry.getValue();
                continue;
            }
            if (result != 0) continue;
            includeLower = includeLower && entry.getValue() != false;
        }
        ArtifactVersion upperBound = null;
        boolean includeUpper = true;
        for (Map.Entry<String, Boolean> entry : this.upperBounds.entrySet()) {
            ArtifactVersion candidate = this.helper.createArtifactVersion(entry.getKey());
            if (upperBound == null) {
                upperBound = candidate;
                includeUpper = entry.getValue();
                continue;
            }
            int result = comparator.compare(upperBound, candidate);
            if (result < 0) {
                upperBound = candidate;
                includeUpper = entry.getValue();
                continue;
            }
            if (result != 0) continue;
            includeUpper = includeUpper && entry.getValue() != false;
        }
        StringBuilder buf = new StringBuilder();
        if (includeLower) {
            buf.append('[');
        } else {
            buf.append('(');
        }
        if (lowerBound != null) {
            buf.append(lowerBound);
        }
        buf.append(',');
        if (upperBound != null) {
            buf.append(upperBound);
        }
        if (includeUpper) {
            buf.append(']');
        } else {
            buf.append(')');
        }
        return buf.toString();
    }

    public void addLowerBound(String lowerBound, boolean includeLower) {
        Boolean value = this.lowerBounds.get(lowerBound);
        value = value == null ? Boolean.valueOf(includeLower) : Boolean.valueOf(includeLower && value != false);
        this.lowerBounds.put(lowerBound, value);
    }

    public void addUpperBound(String upperBound, boolean includeUpper) {
        Boolean value = this.upperBounds.get(upperBound);
        value = value == null ? Boolean.valueOf(includeUpper) : Boolean.valueOf(includeUpper && value != false);
        this.upperBounds.put(upperBound, value);
    }

    private VersionComparator[] lookupComparators() {
        HashSet<VersionComparator> result = new HashSet<VersionComparator>();
        for (ArtifactAssociation association : this.associations) {
            result.add(this.helper.getVersionComparator(association.getArtifact()));
        }
        return result.toArray(new VersionComparator[result.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PropertyVersionComparator
    implements Comparator<ArtifactVersion> {
        private PropertyVersionComparator() {
        }

        @Override
        public int compare(ArtifactVersion v1, ArtifactVersion v2) {
            return this.innerCompare(v1, v2);
        }

        private int innerCompare(ArtifactVersion v1, ArtifactVersion v2) {
            if (!PropertyVersionsBuilder.this.isAssociated()) {
                throw new IllegalStateException("Cannot compare versions for a property with no associations");
            }
            VersionComparator[] comparators = PropertyVersionsBuilder.this.lookupComparators();
            assert (comparators.length >= 1) : "we have at least one association => at least one comparator";
            int result = comparators[0].compare(v1, v2);
            for (int i = 1; i < comparators.length; ++i) {
                int alt = comparators[i].compare(v1, v2);
                if ((result == alt || result < 0 || alt >= 0) && (result > 0 || alt <= 0)) continue;
                throw new IllegalStateException("Property " + PropertyVersionsBuilder.this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the two of versions being compared.\nFirst rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + result + "\nSecond rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + alt);
            }
            return result;
        }
    }
}

