/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.versions.VersionParseException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.change.VersionChange;
import org.codehaus.mojo.versions.change.VersionChanger;
import org.codehaus.mojo.versions.change.VersionChangerFactory;
import org.codehaus.mojo.versions.ordering.ReactorDepthComparator;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.DelegatingContextualLog;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractVersionsSetMojo
extends AbstractVersionsUpdaterMojo {
    private String groupId;
    private String artifactId;
    protected String oldVersion;
    private Boolean updateMatchingVersions;
    private boolean processParent;
    private boolean processProject;
    private boolean processDependencies;
    private boolean processPlugins;
    private final transient List sourceChanges = new ArrayList();

    private synchronized void addChange(String groupId, String artifactId, String oldVersion, String newVersion) {
        if (!newVersion.equals(oldVersion)) {
            this.sourceChanges.add(new VersionChange(groupId, artifactId, oldVersion, newVersion));
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getProject().getOriginalModel().getVersion() == null) {
            throw new MojoExecutionException("Project version is inherited from parent.");
        }
        String newVersion = null;
        try {
            newVersion = this.getNewVersion();
        }
        catch (VersionParseException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (StringUtils.isEmpty((String)newVersion)) {
            throw new MojoExecutionException("You must specify the new version, either by using the newVersion property (that is -DnewVersion=... on the command line) or run in interactive mode");
        }
        this.setVersion(newVersion);
    }

    protected abstract String getNewVersion() throws MojoExecutionException, VersionParseException;

    protected void setVersion(String newVersion) throws MojoFailureException, MojoExecutionException {
        if (this.updateMatchingVersions == null) {
            this.updateMatchingVersions = Boolean.TRUE;
        }
        this.addChange(this.groupId, this.artifactId, this.oldVersion, newVersion);
        try {
            MavenProject project = PomHelper.getLocalRoot(this.projectBuilder, this.getProject(), this.localRepository, null, this.getLog());
            this.getLog().info((CharSequence)("Local aggregation root: " + project.getBasedir()));
            Map<String, Model> reactor = PomHelper.getReactorModels(project, this.getLog());
            Model current = PomHelper.getModel(reactor, this.getProject().getGroupId(), this.getProject().getArtifactId());
            current.setVersion(newVersion);
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            files.add(this.getProject().getFile());
            ArrayList<String> order = new ArrayList<String>(reactor.keySet());
            Collections.sort(order, new ReactorDepthComparator(reactor));
            for (String sourcePath : order) {
                Model sourceModel = reactor.get(sourcePath);
                this.getLog().debug((CharSequence)(sourcePath.length() == 0 ? "Processing root module as parent" : "Processing " + sourcePath + " as a parent."));
                String sourceGroupId = PomHelper.getGroupId(sourceModel);
                if (sourceGroupId == null) {
                    this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing a groupId."));
                    continue;
                }
                String sourceArtifactId = PomHelper.getArtifactId(sourceModel);
                if (sourceArtifactId == null) {
                    this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing an artifactId."));
                    continue;
                }
                String sourceVersion = PomHelper.getVersion(sourceModel);
                if (sourceVersion == null) {
                    this.getLog().warn((CharSequence)("Module " + sourcePath + " is missing a version."));
                    continue;
                }
                File moduleDir = new File(project.getBasedir(), sourcePath);
                File moduleProjectFile = moduleDir.isDirectory() ? new File(moduleDir, "pom.xml") : moduleDir;
                files.add(moduleProjectFile);
                this.getLog().debug((CharSequence)("Looking for modules which use " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + " as their parent"));
                for (Map.Entry<String, Model> target : PomHelper.getChildModels(reactor, sourceGroupId, sourceArtifactId).entrySet()) {
                    String targetPath = target.getKey();
                    Model targetModel = target.getValue();
                    Parent parent = targetModel.getParent();
                    this.getLog().debug((CharSequence)("Module: " + targetPath));
                    if (sourceVersion.equals(parent.getVersion())) {
                        this.getLog().debug((CharSequence)("    parent already is " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + sourceVersion));
                    } else {
                        this.getLog().debug((CharSequence)("    parent is " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + parent.getVersion()));
                        this.getLog().debug((CharSequence)("    will become " + ArtifactUtils.versionlessKey((String)sourceGroupId, (String)sourceArtifactId) + ":" + sourceVersion));
                    }
                    boolean targetExplicit = PomHelper.isExplicitVersion(targetModel);
                    if ((this.updateMatchingVersions.booleanValue() || !targetExplicit) && StringUtils.equals((String)parent.getVersion(), (String)PomHelper.getVersion(targetModel))) {
                        this.getLog().debug((CharSequence)("    module is " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId(targetModel), (String)PomHelper.getArtifactId(targetModel)) + ":" + PomHelper.getVersion(targetModel)));
                        this.getLog().debug((CharSequence)("    will become " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId(targetModel), (String)PomHelper.getArtifactId(targetModel)) + ":" + sourceVersion));
                        this.addChange(PomHelper.getGroupId(targetModel), PomHelper.getArtifactId(targetModel), PomHelper.getVersion(targetModel), sourceVersion);
                        targetModel.setVersion(sourceVersion);
                        continue;
                    }
                    this.getLog().debug((CharSequence)("    module is " + ArtifactUtils.versionlessKey((String)PomHelper.getGroupId(targetModel), (String)PomHelper.getArtifactId(targetModel)) + ":" + PomHelper.getVersion(targetModel)));
                }
            }
            Iterator k = files.iterator();
            while (k.hasNext()) {
                this.process((File)k.next());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected synchronized void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        DelegatingContextualLog log = new DelegatingContextualLog(this.getLog());
        try {
            Model model = PomHelper.getRawModel(pom);
            log.setContext("Processing " + PomHelper.getGroupId(model) + ":" + PomHelper.getArtifactId(model));
            VersionChangerFactory versionChangerFactory = new VersionChangerFactory();
            versionChangerFactory.setPom(pom);
            versionChangerFactory.setLog(log);
            versionChangerFactory.setModel(model);
            VersionChanger changer = versionChangerFactory.newVersionChanger(this.processParent, this.processProject, this.processDependencies, this.processPlugins);
            for (VersionChange versionChange : this.sourceChanges) {
                changer.apply(versionChange);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        log.clearContext();
    }
}

