/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class ResolveRangesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    private Boolean processProperties;
    private String includeProperties = null;
    private String excludeProperties = null;
    public final Pattern matchRangeRegex = Pattern.compile(",");

    public boolean isProcessingProperties() {
        return !Boolean.FALSE.equals(this.processProperties);
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException {
        if (this.getProject().getModel().getDependencyManagement() != null && this.getProject().getModel().getDependencyManagement().getDependencies() != null && this.isProcessingDependencyManagement()) {
            this.resolveRanges(pom, this.getProject().getModel().getDependencyManagement().getDependencies());
        }
        if (this.isProcessingDependencies()) {
            this.resolveRanges(pom, this.getProject().getModel().getDependencies());
        }
        if (this.isProcessingProperties()) {
            this.resolvePropertyRanges(pom);
        }
    }

    private void resolveRanges(ModifiedPomXMLEventReader pom, Collection dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            Artifact artifact;
            Matcher versionMatcher;
            Dependency dep = (Dependency)iter.next();
            if (this.isExcludeReactor() && this.isProducedByReactor(dep) || !(versionMatcher = this.matchRangeRegex.matcher(dep.getVersion())).find() || (artifact = this.findArtifact(dep)) == null || !this.isIncluded(artifact)) continue;
            this.getLog().debug((CharSequence)("Resolving version range for dependency: " + artifact));
            String artifactVersion = artifact.getVersion();
            if (artifactVersion == null) {
                ArtifactVersion latestVersion = this.findLatestVersion(artifact, artifact.getVersionRange(), null, false);
                if (latestVersion != null) {
                    artifactVersion = latestVersion.toString();
                } else {
                    this.getLog().warn((CharSequence)"Not updating version: could not resolve any versions");
                }
            }
            if (artifactVersion == null || !PomHelper.setDependencyVersion(pom, artifact.getGroupId(), artifact.getArtifactId(), dep.getVersion(), artifactVersion)) continue;
            this.getLog().debug((CharSequence)("Version set to " + artifactVersion + " for dependency: " + artifact));
        }
    }

    private void resolvePropertyRanges(ModifiedPomXMLEventReader pom) throws XMLStreamException, MojoExecutionException {
        Map propertyVersions = this.getHelper().getVersionPropertiesMap(this.getProject(), null, this.includeProperties, this.excludeProperties, true);
        Iterator i = propertyVersions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Property property = (Property)entry.getKey();
            PropertyVersions version = (PropertyVersions)entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null || !this.matchRangeRegex.matcher(currentVersion).find()) continue;
            property.setVersion(currentVersion);
            this.updatePropertyToNewestVersion(pom, property, version, currentVersion);
        }
    }
}

