/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.versions.api.ArtifactAssocation;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.VersionsHelper;

public class PropertyVersions {
    private final String name;
    private final String profileId;
    private final Set associations;
    private final VersionsHelper helper;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PropertyVersions(String profileId, String name, VersionsHelper helper) {
        this.profileId = profileId;
        this.name = name;
        this.associations = new TreeSet();
        this.helper = helper;
    }

    public void addAssociation(Artifact artifact, boolean usePluginRepositories) {
        this.associations.add(new DefaultArtifactAssociation(artifact, usePluginRepositories));
    }

    public void removeAssociation(Artifact artifact, boolean usePluginRepositories) {
        this.associations.remove(new DefaultArtifactAssociation(artifact, usePluginRepositories));
    }

    public ArtifactAssocation[] getAssociations() {
        return this.associations.toArray(new ArtifactAssocation[this.associations.size()]);
    }

    private Comparator[] lookupComparators() {
        HashSet<Comparator> result = new HashSet<Comparator>();
        Iterator i = this.associations.iterator();
        while (i.hasNext()) {
            ArtifactAssocation association = (ArtifactAssocation)i.next();
            result.add(this.helper.getVersionComparator(association.getArtifact()));
        }
        return result.toArray(new Comparator[result.size()]);
    }

    public int compare(ArtifactVersion v1, ArtifactVersion v2) throws MojoExecutionException {
        if (!this.isAssociated()) {
            throw new IllegalStateException("Cannot compare versions for a property with no associations");
        }
        Comparator[] comparators = this.lookupComparators();
        if (!$assertionsDisabled && comparators.length < 1) {
            throw new AssertionError((Object)"we have at least one association => at least one comparator");
        }
        int result = comparators[0].compare(v1, v2);
        for (int i = 1; i < comparators.length; ++i) {
            int alt = comparators[i].compare(v1, v2);
            if ((result == alt || result < 0 || alt >= 0) && (result > 0 || alt <= 0)) continue;
            throw new MojoExecutionException("Property " + this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the two of versions being compared.\nFirst rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + result + "\nSecond rule says compare(\"" + v1 + "\", \"" + v2 + "\") = " + alt);
        }
        return result;
    }

    public ArtifactVersion[] getVersions(Collection artifacts) throws MojoExecutionException {
        ArrayList<ArtifactVersion> result = new ArrayList<ArtifactVersion>();
        Iterator i = this.associations.iterator();
        while (i.hasNext()) {
            ArtifactAssocation association = (ArtifactAssocation)i.next();
            Iterator j = artifacts.iterator();
            while (j.hasNext()) {
                Artifact artifact = (Artifact)j.next();
                if (!association.getGroupId().equals(artifact.getGroupId()) || !association.getArtifactId().equals(artifact.getArtifactId())) continue;
                try {
                    result.add(artifact.getSelectedVersion());
                }
                catch (OverConstrainedVersionException e) {}
            }
        }
        Iterator k = result.iterator();
        block6: while (k.hasNext()) {
            ArtifactVersion candidate = (ArtifactVersion)k.next();
            i = this.associations.iterator();
            while (i.hasNext()) {
                ArtifactAssocation association = (ArtifactAssocation)i.next();
                boolean haveMatch = false;
                Iterator j = artifacts.iterator();
                while (j.hasNext() && !haveMatch) {
                    Artifact artifact = (Artifact)j.next();
                    if (!association.getGroupId().equals(artifact.getGroupId()) || !association.getArtifactId().equals(artifact.getArtifactId())) continue;
                    try {
                        haveMatch = candidate.toString().equals(artifact.getSelectedVersion().toString());
                    }
                    catch (OverConstrainedVersionException e) {}
                }
                if (haveMatch) continue;
                k.remove();
                continue block6;
            }
        }
        return this.asArtifactVersionArray(result);
    }

    public ArtifactVersion[] getVersions(boolean includeSnapshots) throws MojoExecutionException {
        ArrayList<ArtifactVersion> result = null;
        Iterator i = this.associations.iterator();
        while (i.hasNext()) {
            ArtifactAssocation association = (ArtifactAssocation)i.next();
            ArtifactVersions versions = this.helper.lookupArtifactVersions(association.getArtifact(), association.isUsePluginRepositories());
            if (result != null) {
                ArtifactVersion[] artifactVersions = versions.getVersions(includeSnapshots);
                Iterator j = result.iterator();
                while (j.hasNext()) {
                    boolean contains = false;
                    ArtifactVersion version = (ArtifactVersion)j.next();
                    for (int k = 0; k < artifactVersions.length; ++k) {
                        if (version.compareTo((Object)artifactVersions[k]) != 0) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    j.remove();
                }
                continue;
            }
            result = new ArrayList<ArtifactVersion>(Arrays.asList(versions.getVersions(includeSnapshots)));
        }
        return this.asArtifactVersionArray(result);
    }

    private ArtifactVersion[] asArtifactVersionArray(List result) throws MojoExecutionException {
        if (result == null || result.isEmpty()) {
            return new ArtifactVersion[0];
        }
        Object[] answer = result.toArray(new ArtifactVersion[result.size()]);
        Comparator[] rules = this.lookupComparators();
        if (!$assertionsDisabled && rules.length <= 0) {
            throw new AssertionError();
        }
        Arrays.sort(answer, rules[0]);
        if (rules.length == 1 || answer.length == 1) {
            return answer;
        }
        Object[] alt = (ArtifactVersion[])answer.clone();
        for (int j = 1; j < rules.length; ++j) {
            Arrays.sort(alt, rules[j]);
            if (Arrays.equals(alt, answer)) continue;
            throw new MojoExecutionException("Property " + this.name + " is associated with multiple artifacts" + " and these artifacts use different version sorting rules and these rules are effectively" + " incompatible for the set of versions available to this property.\nFirst rule says: " + Arrays.asList(answer) + "\nSecond rule says: " + Arrays.asList(alt));
        }
        return answer;
    }

    public String getName() {
        return this.name;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public boolean isAssociated() {
        return !this.associations.isEmpty();
    }

    public String toString() {
        return "PropertyVersions{" + (this.profileId == null ? "" : "profileId='" + this.profileId + "', ") + "name='" + this.name + '\'' + ", associations=" + this.associations + '}';
    }

    public void clearAssociations() {
        this.associations.clear();
    }

    static {
        $assertionsDisabled = !PropertyVersions.class.desiredAssertionStatus();
    }

    private static final class DefaultArtifactAssociation
    implements Comparable,
    ArtifactAssocation {
        private final Artifact artifact;
        private final boolean usePluginRepositories;

        private DefaultArtifactAssociation(Artifact artifact, boolean usePluginRepositories) {
            artifact.getClass();
            this.artifact = artifact;
            this.usePluginRepositories = usePluginRepositories;
        }

        public String getGroupId() {
            return this.artifact.getGroupId();
        }

        public String getArtifactId() {
            return this.artifact.getArtifactId();
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public boolean isUsePluginRepositories() {
            return this.usePluginRepositories;
        }

        public int compareTo(Object o) {
            if (this == o) {
                return 0;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return 1;
            }
            DefaultArtifactAssociation that = (DefaultArtifactAssociation)o;
            int rv = this.getGroupId().compareTo(that.getGroupId());
            if (rv != 0) {
                return rv;
            }
            rv = this.getArtifactId().compareTo(that.getArtifactId());
            if (rv != 0) {
                return rv;
            }
            if (this.usePluginRepositories != that.usePluginRepositories) {
                return this.usePluginRepositories ? 1 : -1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultArtifactAssociation that = (DefaultArtifactAssociation)o;
            if (this.usePluginRepositories != that.usePluginRepositories) {
                return false;
            }
            if (!this.getArtifactId().equals(that.getArtifactId())) {
                return false;
            }
            return this.getGroupId().equals(that.getGroupId());
        }

        public int hashCode() {
            int result = this.getGroupId().hashCode();
            result = 31 * result + this.getArtifactId().hashCode();
            result = 31 * result + (this.usePluginRepositories ? 1 : 0);
            return result;
        }

        public String toString() {
            return (this.usePluginRepositories ? "plugin:" : "artifact:") + ArtifactUtils.versionlessKey((Artifact)this.artifact);
        }
    }
}

