/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UpdateChildModulesMojo
extends AbstractVersionsUpdaterMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Set childModules = PomHelper.getAllChildModules(this.getProject(), this.getLog());
        PomHelper.removeMissingChildModules(this.getLog(), this.getProject(), childModules);
        Iterator i = childModules.iterator();
        MojoExecutionException pbe = null;
        while (i.hasNext()) {
            String modulePath = (String)i.next();
            File moduleDir = new File(this.getProject().getBasedir(), modulePath);
            File moduleProjectFile = moduleDir.isDirectory() ? new File(moduleDir, "pom.xml") : moduleDir;
            try {
                StringBuffer childPom = this.readFile(moduleProjectFile);
                ModifiedPomXMLEventReader pom = this.newModifiedPomXER(childPom);
                Artifact parent = PomHelper.getProjectParent(pom, this.getHelper());
                if (parent == null) {
                    this.getLog().info((CharSequence)("Module: " + modulePath + " does not have a parent"));
                    continue;
                }
                if (!this.getProject().getGroupId().equals(parent.getGroupId()) || !this.getProject().getArtifactId().equals(parent.getArtifactId())) {
                    this.getLog().info((CharSequence)("Module: " + modulePath + " does not use " + ArtifactUtils.versionlessKey((Artifact)this.getProject().getArtifact()) + " as its parent"));
                    continue;
                }
                if (this.getProject().getVersion().equals(parent.getVersion())) {
                    this.getLog().info((CharSequence)("Module: " + modulePath + " parent is " + ArtifactUtils.versionlessKey((Artifact)this.getProject().getArtifact()) + ":" + this.getProject().getVersion()));
                    continue;
                }
                this.getLog().info((CharSequence)("Module: " + modulePath + " parent was " + ArtifactUtils.versionlessKey((Artifact)this.getProject().getArtifact()) + ":" + parent.getVersion() + ", now " + ArtifactUtils.versionlessKey((Artifact)this.getProject().getArtifact()) + ":" + this.getProject().getVersion()));
                this.process(moduleProjectFile);
            }
            catch (XMLStreamException e) {
                this.getLog().debug((CharSequence)("Could not parse " + moduleProjectFile.getPath()), (Throwable)e);
                if (pbe != null) continue;
                pbe = new MojoExecutionException("Could not parse " + moduleProjectFile.getPath(), (Exception)e);
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("Could not parse " + moduleProjectFile.getPath()), (Throwable)e);
                if (pbe != null) continue;
                pbe = new MojoExecutionException("Could not parse " + moduleProjectFile.getPath(), (Exception)e);
            }
        }
        if (pbe != null) {
            throw pbe;
        }
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        this.getLog().debug((CharSequence)("Updating parent to " + this.getProject().getVersion()));
        if (PomHelper.setProjectParentVersion(pom, this.getProject().getVersion())) {
            this.getLog().debug((CharSequence)("Made an update to " + this.getProject().getVersion()));
        }
    }
}

