/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tidy.task;

import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.codehaus.mojo.tidy.task.EnsureOrderAndIndent;
import org.codehaus.mojo.tidy.task.EnsureSingleLineProjectStartTag;
import org.codehaus.mojo.tidy.task.EnsureTrailingNewLine;
import org.codehaus.mojo.tidy.task.EnsureXmlHeader;
import org.codehaus.mojo.tidy.task.Format;
import org.codehaus.mojo.tidy.task.FormatIdentifier;
import org.codehaus.mojo.tidy.task.TidyTask;

public class PomTidy {
    private static final FormatIdentifier FORMAT_IDENTIFIER = new FormatIdentifier();
    private static final List<TidyTask> TIDY_TASKS = Arrays.asList(new EnsureXmlHeader(), new EnsureOrderAndIndent(), new EnsureSingleLineProjectStartTag(), new EnsureTrailingNewLine());

    public String tidy(String pom) throws XMLStreamException {
        Format format = FORMAT_IDENTIFIER.identifyFormat(pom);
        for (TidyTask task : TIDY_TASKS) {
            pom = task.tidyPom(pom, format);
        }
        return pom;
    }
}

