/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tidy.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.mojo.tidy.task.Format;
import org.codehaus.mojo.tidy.task.TidyTask;
import org.codehaus.mojo.tidy.task.XMLEventReaderFactory;
import org.codehaus.plexus.util.StringUtils;

class EnsureSingleLineProjectStartTag
implements TidyTask {
    private static final String PROJECT_START_TAG = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd\"";
    private static final Collection<QName> PROJECT_4_0_ATTRIBUTES = Collections.singleton(new QName(null, "child.project.url.inherit.append.path"));
    private static final Collection<QName> PROJECT_4_1_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<QName>(Arrays.asList(new QName(null, "child.project.url.inherit.append.path"), new QName(null, "root"), new QName(null, "preserve.model.version"))));
    private static final String PROJECT_4_1_START_TAG = "<project xmlns=\"http://maven.apache.org/POM/4.1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  xsi:schemaLocation=\"http://maven.apache.org/POM/4.1.0 https://maven.apache.org/xsd/maven-4.1.0.xsd\"";

    EnsureSingleLineProjectStartTag() {
    }

    @Override
    public String tidyPom(String pom, Format format) throws XMLStreamException {
        String modelVersion = this.identifyModelVersion(pom);
        if ("4.1.0".equals(modelVersion)) {
            return this.tidy41Pom(pom);
        }
        return this.tidy40Pom(pom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tidy40Pom(String pom) throws XMLStreamException {
        try (XMLEventReader eventReader = XMLEventReaderFactory.createEventReaderForPom(pom);){
            String string = this.tidyProjectStartTag(pom, eventReader, PROJECT_START_TAG, PROJECT_4_0_ATTRIBUTES);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String tidy41Pom(String pom) throws XMLStreamException {
        try (XMLEventReader eventReader = XMLEventReaderFactory.createEventReaderForPom(pom);){
            String string = this.tidyProjectStartTag(pom, eventReader, PROJECT_4_1_START_TAG, PROJECT_4_1_ATTRIBUTES);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String identifyModelVersion(String pom) throws XMLStreamException {
        try (XMLEventReader eventReader = XMLEventReaderFactory.createEventReaderForPom(pom);){
            String string = this.identifyModelVersion(eventReader);
            return string;
        }
    }

    private String identifyModelVersion(XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event = eventReader.nextEvent();
        while (null != event) {
            if (event.isStartElement()) {
                if (event.asStartElement().getName().getLocalPart().equals("project")) {
                    return this.resolveModelVersion(eventReader);
                }
                event = this.skipNestedContent(eventReader);
                continue;
            }
            event = eventReader.nextEvent();
        }
        return null;
    }

    private XMLEvent skipNestedContent(XMLEventReader eventReader) throws XMLStreamException {
        int nestedSize = 0;
        XMLEvent xmlEvent = eventReader.nextEvent();
        while (xmlEvent != null) {
            if (xmlEvent.isEndElement()) {
                if (nestedSize == 0) {
                    return xmlEvent;
                }
                --nestedSize;
            } else if (xmlEvent.isStartElement()) {
                ++nestedSize;
            }
            xmlEvent = eventReader.nextEvent();
        }
        return null;
    }

    private String resolveModelVersion(XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent xmlEvent = eventReader.nextEvent();
        while (xmlEvent != null) {
            if (xmlEvent.isStartElement()) {
                if (xmlEvent.asStartElement().getName().getLocalPart().equals("modelVersion")) {
                    return eventReader.getElementText();
                }
                xmlEvent = this.skipNestedContent(eventReader);
            } else if (xmlEvent.isEndElement()) {
                return null;
            }
            xmlEvent = eventReader.nextEvent();
        }
        return null;
    }

    private String tidyProjectStartTag(String pom, XMLEventReader eventReader, String projectStartTag, Collection<QName> additionalProperties) throws XMLStreamException {
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals("project")) continue;
            return this.replaceProjectStartTag(pom, eventReader, event, projectStartTag, additionalProperties);
        }
        throw new IllegalArgumentException("The POM has no project node.");
    }

    private String replaceProjectStartTag(String pom, XMLEventReader eventReader, XMLEvent event, String startTag, Collection<QName> additionalProperties) throws XMLStreamException {
        Map<QName, String> additionalPropertiesMap;
        int start = event.getLocation().getCharacterOffset();
        if (additionalProperties.isEmpty()) {
            additionalPropertiesMap = Collections.emptyMap();
        } else {
            additionalPropertiesMap = new HashMap(additionalProperties.size());
            Iterator<Attribute> attributeIterator = event.asStartElement().getAttributes();
            while (attributeIterator.hasNext()) {
                Attribute currentAttribute = attributeIterator.next();
                QName attributeQualifiedName = currentAttribute.getName();
                if (!additionalProperties.contains(attributeQualifiedName)) continue;
                additionalPropertiesMap.put(attributeQualifiedName, currentAttribute.getValue());
            }
        }
        int nextChar = eventReader.nextEvent().getLocation().getCharacterOffset();
        if (additionalPropertiesMap.isEmpty()) {
            return pom.substring(0, start) + startTag + ">" + pom.substring(nextChar);
        }
        StringBuilder result = new StringBuilder(pom.substring(0, start)).append(startTag);
        for (QName additionalProperty : additionalProperties) {
            String value = (String)additionalPropertiesMap.get(additionalProperty);
            if (value == null) continue;
            result.append(' ');
            if (additionalProperty.getPrefix().equals("")) {
                result.append(additionalProperty.getLocalPart());
            } else {
                result.append(additionalProperty.getPrefix()).append(':').append(additionalProperty.getLocalPart());
            }
            result.append('=').append(StringUtils.quoteAndEscape((String)value, (char)'\"', (char[])new char[]{'\"', '\\'}, (char)'\\', (boolean)true));
        }
        return result.append('>').append(pom.substring(nextChar)).toString();
    }
}

