/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sql;

import org.codehaus.plexus.util.StringUtils;

public final class SqlSplitter {
    public static final int NO_END = -1;
    public static final int OVERFLOW_SINGLE_QUOTE = -2;
    public static final int OVERFLOW_DOUBLE_QUOTE = -4;
    public static final int OVERFLOW_COMMENT = -8;

    private SqlSplitter() {
    }

    public static int containsSqlEnd(String line, String delimiter, int overflowValue) {
        int n;
        int ret = overflowValue >= 0 ? -1 : overflowValue;
        boolean isComment = overflowValue == -8;
        String quoteChar = null;
        if (overflowValue == -2) {
            quoteChar = "'";
        } else if (overflowValue == -4) {
            quoteChar = "\"";
        }
        boolean isAlphaDelimiter = StringUtils.isAlpha((String)delimiter);
        if (line == null || line.length() == 0) {
            return ret;
        }
        int pos = 0;
        int maxpos = line.length() - 1;
        int c2 = line.charAt(0);
        do {
            block21: {
                if (isComment) {
                    do {
                        if (pos < maxpos) {
                            c2 = line.charAt(pos + 1);
                        }
                        if (!SqlSplitter.startsWith(line, '*', pos) || !SqlSplitter.startsWith(line, '/', pos + 1)) continue;
                        ret = -1;
                        isComment = false;
                        break block21;
                    } while (pos++ < maxpos);
                    break;
                }
                if (quoteChar != null) {
                    int n2;
                    String doubleQuote = quoteChar + quoteChar;
                    do {
                        if (pos < maxpos) {
                            c2 = line.charAt(pos + 1);
                        }
                        if (!SqlSplitter.startsWith(line, "\\", pos) && !SqlSplitter.startsWith(line, doubleQuote, pos) && SqlSplitter.startsWith(line, quoteChar, pos)) {
                            ret = -1;
                            quoteChar = null;
                            break block21;
                        }
                        n2 = ++pos;
                        ++pos;
                    } while (n2 < maxpos);
                    break;
                }
                char c = c2;
                c2 = pos < maxpos ? (int)line.charAt(pos + 1) : 32;
                if (c == '\'' || c == '\"') {
                    quoteChar = String.valueOf(c);
                    ret = quoteChar.equals("'") ? -2 : -4;
                } else if (c == '/' && c2 == 42) {
                    isComment = true;
                    ++pos;
                    ret = -8;
                } else {
                    if (c == '-' && c2 == 45) {
                        return ret;
                    }
                    if (SqlSplitter.startsWith(line, delimiter, pos)) {
                        if (isAlphaDelimiter) {
                            if (!(pos != 0 && SqlSplitter.isAlpha(line.charAt(pos - 1)) || line.length() != pos + delimiter.length() && SqlSplitter.isAlpha(line.charAt(pos + delimiter.length())))) {
                                return pos + delimiter.length();
                            }
                        } else {
                            return pos + delimiter.length();
                        }
                    }
                }
            }
            n = ++pos;
            ++pos;
        } while (maxpos > n);
        return ret;
    }

    private static boolean startsWith(String toParse, String delimiter, int position) {
        if (delimiter.length() == 1) {
            return toParse.length() > position && toParse.charAt(position) == delimiter.charAt(0);
        }
        return toParse.startsWith(delimiter, position);
    }

    private static boolean startsWith(String toParse, char delimiter, int position) {
        return toParse.length() > position && toParse.charAt(position) == delimiter;
    }

    private static boolean isAlpha(char c) {
        return Character.isUpperCase(c) || Character.isLowerCase(c);
    }
}

