/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sql;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.scriptinterpreter.ScriptException;
import org.apache.maven.shared.scriptinterpreter.ScriptRunner;
import org.codehaus.mojo.sql.Fileset;
import org.codehaus.mojo.sql.SqlSplitter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="execute", requiresProject=true, threadSafe=true)
public class SqlExecMojo
extends AbstractMojo {
    private static final String DELIMITER_STATEMENT = "DELIMITER ";
    private static final int DELIMITER_STATEMENT_LENGTH = "DELIMITER ".length();
    public static final String ON_ERROR_ABORT = "abort";
    public static final String ON_ERROR_ABORT_AFTER = "abortAfter";
    public static final String ON_ERROR_CONTINUE = "continue";
    public static final String FILE_SORTING_ASC = "ascending";
    public static final String FILE_SORTING_DSC = "descending";
    public static final String DEFAULT_DELIMITER = ";";
    @Parameter(property="username")
    private String username;
    @Parameter(property="password")
    private String password;
    @Parameter(defaultValue="false")
    private boolean enableAnonymousPassword;
    @Parameter(defaultValue="", property="driverProperties")
    private String driverProperties;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="settingsKey")
    private String settingsKey;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter(defaultValue="false", property="skipOnConnectionError")
    private boolean skipOnConnectionError;
    @Parameter(defaultValue="false", property="skipMissingFiles")
    private boolean skipMissingFiles;
    @Parameter(defaultValue="false", property="forceOpenJpaExecution", required=true)
    private boolean forceMojoExecution;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession mavenSession;
    @Parameter(property="sqlCommand")
    private String sqlCommand;
    @Parameter
    private File[] srcFiles;
    @Parameter
    private Fileset fileset;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(property="url", required=true)
    private String url;
    @Parameter(property="driver", required=true)
    private String driver;
    @Parameter(defaultValue="false", property="autocommit")
    private boolean autocommit;
    @Parameter(defaultValue="false", property="rollbackTransactions")
    private boolean rollbackTransactions;
    @Parameter(defaultValue="abort", property="onError")
    private String onError;
    @Parameter(defaultValue="", property="connectionValidationSqls")
    private List<String> connectionValidationSqls;
    @Parameter(defaultValue="0", property="connectionRetryCount")
    private int connectionRetryCount;
    @Parameter(defaultValue="1", property="connectionRetryInterval")
    private int connectionRetryInterval = 1;
    @Parameter(defaultValue=";", property="delimiter")
    private String delimiter;
    @Parameter(defaultValue="normal", property="delimiterType")
    private String delimiterType;
    @Parameter(property="orderFile")
    private String orderFile;
    @Parameter(defaultValue="false", property="keepFormat")
    private boolean keepFormat;
    @Parameter(defaultValue="false", property="printResultSet")
    private boolean printResultSet;
    @Parameter(property="showheaders", defaultValue="true")
    private boolean showHeaders;
    @Parameter(property="showFooter", defaultValue="true")
    private boolean showFooter;
    @Parameter
    private File outputFile;
    @Parameter(defaultValue=",")
    private String outputDelimiter;
    @Parameter(defaultValue="${project.build.sourceEncoding}", property="outputEncoding")
    private String outputEncoding;
    @Parameter(defaultValue="${project.build.sourceEncoding}", property="encoding")
    private String encoding;
    private boolean append = false;
    @Parameter(defaultValue="true", property="escapeProcessing")
    private boolean escapeProcessing;
    private int successfulStatements = 0;
    private int totalStatements = 0;
    private Connection conn = null;
    private Statement statement = null;
    private List<Transaction> transactions = new Vector<Transaction>();
    @Component(role=MavenFileFilter.class)
    private MavenFileFilter fileFilter;
    @Parameter(defaultValue="false", property="enableFiltering")
    private boolean enableFiltering;
    private ScriptRunner scriptRunner;
    @Parameter
    private File preExecuteHookScript;
    @Parameter
    private File postExecuteHookScript;
    private int connectionRetryAttempts;

    public Transaction createTransaction() {
        Transaction t = new Transaction();
        this.transactions.add(t);
        return t;
    }

    public void addText(String sql) {
        this.sqlCommand = this.sqlCommand == null ? sql : this.sqlCommand + sql;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiterType(String delimiterType) {
        this.delimiterType = delimiterType;
    }

    public void setPrintResultSet(boolean print) {
        this.printResultSet = print;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public void setOutputFile(File output) {
        this.outputFile = output;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setKeepFormat(boolean keepformat) {
        this.keepFormat = keepformat;
    }

    public void setEscapeProcessing(boolean enable) {
        this.escapeProcessing = enable;
    }

    protected boolean skipMojo() {
        if (this.skip) {
            this.getLog().info((CharSequence)"User has requested to skip execution.");
            return true;
        }
        if (!this.forceMojoExecution && this.project != null && "pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping sql execution for project with packaging type 'pom'");
            return true;
        }
        return false;
    }

    public void execute() throws MojoExecutionException {
        if (this.skipMojo()) {
            return;
        }
        this.executeScriptPlusSql();
    }

    private void executeScriptPlusSql() throws MojoExecutionException {
        this.scriptRunner = new ScriptRunner();
        this.scriptRunner.setScriptEncoding(this.encoding);
        HashMap context = new HashMap();
        try {
            if (this.preExecuteHookScript != null) {
                this.scriptRunner.run("pre-execute script", this.preExecuteHookScript, context, null);
            }
            this.executeSqlCore();
        }
        catch (IOException | ScriptException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            try {
                if (this.postExecuteHookScript != null) {
                    this.scriptRunner.run("post-execute script", this.postExecuteHookScript, context, null);
                }
            }
            catch (IOException | ScriptException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeSqlCore() throws MojoExecutionException {
        this.connectionRetryAttempts = 0;
        this.successfulStatements = 0;
        this.totalStatements = 0;
        boolean connectionIsValid = false;
        this.loadUserInfoFromSettings();
        this.addCommandToTransactions();
        this.addFilesToTransactions();
        this.addFileSetToTransactions();
        this.sortTransactions();
        while (!connectionIsValid) {
            boolean retryOnConnectionError = this.connectionRetryCount > this.connectionRetryAttempts;
            try {
                if (this.conn == null || this.conn.isClosed()) {
                    this.conn = this.getConnection();
                }
                this.validateConnection(this.conn);
                connectionIsValid = true;
            }
            catch (SQLException e) {
                if (retryOnConnectionError) {
                    ++this.connectionRetryAttempts;
                    this.getLog().info((CharSequence)("Connection validation failed: retrying connection in " + this.connectionRetryInterval + " secs (" + this.connectionRetryAttempts + "/" + this.connectionRetryCount + ")..."));
                    this.waitToRetryConnectionValidation();
                    continue;
                }
                if (!this.skipOnConnectionError) {
                    this.closeConnection();
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
                this.closeConnection();
                return;
            }
        }
        try {
            this.statement = this.conn.createStatement();
            this.statement.setEscapeProcessing(this.escapeProcessing);
            PrintStream out = System.out;
            try {
                if (this.outputFile != null) {
                    this.getLog().debug((CharSequence)("Opening PrintStream to output file " + this.outputFile));
                    this.outputFile.getParentFile().mkdirs();
                    if (StringUtils.isEmpty((String)this.outputEncoding)) {
                        this.outputEncoding = System.getProperty("file.encoding");
                    }
                    out = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.outputFile.getAbsolutePath(), this.append)), true, this.outputEncoding);
                }
                for (Transaction t : this.transactions) {
                    t.runTransaction(out);
                    if (this.autocommit) continue;
                    if (this.rollbackTransactions) {
                        this.getLog().debug((CharSequence)"Rollback transaction");
                        this.conn.rollback();
                        continue;
                    }
                    this.getLog().debug((CharSequence)"Committing transaction");
                    this.conn.commit();
                }
            }
            finally {
                if (out != null && out != System.out) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (SQLException e) {
            if (!this.autocommit && this.conn != null && ON_ERROR_ABORT.equalsIgnoreCase(this.getOnError())) {
                try {
                    this.conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        finally {
            this.closeStatement();
            this.closeConnection();
        }
        this.getLog().info((CharSequence)(this.getSuccessfulStatements() + " of " + this.getTotalStatements() + " SQL statements executed successfully"));
        if (ON_ERROR_ABORT_AFTER.equalsIgnoreCase(this.getOnError()) && this.totalStatements != this.successfulStatements) {
            throw new MojoExecutionException("Some SQL statements failed to execute");
        }
    }

    private void addCommandToTransactions() {
        if (this.sqlCommand != null) {
            this.createTransaction().addText(this.sqlCommand.trim());
        }
    }

    private void addFileSetToTransactions() {
        String[] includedFiles;
        if (this.fileset != null) {
            this.fileset.scan();
            includedFiles = this.fileset.getIncludedFiles();
        } else {
            includedFiles = new String[]{};
        }
        for (String includedFile : includedFiles) {
            this.createTransaction().setSrc(new File(this.fileset.getBasedir(), includedFile));
        }
    }

    private void addFilesToTransactions() throws MojoExecutionException {
        File[] files = this.getSrcFiles();
        MavenFileFilterRequest request = new MavenFileFilterRequest();
        request.setEncoding(this.encoding);
        request.setMavenSession(this.mavenSession);
        request.setMavenProject(this.project);
        request.setFiltering(this.enableFiltering);
        if (files != null) {
            for (File sourceFile : files) {
                if (sourceFile != null && !sourceFile.exists()) {
                    if (this.skipMissingFiles) {
                        this.getLog().debug((CharSequence)String.format("ignoring non existing sql file [%s].", sourceFile.getPath()));
                        continue;
                    }
                    throw new MojoExecutionException(sourceFile.getPath() + " not found.");
                }
                String basename = FileUtils.basename((String)sourceFile.getName());
                String extension = FileUtils.extension((String)sourceFile.getName());
                File targetFile = FileUtils.createTempFile((String)basename, (String)extension, null);
                if (!this.getLog().isDebugEnabled()) {
                    targetFile.deleteOnExit();
                }
                request.setFrom(sourceFile);
                request.setTo(targetFile);
                try {
                    this.fileFilter.copyFile(request);
                }
                catch (MavenFilteringException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
                this.createTransaction().setSrc(targetFile);
            }
        }
    }

    private void sortTransactions() {
        if (FILE_SORTING_ASC.equalsIgnoreCase(this.orderFile)) {
            Collections.sort(this.transactions);
        } else if (FILE_SORTING_DSC.equalsIgnoreCase(this.orderFile)) {
            this.transactions.sort(Collections.reverseOrder());
        }
    }

    private void loadUserInfoFromSettings() throws MojoExecutionException {
        Server server;
        if (this.settingsKey == null) {
            this.settingsKey = this.getUrl();
        }
        if ((this.getUsername() == null || this.getPassword() == null) && this.settings != null && (server = this.settings.getServer(this.settingsKey)) != null) {
            if (this.getUsername() == null) {
                this.setUsername(server.getUsername());
            }
            if (this.getPassword() == null && server.getPassword() != null) {
                try {
                    this.setPassword(this.securityDispatcher.decrypt(server.getPassword()));
                }
                catch (SecDispatcherException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
        if (this.getUsername() == null) {
            this.setUsername("");
        }
        if (this.getPassword() == null) {
            this.setPassword("");
        }
    }

    Connection getConnection() throws MojoExecutionException, SQLException {
        Driver driverInstance;
        this.getLog().debug((CharSequence)("connecting to " + this.getUrl()));
        Properties info = new Properties();
        info.put("user", this.getUsername());
        if (!this.enableAnonymousPassword) {
            info.put("password", this.getPassword());
        }
        info.putAll((Map<?, ?>)this.getDriverProperties());
        try {
            Class<?> dc = Class.forName(this.getDriver());
            driverInstance = (Driver)dc.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Driver class not found: " + this.getDriver(), (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure loading driver: " + this.getDriver(), e);
        }
        Connection connection = driverInstance.connect(this.getUrl(), info);
        if (connection == null) {
            throw new SQLException("No suitable Driver for " + this.getUrl());
        }
        connection.setAutoCommit(this.autocommit);
        return connection;
    }

    protected Properties getDriverProperties() throws MojoExecutionException {
        Properties properties = new Properties();
        if (!StringUtils.isEmpty((String)this.driverProperties)) {
            String[] tokens;
            for (String token : tokens = StringUtils.split((String)this.driverProperties, (String)",")) {
                String[] keyValueTokens = StringUtils.split((String)token.trim(), (String)"=");
                if (keyValueTokens.length != 2) {
                    throw new MojoExecutionException("Invalid JDBC Driver properties: " + this.driverProperties);
                }
                properties.setProperty(keyValueTokens[0], keyValueTokens[1]);
            }
        }
        return properties;
    }

    private void runStatements(Reader reader, PrintStream out) throws SQLException, IOException {
        String line;
        String fileDelimeter = this.delimiter;
        if (this.delimiterType.equals("row")) {
            String line2 = IOUtil.toString((Reader)reader);
            this.execSQL(line2, out);
            return;
        }
        StringBuilder sql = new StringBuilder();
        BufferedReader in = new BufferedReader(reader);
        int overflow = -1;
        while ((line = in.readLine()) != null) {
            String ucLine;
            String token;
            StringTokenizer st;
            if (!this.keepFormat) {
                line = line.trim();
            }
            if (!this.keepFormat && (line.startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken()))) continue;
            if (overflow >= -1 && (ucLine = line.toUpperCase()).startsWith(DELIMITER_STATEMENT)) {
                fileDelimeter = line.substring(DELIMITER_STATEMENT_LENGTH).trim();
                continue;
            }
            if (!this.keepFormat) {
                sql.append(" ").append(line);
            } else {
                sql.append("\n").append(line);
            }
            overflow = SqlSplitter.containsSqlEnd(line, fileDelimeter, overflow);
            if (!this.keepFormat && overflow == -1) {
                sql.append("\n");
            }
            if ((!this.delimiterType.equals("normal") || overflow <= 0) && (!this.delimiterType.equals("row") || !line.trim().equals(fileDelimeter))) continue;
            this.execSQL(sql.substring(0, sql.length() - fileDelimeter.length()), out);
            sql.setLength(0);
            overflow = -1;
        }
        if (sql.length() > 0) {
            this.execSQL(sql.toString(), out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execSQL(String sql, PrintStream out) throws SQLException {
        if (sql.trim().isEmpty()) {
            return;
        }
        try (ResultSet resultSet = null;){
            ++this.totalStatements;
            this.getLog().debug((CharSequence)("SQL: " + sql));
            int updateCountTotal = 0;
            boolean ret = this.statement.execute(sql);
            do {
                if (!ret) {
                    int updateCount = this.statement.getUpdateCount();
                    if (updateCount == -1) continue;
                    updateCountTotal += updateCount;
                    continue;
                }
                resultSet = this.statement.getResultSet();
                if (!this.printResultSet) continue;
                this.printResultSet(resultSet, out);
            } while (ret = this.statement.getMoreResults());
            this.getLog().debug((CharSequence)(updateCountTotal + " rows affected"));
            if (this.printResultSet && this.showFooter) {
                this.printResultSetCount(updateCountTotal, out);
            }
            for (SQLWarning warning = this.conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                this.getLog().debug((CharSequence)(warning + " sql warning"));
            }
            this.conn.clearWarnings();
            ++this.successfulStatements;
        }
    }

    protected void printResultSet(ResultSet rs, PrintStream out) throws SQLException {
        if (rs != null) {
            String columnValue;
            int col;
            boolean first;
            this.getLog().debug((CharSequence)"Processing new result set.");
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            StringBuffer line = new StringBuffer();
            if (this.showHeaders) {
                first = true;
                for (col = 1; col <= columnCount; ++col) {
                    columnValue = md.getColumnName(col);
                    if (columnValue != null) {
                        columnValue = columnValue.trim();
                        if (",".equals(this.outputDelimiter)) {
                            columnValue = StringEscapeUtils.escapeCsv((String)columnValue);
                        }
                    }
                    if (first) {
                        first = false;
                    } else {
                        line.append(this.outputDelimiter);
                    }
                    line.append(columnValue);
                }
                out.println(line);
                line = new StringBuffer();
            }
            while (rs.next()) {
                first = true;
                for (col = 1; col <= columnCount; ++col) {
                    columnValue = rs.getString(col);
                    if (columnValue != null) {
                        columnValue = columnValue.trim();
                        if (",".equals(this.outputDelimiter)) {
                            columnValue = StringEscapeUtils.escapeCsv((String)columnValue);
                        }
                    }
                    if (first) {
                        first = false;
                    } else {
                        line.append(this.outputDelimiter);
                    }
                    line.append(columnValue);
                }
                out.println(line);
                line = new StringBuffer();
            }
        }
        out.println();
    }

    protected void printResultSetCount(int updateCountTotal, PrintStream out) {
        out.println(updateCountTotal + " rows affected");
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    void setAutocommit(boolean autocommit) {
        this.autocommit = autocommit;
    }

    public void setRollbackTransactions(boolean rollbackTransactions) {
        this.rollbackTransactions = rollbackTransactions;
    }

    void setFileset(Fileset fileset) {
        this.fileset = fileset;
    }

    public File[] getSrcFiles() {
        return this.srcFiles;
    }

    public void setSrcFiles(File[] files) {
        this.srcFiles = files;
    }

    public String getOrderFile() {
        return this.orderFile;
    }

    public void setOrderFile(String orderFile) {
        if (FILE_SORTING_ASC.equalsIgnoreCase(orderFile)) {
            this.orderFile = FILE_SORTING_ASC;
        } else if (FILE_SORTING_DSC.equalsIgnoreCase(orderFile)) {
            this.orderFile = FILE_SORTING_DSC;
        } else {
            throw new IllegalArgumentException(orderFile + " is not a valid value for orderFile, only '" + FILE_SORTING_ASC + "' or '" + FILE_SORTING_DSC + "'.");
        }
    }

    public int getSuccessfulStatements() {
        return this.successfulStatements;
    }

    public int getTotalStatements() {
        return this.totalStatements;
    }

    public String getOnError() {
        return this.onError;
    }

    public void setOnError(String action) {
        if (ON_ERROR_ABORT.equalsIgnoreCase(action)) {
            this.onError = ON_ERROR_ABORT;
        } else if (ON_ERROR_CONTINUE.equalsIgnoreCase(action)) {
            this.onError = ON_ERROR_CONTINUE;
        } else if (ON_ERROR_ABORT_AFTER.equalsIgnoreCase(action)) {
            this.onError = ON_ERROR_ABORT_AFTER;
        } else {
            throw new IllegalArgumentException(action + " is not a valid value for onError, only '" + ON_ERROR_ABORT + "', '" + ON_ERROR_ABORT_AFTER + "', or '" + ON_ERROR_CONTINUE + "'.");
        }
    }

    protected void validateConnection(Connection conn) throws SQLException {
        if (this.connectionValidationSqls != null && !this.connectionValidationSqls.isEmpty()) {
            for (String sql : this.connectionValidationSqls) {
                if (sql == null || sql.trim().length() <= 0) continue;
                conn.createStatement().executeQuery(sql);
            }
        }
    }

    private void waitToRetryConnectionValidation() throws MojoExecutionException {
        try {
            Thread.sleep(this.connectionRetryInterval * 1000);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    void closeConnection() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                this.getLog().debug((CharSequence)("Failed to close connection: " + e.getMessage()));
            }
        }
    }

    private void closeStatement() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                this.getLog().debug((CharSequence)("Failed to close statement: " + e.getMessage()));
            }
        }
    }

    protected boolean isConnectionClosed() {
        try {
            return this.conn == null || this.conn.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    protected void clear() {
        this.sqlCommand = null;
        if (this.transactions != null) {
            this.transactions.clear();
        }
    }

    protected int getConnectionRetryAttempts() {
        return this.connectionRetryAttempts;
    }

    public void setConnectionValidationSqls(List<String> connectionValidationSql) {
        this.connectionValidationSqls = connectionValidationSql;
    }

    public void setConnectionRetryCount(int connectionRetryCount) {
        this.connectionRetryCount = connectionRetryCount;
    }

    public void setConnectionRetryInterval(int connectionRetryInterval) {
        this.connectionRetryInterval = connectionRetryInterval;
    }

    void setSettings(Settings settings) {
        this.settings = settings;
    }

    void setSettingsKey(String key) {
        this.settingsKey = key;
    }

    void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setSkipMissingFiles(boolean skipMissingFiles) {
        this.skipMissingFiles = skipMissingFiles;
    }

    public void setDriverProperties(String driverProperties) {
        this.driverProperties = driverProperties;
    }

    public String getSqlCommand() {
        return this.sqlCommand;
    }

    public void setSqlCommand(String sqlCommand) {
        this.sqlCommand = sqlCommand;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    public void setFileFilter(MavenFileFilter filter) {
        this.fileFilter = filter;
    }

    public void setSecurityDispatcher(SecDispatcher securityDispatcher) {
        this.securityDispatcher = securityDispatcher;
    }

    public void setOutputDelimiter(String outputDelimiter) {
        this.outputDelimiter = outputDelimiter;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setShowFooter(boolean showFooter) {
        this.showFooter = showFooter;
    }

    private class Transaction
    implements Comparable<Transaction> {
        private File tSrcFile = null;
        private String tSqlCommand = "";

        private Transaction() {
        }

        public void setSrc(File src) {
            this.tSrcFile = src;
        }

        public void addText(String sql) {
            this.tSqlCommand = this.tSqlCommand + sql;
        }

        private void runTransaction(PrintStream out) throws IOException, SQLException {
            if (!this.tSqlCommand.isEmpty()) {
                SqlExecMojo.this.getLog().info((CharSequence)"Executing commands");
                SqlExecMojo.this.runStatements(new StringReader(this.tSqlCommand), out);
            }
            if (this.tSrcFile != null) {
                SqlExecMojo.this.getLog().info((CharSequence)("Executing file: " + this.tSrcFile.getAbsolutePath()));
                InputStreamReader reader = null;
                reader = StringUtils.isEmpty((String)SqlExecMojo.this.encoding) ? new FileReader(this.tSrcFile) : new InputStreamReader(Files.newInputStream(this.tSrcFile.toPath(), new OpenOption[0]), SqlExecMojo.this.encoding);
                try {
                    SqlExecMojo.this.runStatements(reader, out);
                }
                finally {
                    ((Reader)reader).close();
                }
            }
        }

        @Override
        public int compareTo(Transaction transaction) {
            if (transaction.tSrcFile == null) {
                if (this.tSrcFile == null) {
                    return 0;
                }
                return Integer.MAX_VALUE;
            }
            if (this.tSrcFile == null) {
                return Integer.MIN_VALUE;
            }
            return this.tSrcFile.compareTo(transaction.tSrcFile);
        }
    }
}

