/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.solaris;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.solaris.AbstractSolarisMojo;
import org.codehaus.mojo.solaris.Defaults;
import org.codehaus.mojo.solaris.PrototypeGenerator;
import org.codehaus.mojo.solaris.SinglePrototypeEntry;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class GeneratePrototypeMojo
extends AbstractSolarisMojo {
    public static final String[] DEFAULT_INCLUDES = new String[]{"*/**"};
    public static final String[] DEFAULT_EXCLUDES = new String[2 + DirectoryScanner.DEFAULTEXCLUDES.length];
    public static final Defaults DEFAULT_DIRECTORY_ENTRY;
    public static final Defaults DEFAULT_FILE_ENTRY;
    private File packageRoot;
    private List generatedPrototype;
    private String defaultClass;
    private String defaultDirectoryMode;
    private String defaultFileMode;
    private String defaultUser;
    private String defaultGroup;
    private PrototypeGenerator prototypeGenerator;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File generatedPrototypeFile = new File(this.packageRoot, "generated-prototype");
        if (!this.packageRoot.isDirectory()) {
            this.getLog().debug((CharSequence)("package root is not a directory: " + this.packageRoot.getAbsolutePath()));
            try {
                FileUtils.fileWrite((String)generatedPrototypeFile.getAbsolutePath(), (String)"");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while writing empty file: '" + generatedPrototypeFile.getAbsolutePath() + "'.");
            }
            return;
        }
        this.mkParentDirs(generatedPrototypeFile);
        Defaults directoryDefaults = new Defaults(this.defaultClass, this.defaultDirectoryMode, this.defaultUser, this.defaultGroup, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
        Defaults fileDefaults = new Defaults(this.defaultClass, this.defaultFileMode, this.defaultUser, this.defaultGroup, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
        Iterator prototypeFile = this.prototypeGenerator.generatePrototype(this.packageRoot, this.generatedPrototype, directoryDefaults, fileDefaults);
        GeneratePrototypeMojo.writePrototype(generatedPrototypeFile, prototypeFile);
    }

    public static void writePrototype(File generatedPrototype, Iterator prototypeFile) throws MojoFailureException, MojoExecutionException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(generatedPrototype);
            PrintWriter printer = new PrintWriter(writer);
            while (prototypeFile.hasNext()) {
                printer.println(((SinglePrototypeEntry)prototypeFile.next()).getPrototypeLine());
            }
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error while writing generatedPrototype file: " + generatedPrototype.getAbsolutePath() + ".", (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    static {
        GeneratePrototypeMojo.DEFAULT_EXCLUDES[0] = "*prototype*";
        GeneratePrototypeMojo.DEFAULT_EXCLUDES[1] = "*pkginfo*";
        System.arraycopy(DirectoryScanner.DEFAULTEXCLUDES, 0, DEFAULT_EXCLUDES, 2, DirectoryScanner.DEFAULTEXCLUDES.length);
        DEFAULT_DIRECTORY_ENTRY = new Defaults("none", "0755", "root", "sys", DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
        DEFAULT_FILE_ENTRY = new Defaults("none", "0644", "root", "sys", DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
    }
}

