/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rpm;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.rpm.AbstractRPMMojo;
import org.codehaus.mojo.rpm.BaseTrigger;
import org.codehaus.mojo.rpm.FileHelper;
import org.codehaus.mojo.rpm.Mapping;
import org.codehaus.mojo.rpm.Scriptlet;
import org.codehaus.mojo.rpm.SoftlinkSource;
import org.codehaus.mojo.rpm.Source;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

final class SpecWriter {
    private final AbstractRPMMojo mojo;
    private final PrintWriter spec;

    public SpecWriter(AbstractRPMMojo mojo, PrintWriter spec) {
        this.mojo = mojo;
        this.spec = spec;
    }

    public void writeSpecFile() throws MojoExecutionException, IOException {
        this.writeList(this.mojo.getDefineStatements(), "%define ");
        this.spec.println("Name: " + this.mojo.getName());
        this.spec.println("Version: " + this.mojo.getVersion());
        this.spec.println("Release: " + this.mojo.getRelease());
        this.writeNonNullDirective("Summary", this.mojo.getSummary());
        this.writeNonNullDirective("License", this.mojo.getLicense());
        this.writeNonNullDirective("Distribution", this.mojo.getDistribution());
        if (this.mojo.getEpoch() != null) {
            this.spec.println("Epoch: " + this.mojo.getEpoch());
        }
        if (this.mojo.getIcon() != null) {
            this.spec.println("Icon: " + this.mojo.getIcon().getName());
        }
        this.writeNonNullDirective("Vendor", this.mojo.getVendor());
        this.writeNonNullDirective("URL", this.mojo.getUrl());
        this.writeNonNullDirective("Group", this.mojo.getGroup());
        this.writeNonNullDirective("Packager", this.mojo.getPackager());
        this.writeList(this.mojo.getProvides(), "Provides: ");
        this.writeList(this.mojo.getRequires(), "Requires: ");
        this.writeList(this.mojo.getBuildRequires(), "BuildRequires: ");
        this.writeList(this.mojo.getRequiresPre(), "Requires(pre): ");
        this.writeList(this.mojo.getRequiresPost(), "Requires(post): ");
        this.writeList(this.mojo.getRequiresPreun(), "Requires(preun): ");
        this.writeList(this.mojo.getPrereqs(), "PreReq: ");
        this.writeList(this.mojo.getObsoletes(), "Obsoletes: ");
        this.writeList(this.mojo.getConflicts(), "Conflicts: ");
        this.spec.println("autoprov: " + (this.mojo.isAutoProvides() ? "yes" : "no"));
        this.spec.println("autoreq: " + (this.mojo.isAutoRequires() ? "yes" : "no"));
        if (this.mojo.getPrefixes() != null) {
            for (String prefix : this.mojo.getPrefixes()) {
                this.spec.println("Prefix: " + prefix);
            }
        }
        if ("noarch".equals(this.mojo.getTargetArch())) {
            this.spec.println("BuildArch: " + this.mojo.getTargetArch());
        }
        this.spec.println("BuildRoot: " + FileHelper.toUnixPath(this.mojo.getRPMBuildroot()));
        this.spec.println();
        this.spec.println("%description");
        if (this.mojo.getDescription() != null) {
            this.spec.println(this.mojo.getDescription());
        }
        if (!this.mojo.getMappings().isEmpty()) {
            this.writeMove();
        }
        this.writeLinks();
        if (this.mojo.getInstallScriptlet() != null) {
            this.spec.println();
            this.mojo.getInstallScriptlet().writeContent(this.spec, this.mojo.getFilterWrappers());
        }
        this.writeFiles();
        this.writeScripts();
        if (this.mojo.getTriggers() != null) {
            for (BaseTrigger trigger : this.mojo.getTriggers()) {
                trigger.writeTrigger(this.spec, this.mojo.getFilterWrappers());
            }
        }
        if (this.mojo.getChangelog() != null) {
            this.spec.println();
            this.spec.println("%changelog");
            this.spec.println(this.mojo.getChangelog());
        }
    }

    private void writeFiles() {
        Log log = this.mojo.getLog();
        this.spec.println();
        this.spec.println("%files");
        this.spec.println(this.getDefAttrString());
        for (Mapping map : this.mojo.getMappings()) {
            String destination = map.getDestination();
            File absoluteDestination = map.getAbsoluteDestination();
            String attrString = map.getAttrString(this.mojo.getDefaultFilemode(), this.mojo.getDefaultDirmode(), this.mojo.getDefaultGroupname(), this.mojo.getDefaultUsername());
            String baseFileString = this.assembleBaseString(destination, attrString);
            String dirAttrString = map.getDerivedDirAttrString(this.mojo.getDefaultDirmode(), this.mojo.getDefaultGroupname(), this.mojo.getDefaultUsername());
            String baseDirString = this.assembleBaseString(destination, dirAttrString);
            if (map.hasSoftLinks() && !absoluteDestination.exists()) {
                log.debug((CharSequence)("writing attribute string for directory created by soft link: " + destination));
                this.spec.println(attrString + " \"" + destination + "\"");
                continue;
            }
            List<String> links = map.getLinkedFileNamesRelativeToDestination();
            if (map.isSoftLinkOnly()) {
                log.debug((CharSequence)"writing attribute string for softlink only source");
                for (String link : links) {
                    this.spec.print(baseFileString);
                    this.spec.println(link + "\"");
                }
                continue;
            }
            if (map.isSourceDirsOnly() && map.isDirectoryIncluded() && !map.isRecurseDirectories()) {
                boolean simpleDir = true;
                for (Source source : map.getSources()) {
                    if (source.isSingleDir()) continue;
                    simpleDir = false;
                    break;
                }
                if (simpleDir) {
                    log.debug((CharSequence)("writing attribute string for directory: " + destination));
                    this.spec.println(attrString + " \"" + destination + "\"");
                    continue;
                }
            }
            List<String> includes = map.getCopiedFileNamesRelativeToDestination();
            log.debug((CharSequence)("scanning: " + absoluteDestination));
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(absoluteDestination);
            scanner.setIncludes(includes.isEmpty() ? null : includes.toArray(new String[includes.size()]));
            scanner.setExcludes(null);
            scanner.scan();
            if (scanner.isEverythingIncluded() && links.isEmpty() && map.isDirectoryIncluded() && !map.isRecurseDirectories()) {
                log.debug((CharSequence)("writing attribute string for directory: " + destination));
                this.spec.println(attrString + " \"" + destination + "\"");
                continue;
            }
            log.debug((CharSequence)("writing attribute string for identified files in directory: " + destination));
            if (map.isRecurseDirectories()) {
                String[] dirs = scanner.getIncludedDirectories();
                if (map.isDirectoryIncluded()) {
                    this.spec.println(baseDirString + "\"");
                }
                for (String dir : dirs) {
                    if (dir.length() <= 0) continue;
                    this.spec.print(baseDirString);
                    this.spec.println(StringUtils.replace((String)dir, (String)"\\", (String)"/") + "\"");
                }
            }
            if (!map.isDirectoryIncluded() || !scanner.isEverythingIncluded() || !links.isEmpty() || map.isRecurseDirectories()) {
                String[] files = scanner.getIncludedFiles();
                for (String file : files) {
                    this.spec.print(baseFileString);
                    this.spec.println(StringUtils.replace((String)file, (String)"\\", (String)"/") + "\"");
                }
            }
            for (String link : links) {
                this.spec.print(baseFileString);
                this.spec.println(link + "\"");
            }
        }
    }

    private String assembleBaseString(String destination, String dirAttrString) {
        return dirAttrString + "  \"" + destination + "/";
    }

    private void writeMove() {
        String tmpBuildRoot = FileHelper.toUnixPath(this.mojo.getBuildroot());
        this.spec.println();
        this.spec.println("%install");
        this.spec.println();
        this.spec.println("if [ -d $RPM_BUILD_ROOT ];");
        this.spec.println("then");
        this.spec.print("  mv ");
        this.spec.print(tmpBuildRoot);
        this.spec.println("/* $RPM_BUILD_ROOT");
        this.spec.println("else");
        this.spec.print("  mv ");
        this.spec.print(tmpBuildRoot);
        this.spec.println(" $RPM_BUILD_ROOT");
        this.spec.println("fi");
    }

    private void writeLinks() {
        if (!this.mojo.getLinkTargetToSources().isEmpty()) {
            this.spec.println();
            for (Map.Entry<String, List<SoftlinkSource>> directoryToSourcesEntry : this.mojo.getLinkTargetToSources().entrySet()) {
                List<SoftlinkSource> sources;
                int sourceCnt;
                String directory = directoryToSourcesEntry.getKey();
                if (directory.startsWith("/")) {
                    directory = directory.substring(1);
                }
                if (directory.endsWith("/")) {
                    directory = directory.substring(0, directory.length() - 1);
                }
                if ((sourceCnt = (sources = directoryToSourcesEntry.getValue()).size()) == 1) {
                    SoftlinkSource linkSource = sources.get(0);
                    String macroEvaluatedLocation = linkSource.getMacroEvaluatedLocation();
                    File buildSourceLocation = macroEvaluatedLocation.startsWith("/") ? new File(this.mojo.getBuildroot(), macroEvaluatedLocation) : new File(this.mojo.getBuildroot(), directory + '/' + macroEvaluatedLocation);
                    if (buildSourceLocation.isDirectory()) {
                        DirectoryScanner scanner = SpecWriter.scanLinkSource(linkSource, buildSourceLocation);
                        if (scanner.isEverythingIncluded()) {
                            File destinationFile = linkSource.getSourceMapping().getAbsoluteDestination();
                            destinationFile.delete();
                            this.spec.print("ln -s ");
                            this.spec.print(linkSource.getLocation());
                            this.spec.print(" $RPM_BUILD_ROOT/");
                            this.spec.print(directory);
                            String dest = linkSource.getDestination();
                            if (dest != null) {
                                this.spec.print('/');
                                this.spec.print(dest);
                                linkSource.getSourceMapping().addLinkedFileNameRelativeToDestination(dest);
                            }
                            this.spec.println();
                            continue;
                        }
                        this.linkScannedFiles(directory, linkSource, scanner);
                        continue;
                    }
                    this.linkSingleFile(directory, linkSource);
                    continue;
                }
                for (SoftlinkSource linkSource : sources) {
                    String sourceLocation = linkSource.getMacroEvaluatedLocation();
                    File buildSourceLocation = sourceLocation.startsWith("/") ? new File(this.mojo.getBuildroot(), sourceLocation) : new File(this.mojo.getBuildroot(), directory + '/' + sourceLocation);
                    if (buildSourceLocation.isDirectory()) {
                        DirectoryScanner scanner = SpecWriter.scanLinkSource(linkSource, buildSourceLocation);
                        this.linkScannedFiles(directory, linkSource, scanner);
                        continue;
                    }
                    this.linkSingleFile(directory, linkSource);
                }
            }
        }
    }

    private void linkScannedFiles(String directory, SoftlinkSource linkSource, DirectoryScanner scanner) {
        String[] files = scanner.getIncludedFiles();
        String sourceLocation = linkSource.getLocation();
        String targetPrefix = sourceLocation + "/";
        String sourcePrefix = directory + "/";
        for (String file : files) {
            this.spec.print("ln -s ");
            this.spec.print(targetPrefix + file);
            this.spec.print(" $RPM_BUILD_ROOT/");
            this.spec.println(sourcePrefix + file);
            linkSource.getSourceMapping().addLinkedFileNameRelativeToDestination(file);
        }
    }

    private static DirectoryScanner scanLinkSource(SoftlinkSource linkSource, File buildSourceLocation) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(buildSourceLocation);
        List<String> includes = linkSource.getIncludes();
        scanner.setIncludes(includes == null || includes.isEmpty() ? null : includes.toArray(new String[includes.size()]));
        List<String> excludes = linkSource.getExcludes();
        scanner.setExcludes(excludes == null || excludes.isEmpty() ? null : excludes.toArray(new String[excludes.size()]));
        scanner.scan();
        return scanner;
    }

    private String getDefAttrString() {
        String defaultFilemode = this.mojo.getDefaultFilemode();
        String defaultUsername = this.mojo.getDefaultUsername();
        String defaultGroupname = this.mojo.getDefaultGroupname();
        String defaultDirmode = this.mojo.getDefaultDirmode();
        if (defaultFilemode == null && defaultUsername == null && defaultGroupname == null && this.mojo.getDefaultDirmode() == null && defaultDirmode == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (defaultFilemode != null) {
            sb.append("%defattr(").append(defaultFilemode).append(",");
        } else {
            sb.append("%defattr(-,");
        }
        if (defaultUsername != null) {
            sb.append(defaultUsername).append(",");
        } else {
            sb.append("-,");
        }
        if (defaultGroupname != null) {
            sb.append(defaultGroupname).append(",");
        } else {
            sb.append("-,");
        }
        if (defaultDirmode != null) {
            sb.append(defaultDirmode).append(")");
        } else {
            sb.append("-)");
        }
        return sb.toString();
    }

    private void linkSingleFile(String directory, SoftlinkSource linkSource) {
        this.spec.print("ln -s ");
        this.spec.print(linkSource.getLocation());
        this.spec.print(" $RPM_BUILD_ROOT/");
        this.spec.print(directory);
        this.spec.print('/');
        String destination = linkSource.getDestination();
        String linkedFileName = destination == null ? new File(linkSource.getMacroEvaluatedLocation()).getName() : destination;
        this.spec.println(linkedFileName);
        linkSource.getSourceMapping().addLinkedFileNameRelativeToDestination(linkedFileName);
    }

    private void writeScripts() throws IOException {
        Scriptlet[] scriptlets = new Scriptlet[]{this.mojo.getPrepareScriptlet(), this.mojo.getPretransScriptlet(), this.mojo.getPreinstallScriptlet(), this.mojo.getPostinstallScriptlet(), this.mojo.getPreremoveScriptlet(), this.mojo.getPostremoveScriptlet(), this.mojo.getPosttransScriptlet(), this.mojo.getVerifyScriptlet(), this.mojo.getCleanScriptlet()};
        String[] directives = new String[]{"%prep", "%pretrans", "%pre", "%post", "%preun", "%postun", "%posttrans", "%verifyscript", "%clean"};
        for (int i = 0; i < scriptlets.length; ++i) {
            if (scriptlets[i] == null) continue;
            scriptlets[i].write(this.spec, directives[i], this.mojo.getFilterWrappers());
        }
    }

    private void writeNonNullDirective(String directive, String value) {
        if (value != null) {
            this.spec.print(directive);
            this.spec.print(": ");
            this.spec.println(value);
        }
    }

    private void writeList(Collection<String> strings, String prefix) {
        if (strings != null) {
            for (String str : strings) {
                if (str.equals("")) continue;
                this.spec.print(prefix);
                this.spec.println(str);
            }
        }
    }
}

