/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Source {
    private static final String INCLUDE_ALL = "**/*";
    protected Set<String> includes;
    protected Set<String> excludes;
    private String version;
    private Boolean iiop;
    private Boolean noLocalStubs;
    private Boolean idl;
    private Boolean noValueMethods;
    private Boolean keep;
    private Boolean nowarn;
    private Boolean poa;
    private Boolean verbose;

    public boolean isIiop() {
        return Source.isSetOrDefault(this.iiop, false);
    }

    public boolean isNoLocalStubs() {
        return Source.isSetOrDefault(this.noLocalStubs, false);
    }

    public boolean isIdl() {
        return Source.isSetOrDefault(this.idl, false);
    }

    public boolean isNoValueMethods() {
        return Source.isSetOrDefault(this.noValueMethods, false);
    }

    public boolean isKeep() {
        return Source.isSetOrDefault(this.keep, false);
    }

    public boolean isNowarn() {
        return Source.isSetOrDefault(this.nowarn, false);
    }

    public boolean isPoa() {
        return Source.isSetOrDefault(this.poa, false);
    }

    public boolean isVerbose() {
        return Source.isSetOrDefault(this.verbose, false);
    }

    public String getVersion() {
        return this.version;
    }

    private static boolean isSetOrDefault(Boolean field, boolean defaultValue) {
        return field != null ? field : defaultValue;
    }

    Set<String> getIncludes() {
        return !Source.isEmpty(this.includes) ? this.includes : Collections.singleton(INCLUDE_ALL);
    }

    Set<String> getExcludes() {
        return !Source.isEmpty(this.excludes) ? this.excludes : new HashSet<String>();
    }

    private static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Including ").append(this.getIncludes()).append("; excluding ").append(this.getExcludes());
        sb.append("\nwith options: ");
        this.appendIfTrue(sb, this.isIiop(), "-iiop");
        this.appendIfTrue(sb, this.isIiop() && this.isNoLocalStubs(), "-noLocalStubs");
        this.appendIfTrue(sb, this.isIdl(), "-idl");
        this.appendIfTrue(sb, this.isIdl() && this.isNoValueMethods(), "-noValueMethods");
        this.appendIfTrue(sb, this.isKeep(), "-keep");
        this.appendIfTrue(sb, this.isNowarn(), "-nowarn");
        this.appendIfTrue(sb, this.isPoa(), "-poa");
        if (this.getVersion() != null) {
            sb.append("-v").append(this.getVersion());
        }
        return sb.toString();
    }

    private void appendIfTrue(StringBuffer sb, boolean condition, String option) {
        if (condition) {
            sb.append(option).append(' ');
        }
    }

    String getConfiguredOptions() {
        StringBuffer sb = new StringBuffer();
        this.appendIfNotEmpty(sb, this.includes, "includes");
        this.appendIfNotEmpty(sb, this.excludes, "excludes");
        this.appendOptionIfTrue(sb, this.isIiop(), "iiop");
        this.appendOptionIfTrue(sb, this.isIiop() && this.isNoLocalStubs(), "noLocalStubs");
        this.appendOptionIfTrue(sb, this.isIdl(), "idl");
        this.appendOptionIfTrue(sb, this.isIdl() && this.isNoValueMethods(), "noValueMethods");
        this.appendOptionIfTrue(sb, this.isKeep(), "keep");
        this.appendOptionIfTrue(sb, this.isNowarn(), "nowarn");
        this.appendOptionIfTrue(sb, this.isPoa(), "poa");
        return sb.toString();
    }

    private void appendIfNotEmpty(StringBuffer sb, Set<String> set, String text) {
        if (!Source.isEmpty(set)) {
            this.appendOption(sb, text);
        }
    }

    private StringBuffer appendOption(StringBuffer sb, String text) {
        if (sb.length() != 0) {
            sb.append(", ");
        }
        return sb.append(text);
    }

    private void appendOptionIfTrue(StringBuffer sb, boolean condition, String option) {
        if (condition) {
            this.appendOption(sb, option);
        }
    }

    public void setIncludes(Set<String> includes) {
        this.includes = includes;
    }

    public void setExcludes(Set<String> excludes) {
        this.excludes = excludes;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setIiop(Boolean iiop) {
        this.iiop = iiop;
    }

    public void setNoLocalStubs(Boolean noLocalStubs) {
        this.noLocalStubs = noLocalStubs;
    }

    public void setIdl(Boolean idl) {
        this.idl = idl;
    }

    public void setNoValueMethods(Boolean noValueMethods) {
        this.noValueMethods = noValueMethods;
    }

    public void setKeep(Boolean keep) {
        this.keep = keep;
    }

    public void setNowarn(Boolean nowarn) {
        this.nowarn = nowarn;
    }

    public void setPoa(Boolean poa) {
        this.poa = poa;
    }

    public void setVerbose(Boolean verbose) {
        this.verbose = verbose;
    }
}

