/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.rmic.RmiCompilerException;
import org.codehaus.mojo.rmic.RmicConfig;
import org.codehaus.mojo.rmic.Source;
import org.codehaus.mojo.rmic.SunRmiCompiler;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractRmiMojo
extends AbstractMojo
implements RmicConfig {
    private static final String STUB_CLASS_PATTERN = "**/*_Stub.class";
    private List sources;
    protected Set includes;
    protected Set excludes;
    protected String compilerId;
    private String version;
    private boolean iiop;
    private boolean noLocalStubs;
    private boolean idl;
    private boolean noValueMethods;
    private boolean keep;
    private boolean nowarn;
    private boolean poa;
    private boolean verbose;
    private int staleMillis;
    protected MavenProject project;
    private DependenciesFacade dependencies = new DependenciesFacadeImpl();
    private static final DependenciesFacade DEPENDENCIES_FACADE = new DependenciesFacadeImpl();

    protected AbstractRmiMojo() {
        this(DEPENDENCIES_FACADE);
    }

    AbstractRmiMojo(DependenciesFacade dependencies) {
        this.dependencies = dependencies;
    }

    List getSources() {
        return this.sources;
    }

    public abstract List getProjectClasspathElements();

    public abstract File getOutputDirectory();

    public abstract File getClassesDirectory();

    public void execute() throws MojoExecutionException {
        if (this.sources == null || this.sources.isEmpty()) {
            this.sources = Arrays.asList(new Source());
        }
        Iterator i = this.sources.iterator();
        while (i.hasNext()) {
            this.doExecute((Source)i.next());
        }
    }

    private void doExecute(Source source) throws MojoExecutionException {
        source.setRmiMojo(this);
        SunRmiCompiler rmiCompiler = new SunRmiCompiler();
        rmiCompiler.setLog(this.getLog());
        if (source.isVerbose()) {
            System.out.println(source);
        }
        if (!this.getOutputDirectory().isDirectory() && !this.getOutputDirectory().mkdirs()) {
            throw new MojoExecutionException("Could not make output directory: '" + this.getOutputDirectory().getAbsolutePath() + "'.");
        }
        try {
            List remoteClassesToCompile = this.getRemoteClasses(source);
            if (remoteClassesToCompile.size() == 0) {
                this.getLog().info((CharSequence)"No out of date rmi classes to process.");
                return;
            }
            this.getLog().info((CharSequence)("Compiling " + remoteClassesToCompile.size() + " remote classes"));
            rmiCompiler.execute(this, source, remoteClassesToCompile);
        }
        catch (RmiCompilerException e) {
            throw new MojoExecutionException("Error while executing the RMI compiler.", (Exception)e);
        }
    }

    public List getRmicClasspathElements() {
        List classpathElements = this.getProjectClasspathElements();
        if (!classpathElements.contains(this.getClassesDirectory().getAbsolutePath())) {
            classpathElements.add(this.getClassesDirectory().getAbsolutePath());
        }
        return classpathElements;
    }

    public List getRemoteClasses(Source source) {
        ArrayList<String> remoteClasses = new ArrayList<String>();
        try {
            List classpathList = this.generateUrlCompileClasspath();
            URL[] classpathUrls = new URL[classpathList.size()];
            classpathUrls[0] = this.getClassesDirectory().toURI().toURL();
            classpathUrls = classpathList.toArray(classpathUrls);
            this.dependencies.defineUrlClassLoader(classpathUrls);
            SourceInclusionScanner scanner = this.createScanner(source.getIncludes(), this.getExcludes(source));
            scanner.addSourceMapping((SourceMapping)new SuffixMapping(".class", "_Stub.class"));
            Set staleRemoteClasses = scanner.getIncludedSources(this.getClassesDirectory(), this.getOutputDirectory());
            Iterator iter = staleRemoteClasses.iterator();
            while (iter.hasNext()) {
                String className = this.getClassName((File)iter.next());
                Class candidateClass = this.dependencies.loadClass(className);
                if (!this.isRemoteRmiClass(candidateClass)) continue;
                remoteClasses.add(className);
            }
            iter = source.getIncludes().iterator();
            while (iter.hasNext()) {
                String include = (String)iter.next();
                File includeFile = new File(this.getClassesDirectory(), include);
                if (include.indexOf("*") != -1 || this.dependencies.fileExists(includeFile)) continue;
                remoteClasses.add(AbstractRmiMojo.fileToClassName(include));
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Problem while scanning for classes: " + e));
        }
        return remoteClasses;
    }

    private SourceInclusionScanner createScanner(Set includes, Set excludes) {
        return this.dependencies.createSourceInclusionScanner(this.staleMillis, includes, excludes);
    }

    private String getClassName(File remoteClassFile) {
        URI relativeURI = this.getClassesDirectory().toURI().relativize(remoteClassFile.toURI());
        return AbstractRmiMojo.fileToClassName(relativeURI.toString());
    }

    private Set getExcludes(Source source) {
        Set excludes = source.getExcludes();
        excludes.add(STUB_CLASS_PATTERN);
        return excludes;
    }

    private static String fileToClassName(String classFileName) {
        return StringUtils.replace((String)StringUtils.replace((String)classFileName, (String)".class", (String)""), (String)"/", (String)".");
    }

    private boolean isRemoteRmiClass(Class remoteClass) {
        return Remote.class.isAssignableFrom(remoteClass) && (!remoteClass.isInterface() || this.isIiop());
    }

    protected List generateUrlCompileClasspath() throws MojoExecutionException {
        ArrayList<URL> rmiCompileClasspath = new ArrayList<URL>();
        try {
            rmiCompileClasspath.add(this.getClassesDirectory().toURI().toURL());
            Iterator iter = this.getRmicClasspathElements().iterator();
            while (iter.hasNext()) {
                URL pathUrl = new File((String)iter.next()).toURI().toURL();
                rmiCompileClasspath.add(pathUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Problem while generating classpath: " + e.getMessage());
        }
        return rmiCompileClasspath;
    }

    public String getCompilerId() {
        return this.compilerId;
    }

    public boolean isIiop() {
        return this.iiop;
    }

    public boolean isPoa() {
        return this.poa;
    }

    public boolean isIdl() {
        return this.idl;
    }

    public boolean isKeep() {
        return this.keep;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isNowarn() {
        return this.nowarn;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isNoLocalStubs() {
        return this.noLocalStubs;
    }

    public boolean isNoValueMethods() {
        return this.noValueMethods;
    }

    static class DependenciesFacadeImpl
    implements DependenciesFacade {
        private static URLClassLoader loader;

        DependenciesFacadeImpl() {
        }

        public Class loadClass(String className) throws ClassNotFoundException {
            return loader.loadClass(className);
        }

        public void defineUrlClassLoader(URL[] classpathUrls) {
            loader = new URLClassLoader(classpathUrls);
        }

        public boolean fileExists(File includeFile) {
            return includeFile.exists();
        }

        public SourceInclusionScanner createSourceInclusionScanner(int staleMillis, Set includes, Set excludes) {
            return new StaleSourceScanner((long)staleMillis, includes, excludes);
        }
    }

    static interface DependenciesFacade {
        public boolean fileExists(File var1);

        public SourceInclusionScanner createSourceInclusionScanner(int var1, Set var2, Set var3);

        public Class loadClass(String var1) throws ClassNotFoundException;

        public void defineUrlClassLoader(URL[] var1);
    }
}

