/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.properties.AbstractPropertiesMojo;
import org.codehaus.mojo.properties.PropertyResolver;
import org.codehaus.mojo.properties.managers.PropertiesManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;

@Mojo(name="read-project-properties", defaultPhase=LifecyclePhase.NONE, threadSafe=true)
public class ReadPropertiesMojo
extends AbstractPropertiesMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter
    private File[] files = new File[0];
    @Parameter
    private String[] urls = new String[0];
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter
    private String keyPrefix = null;
    @Parameter(defaultValue="false", property="prop.skipLoadProperties")
    private boolean skipLoadProperties;
    @Parameter(defaultValue="false")
    private boolean useDefaultValues;
    @Parameter(defaultValue="true")
    private boolean override = true;
    private final PropertyResolver resolver = new PropertyResolver();

    @Inject
    public ReadPropertiesMojo(List<PropertiesManager> propertiesManagers) {
        super(propertiesManagers);
    }

    public void setFiles(File[] files) {
        if (files == null) {
            this.files = new File[0];
        } else {
            this.files = new File[files.length];
            System.arraycopy(files, 0, this.files, 0, files.length);
        }
    }

    public void setUrls(String[] urls) {
        if (urls == null) {
            this.urls = null;
        } else {
            this.urls = new String[urls.length];
            System.arraycopy(urls, 0, this.urls, 0, urls.length);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skipLoadProperties) {
            this.checkParameters();
            this.loadFiles();
            this.loadUrls();
            this.resolveProperties();
        } else {
            this.getLog().warn((CharSequence)"The properties are ignored");
        }
    }

    private void checkParameters() throws MojoExecutionException {
        if (this.files.length > 0 && this.urls.length > 0) {
            throw new MojoExecutionException("Set files or URLs but not both - otherwise no order of precedence can be guaranteed");
        }
    }

    private void loadFiles() throws MojoExecutionException {
        for (File file : this.files) {
            this.load(new FileResource(file));
        }
    }

    private void loadUrls() throws MojoExecutionException {
        for (String url : this.urls) {
            this.load(new UrlResource(url));
        }
    }

    private void load(Resource resource) throws MojoExecutionException {
        if (resource.canBeOpened()) {
            this.loadProperties(resource);
        } else {
            this.missing(resource);
        }
    }

    private void loadProperties(Resource resource) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)("Loading properties from " + resource));
            try (InputStream stream = resource.getInputStream();){
                String effectivePrefix = "";
                if (this.keyPrefix != null) {
                    effectivePrefix = this.keyPrefix;
                }
                PropertiesManager manager = this.getPropertiesManager(resource.getResourceExtension());
                Properties properties = manager.load(stream);
                Properties projectProperties = this.project.getProperties();
                HashMap<String, String> newProperties = new HashMap<String, String>();
                for (String key : properties.stringPropertyNames()) {
                    String propertyName = effectivePrefix + key;
                    if (!this.override && projectProperties.containsKey(propertyName)) continue;
                    newProperties.put(propertyName, properties.getProperty(key));
                }
                projectProperties.putAll((Map<?, ?>)newProperties);
                this.getLog().info((CharSequence)("Loading " + newProperties.size() + " properties from " + resource));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading properties from " + resource, (Exception)e);
        }
    }

    private void missing(Resource resource) throws MojoExecutionException {
        if (!this.quiet) {
            throw new MojoExecutionException("Properties could not be loaded from " + resource);
        }
        this.getLog().info((CharSequence)("Quiet processing - ignoring properties cannot be loaded from " + resource));
    }

    private void resolveProperties() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"resolve properties");
        Properties environment = this.loadSystemEnvironmentPropertiesWhenDefined();
        Properties projectProperties = this.project.getProperties();
        HashMap<String, String> newProperties = new HashMap<String, String>();
        for (String key : projectProperties.stringPropertyNames()) {
            String oldValue;
            String newValue = this.getPropertyValue(key, projectProperties, environment);
            if (Objects.equals(newValue, oldValue = projectProperties.getProperty(key))) continue;
            newProperties.put(key, newValue);
        }
        if (!newProperties.isEmpty()) {
            this.getLog().debug((CharSequence)("resolve " + newProperties.size() + " properties"));
            projectProperties.putAll((Map<?, ?>)newProperties);
        } else {
            this.getLog().debug((CharSequence)"all properties was resolved");
        }
        this.getLog().debug((CharSequence)"resolve properties - done");
    }

    private Properties loadSystemEnvironmentPropertiesWhenDefined() throws MojoExecutionException {
        Properties projectProperties = this.project.getProperties();
        boolean useEnvVariables = false;
        Enumeration<?> n = projectProperties.propertyNames();
        while (n.hasMoreElements()) {
            String k = (String)n.nextElement();
            String p = (String)projectProperties.get(k);
            if (!p.contains("${env.")) continue;
            useEnvVariables = true;
            break;
        }
        Properties environment = null;
        if (useEnvVariables) {
            try {
                environment = this.getSystemEnvVars();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error getting system environment variables: ", (Exception)e);
            }
        }
        return environment;
    }

    private String getPropertyValue(String k, Properties p, Properties environment) throws MojoFailureException {
        try {
            return this.resolver.getPropertyValue(k, p, environment, this.useDefaultValues);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    Properties getSystemEnvVars() throws IOException {
        return CommandLineUtils.getSystemEnvVars();
    }

    public void setUseDefaultValues(boolean useDefaultValues) {
        this.useDefaultValues = useDefaultValues;
    }

    void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    void setOverride(boolean override) {
        this.override = override;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    public MavenProject getProject() {
        return this.project;
    }

    private static class FileResource
    extends Resource {
        private final File file;

        FileResource(File file) {
            this.file = file;
        }

        @Override
        public String getResourceExtension() {
            return FileUtils.extension((String)this.file.getName());
        }

        @Override
        public boolean canBeOpened() {
            return this.file.exists();
        }

        @Override
        protected InputStream openStream() throws IOException {
            return new BufferedInputStream(Files.newInputStream(this.file.toPath(), new OpenOption[0]));
        }

        public String toString() {
            return "File: " + this.file;
        }
    }

    private static abstract class Resource {
        private InputStream stream;

        private Resource() {
        }

        public abstract String getResourceExtension();

        public abstract boolean canBeOpened();

        protected abstract InputStream openStream() throws IOException;

        public InputStream getInputStream() throws IOException {
            if (this.stream == null) {
                this.stream = this.openStream();
            }
            return this.stream;
        }
    }

    private static class UrlResource
    extends Resource {
        private static final String CLASSPATH_PREFIX = "classpath:";
        private static final String SLASH_PREFIX = "/";
        private final URL url;
        private boolean isMissingClasspathResouce = false;
        private String classpathUrl;

        UrlResource(String url) throws MojoExecutionException {
            if (url.startsWith(CLASSPATH_PREFIX)) {
                String resource = url.substring(CLASSPATH_PREFIX.length());
                if (resource.startsWith(SLASH_PREFIX)) {
                    resource = resource.substring(1);
                }
                this.url = this.getClass().getClassLoader().getResource(resource);
                if (this.url == null) {
                    this.isMissingClasspathResouce = true;
                    this.classpathUrl = url;
                }
            } else {
                try {
                    this.url = new URL(url);
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Badly formed URL " + url + " - " + e.getMessage());
                }
            }
        }

        @Override
        public String getResourceExtension() {
            return FileUtils.extension((String)this.url.getFile());
        }

        @Override
        public boolean canBeOpened() {
            if (this.isMissingClasspathResouce) {
                return false;
            }
            try {
                this.openStream();
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }

        @Override
        protected InputStream openStream() throws IOException {
            return new BufferedInputStream(this.url.openStream());
        }

        public String toString() {
            if (!this.isMissingClasspathResouce) {
                return "URL " + this.url.toString();
            }
            return this.classpathUrl;
        }
    }
}

