/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.project.archive;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.project.archive.AbstractProjectSourcesMojo;
import org.codehaus.mojo.project.archive.ProjectSourceContext;
import org.codehaus.mojo.tools.project.extras.ScanningUtils;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.FileUtils;

public class ResolveProjectSourcesMojo
extends AbstractProjectSourcesMojo {
    private boolean skipResolution;
    private boolean skipUnpack;
    private boolean optimizations;
    private boolean projectDirIsSourceLocation;
    private File sourceLocation;
    private File sourceUnpackDirectory;
    private String sourceUnpackSubpath;
    private List remoteRepositories;
    private ArtifactResolver artifactResolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ProjectSourceContext ctx;
        try {
            ctx = (ProjectSourceContext)this.getContainer().lookup(ProjectSourceContext.ROLE, "default");
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Failed to create cookie context store: ", (Exception)((Object)e));
        }
        File sourceArchiveFile = null;
        if (!this.skipResolution) {
            sourceArchiveFile = this.retrieveSourceArtifact();
            ctx.setSourceArtifactResolved(sourceArchiveFile != null);
            ctx.setOriginalProjectSourceLocation(sourceArchiveFile);
            this.getLog().debug((CharSequence)("After resolution, sourceArchiveFile is: " + sourceArchiveFile));
        }
        if (sourceArchiveFile == null) {
            sourceArchiveFile = this.sourceLocation;
            this.getLog().debug((CharSequence)("Using local file/directory for project-sources: " + sourceArchiveFile));
            ctx.setOriginalProjectSourceLocation(this.sourceLocation);
            this.getLog().debug((CharSequence)("After failing/skipping resolution, sourceArchiveFile set to: " + sourceArchiveFile));
        }
        if (sourceArchiveFile == null || !sourceArchiveFile.exists()) {
            this.getLog().debug((CharSequence)("Something is wrong. Does sourceArchiveFile '" + sourceArchiveFile + "' exist? " + sourceArchiveFile.exists()));
            throw new MojoExecutionException("Cannot find project sources. You may need to specify the location using -DsourceLocation.");
        }
        File projectDirectory = null;
        if (sourceArchiveFile.isDirectory()) {
            if (!this.projectDirIsSourceLocation) {
                throw new MojoExecutionException("Project sources cannot originate from a directory. This often happens after a source release download fails.");
            }
            this.getLog().debug((CharSequence)("Using directory: " + sourceArchiveFile + " as the location of project sources."));
            projectDirectory = sourceArchiveFile;
        } else {
            this.getLog().debug((CharSequence)("Unpacking: " + sourceArchiveFile + "\nto: " + this.sourceUnpackDirectory));
            try {
                this.unpackArchive(sourceArchiveFile, this.sourceUnpackDirectory);
            }
            catch (NoSuchArchiverException e) {
                throw new MojoExecutionException("Failed to unpack source archive: " + sourceArchiveFile, (Exception)((Object)e));
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Failed to unpack source archive: " + sourceArchiveFile, (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to unpack source archive: " + sourceArchiveFile, (Exception)e);
            }
            projectDirectory = this.sourceUnpackSubpath != null ? new File(this.sourceUnpackDirectory, this.sourceUnpackSubpath) : this.sourceUnpackDirectory;
        }
        ctx.setProjectSourceDirectory(projectDirectory);
        this.setProjectPrimarySourceDirectory(projectDirectory);
        try {
            this.storeContext(ctx);
        }
        catch (ComponentLookupException e) {
            throw new MojoExecutionException("Failed to store cookie context: " + sourceArchiveFile, (Exception)((Object)e));
        }
    }

    private void setProjectPrimarySourceDirectory(File projectDirectory) {
        Model model = this.getProject().getModel();
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        build.setSourceDirectory(projectDirectory.getPath());
    }

    private void unpackArchive(File archiveFile, File targetDirectory) throws NoSuchArchiverException, ArchiverException, IOException {
        boolean unpack = true;
        if (targetDirectory.exists()) {
            if (this.optimizations) {
                long targetLastMod = ScanningUtils.getLatestLastMod((File)targetDirectory, Collections.singleton("**/*"), (Set)Collections.EMPTY_SET);
                long archiveLastMod = archiveFile.lastModified();
                unpack = archiveLastMod > targetLastMod;
            } else {
                FileUtils.deleteDirectory((File)targetDirectory);
            }
        }
        targetDirectory.mkdirs();
        if (this.skipUnpack) {
            this.getLog().info((CharSequence)("Copying " + archiveFile + " to " + targetDirectory));
            FileUtils.copyFileToDirectory((File)archiveFile, (File)targetDirectory);
        } else if (unpack) {
            UnArchiver unArchiver = this.getArchiverManager().getUnArchiver(archiveFile);
            this.getLog().info((CharSequence)("Using UnArchiver: " + unArchiver + " for: " + archiveFile));
            unArchiver.setDestDirectory(targetDirectory);
            unArchiver.setSourceFile(archiveFile);
            unArchiver.extract();
        }
    }

    private File retrieveSourceArtifact() throws MojoExecutionException {
        Artifact projectSourcesArtifact = this.getProjectSourcesArtifact();
        try {
            this.artifactResolver.resolveAlways(projectSourcesArtifact, this.remoteRepositories, this.getLocalRepository());
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to resolve patch-artifact: " + projectSourcesArtifact.getId(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().debug((CharSequence)("Could not find patch-artifact: " + projectSourcesArtifact), (Throwable)e);
        }
        this.getLog().debug((CharSequence)("Was project-sources artifact resolved? " + projectSourcesArtifact.isResolved()));
        this.getLog().debug((CharSequence)("Project-sources artifact file: " + projectSourcesArtifact.getFile()));
        if (!projectSourcesArtifact.isResolved()) {
            return null;
        }
        return projectSourcesArtifact.getFile();
    }
}

