/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.projectArchive;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.projectArchive.archive.ProjectArchiver;
import org.codehaus.mojo.projectArchive.files.Fileset;
import org.codehaus.mojo.tools.fs.archive.ArchiveFileExtensions;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public abstract class AbstractProjectArchiveMojo
extends AbstractMojo {
    public static final String ATTACHED_ARTIFACT_CLASSIFIER = "project-archive";
    private static final List DEFAULT_FILESETS;
    private List filesets = DEFAULT_FILESETS;
    private String archiveRootPath;
    private MavenProject project;
    private File outputFile;
    private ArtifactFactory artifactFactory;
    private ProjectArchiver projectArchiver;
    private Artifact artifact;

    protected AbstractProjectArchiveMojo() {
    }

    protected void createProjectArchive() throws MojoExecutionException {
        try {
            this.projectArchiver.create(this.project, this.outputFile, this.archiveRootPath, this.filesets, this.getLog());
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Could not find Archiver implementation to match output file: " + this.outputFile, (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Failed to create project archive. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create project archive. Reason: " + e.getMessage(), (Exception)e);
        }
    }

    protected Artifact getProjectArchiveArtifact() {
        if (this.artifact == null) {
            File outputFile = this.getOutputFile();
            String type = ArchiveFileExtensions.getArchiveFileExtension((File)outputFile);
            this.artifact = this.artifactFactory.createArtifactWithClassifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), type, ATTACHED_ARTIFACT_CLASSIFIER);
            this.artifact.setFile(outputFile);
            this.artifact.setResolved(true);
        }
        return this.artifact;
    }

    protected File getOutputFile() {
        return this.outputFile;
    }

    protected void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected void setProject(MavenProject project) {
        this.project = project;
    }

    protected List getFilesets() {
        return this.filesets;
    }

    protected void setFilesets(List filesets) {
        this.filesets = filesets;
    }

    protected ProjectArchiver getProjectArchiver() {
        return this.projectArchiver;
    }

    protected void setProjectArchiver(ProjectArchiver projectArchiver) {
        this.projectArchiver = projectArchiver;
    }

    static {
        ArrayList<Fileset> filesets = new ArrayList<Fileset>();
        Fileset fs = new Fileset();
        fs.setDirectory("${basedir}");
        fs.addInclude("pom.xml");
        fs.addInclude("src/**");
        fs.addExclude("target/**");
        filesets.add(fs);
        DEFAULT_FILESETS = filesets;
    }
}

