/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ounce.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.StringUtils;

public class Utils {
    static final String propertyFormat = "%**%";

    public static String convertClasspathElement(String classpathElement, String ounceProjectDir, Map ounceVariableMap) {
        String ret = Utils.convertToVariablePath(classpathElement, ounceVariableMap);
        if (ret.equals(classpathElement) && ounceProjectDir != null) {
            ret = Utils.makeRelative(classpathElement, ounceProjectDir);
        }
        return ret;
    }

    public static String convertToVariablePath(String path, Map pathProperties) {
        if (path != null && pathProperties != null && pathProperties.size() > 0) {
            for (Map.Entry entry : pathProperties.entrySet()) {
                if (!StringUtils.isNotEmpty((String)((String)entry.getKey()))) continue;
                String formattedKey = StringUtils.replace((String)propertyFormat, (String)"**", (String)((String)entry.getKey()));
                path = StringUtils.replace((String)path, (String)((String)entry.getValue()), (String)formattedKey);
            }
        }
        return path;
    }

    public static List<String> convertToRelativePaths(List<String> paths, String baseDir) {
        ArrayList<String> relativePaths = new ArrayList<String>();
        for (String path : paths) {
            relativePaths.add(Utils.makeRelative(path, baseDir));
        }
        return relativePaths;
    }

    public static synchronized String getDynamicToString(Object obj) {
        StringBuffer buf = new StringBuffer();
        try {
            Class<?> clazz = obj.getClass();
            buf.append(clazz.getName() + ": ");
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                buf.append(" ");
                buf.append(fields[i].getName());
                buf.append("= ");
                try {
                    fields[i].setAccessible(true);
                    buf.append(fields[i].get(obj));
                    buf.append(" ");
                    continue;
                }
                catch (Exception e) {
                    buf.append("Error Retrieving Value ");
                }
            }
        }
        catch (Exception e) {
            buf.append("Exception: " + e.getMessage());
        }
        return buf.toString();
    }

    public static boolean isConvertible(String childPath, String parentPath) {
        String[] childPathElements = childPath.replaceAll("\\\\", "/").split("/");
        String[] parentPathElements = parentPath.replaceAll("\\\\", "/").split("/");
        int counter = 0;
        int limit = parentPathElements.length;
        if (childPathElements.length < parentPathElements.length) {
            limit = childPathElements.length;
        }
        for (int index = 0; index < limit; ++index) {
            if (parentPathElements[index].equals(childPathElements[index])) {
                ++counter;
                continue;
            }
            return counter > 1;
        }
        return true;
    }

    public static String makeRelative(String sPathToBeMadeRelative, String sReferenceDir) {
        try {
            File dir = new File(sReferenceDir);
            sReferenceDir = dir.getCanonicalPath();
            dir = new File(sPathToBeMadeRelative);
            sPathToBeMadeRelative = dir.getCanonicalPath();
        }
        catch (IOException e) {
            return sPathToBeMadeRelative;
        }
        Path pathToBeMadeRelative = Paths.get(sPathToBeMadeRelative, new String[0]);
        Path referenceDir = Paths.get(sReferenceDir, new String[0]);
        Path relativePath = referenceDir.relativize(pathToBeMadeRelative);
        String sRelativePath = relativePath.toString();
        if (sRelativePath.length() == 0) {
            return ".";
        }
        if (!sRelativePath.startsWith(".") && !sRelativePath.startsWith(File.separator)) {
            sRelativePath = "." + File.separator + sRelativePath;
        }
        return sRelativePath;
    }

    public static List<String> getFilesOfType(File directory, String extension) {
        ArrayList<String> ret = new ArrayList<String>();
        if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                if (file.isFile() && file.getName().endsWith(extension)) {
                    ret.add(file.getAbsolutePath());
                    continue;
                }
                ret.addAll(Utils.getFilesOfType(file, extension));
            }
        }
        return ret;
    }
}

