/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.freeform.analyser;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.codehaus.mojo.freeform.FreeformPluginException;
import org.codehaus.mojo.freeform.analyser.Analyser;
import org.codehaus.mojo.freeform.project.AntTarget;
import org.codehaus.mojo.freeform.project.CompilationUnit;
import org.codehaus.mojo.freeform.project.CustomisedContextMenuItem;
import org.codehaus.mojo.freeform.project.FileProperty;
import org.codehaus.mojo.freeform.project.FileViewItem;
import org.codehaus.mojo.freeform.project.FolderViewItem;
import org.codehaus.mojo.freeform.project.IdeContextMenuItem;
import org.codehaus.mojo.freeform.project.NamedNetbeansAction;
import org.codehaus.mojo.freeform.project.NamedProperty;
import org.codehaus.mojo.freeform.project.SourceFolder;
import org.codehaus.mojo.freeform.project.Subproject;

abstract class BaseAnalyser
extends Analyser {
    BaseAnalyser() {
    }

    public void analyseProject(boolean useOutputDirectory) throws FreeformPluginException {
        this.createProject(useOutputDirectory);
        this.setFreeformProjectName();
        this.log.debug((CharSequence)"project name set");
        this.setFreeformProperties();
        this.log.debug((CharSequence)"project properties set");
        this.setFreeformSourceFolders();
        this.log.debug((CharSequence)"source folders set");
        this.setFreeformIdeActions();
        this.log.debug((CharSequence)"ide actions set");
        this.setFreeformViewItems();
        this.log.debug((CharSequence)"project views set");
        this.setFreeformContextMenuItems();
        this.log.debug((CharSequence)"context menu set");
        this.setFreeformSubprojects();
        this.log.debug((CharSequence)"subprojects set");
        this.setFreeformCompilationUnits();
        this.log.debug((CharSequence)"compilation units set");
    }

    public void analyseTargets(boolean useOutputDirectory) throws FreeformPluginException {
        this.createTargets();
        this.setTargetBuild();
        this.log.debug((CharSequence)"build target set");
        this.setTargetClean();
        this.log.debug((CharSequence)"clean target set");
        this.setTargetJavadoc();
        this.log.debug((CharSequence)"javadoc target set");
        this.setTargetRun();
        this.log.debug((CharSequence)"run target set");
        this.setTargetTest();
        this.log.debug((CharSequence)"test target set");
        this.setTargetJalopy();
        this.log.debug((CharSequence)"jalopy target set");
        this.setTargetRefreshProject();
        this.log.debug((CharSequence)"refresh project target set");
    }

    protected void setActionBuild() {
        this.addIdeAction("build", "build");
    }

    protected void setActionClean() {
        this.addIdeAction("clean", "clean");
    }

    protected void setActionJavadoc() {
        this.addIdeAction("javadoc", "javadoc");
    }

    protected void setActionRebuild() {
        this.addIdeAction("rebuild", "clean build");
    }

    protected void setActionRun() {
        this.addIdeAction("run", "run");
    }

    protected void setActionTest() {
        this.addIdeAction("test", "test");
    }

    protected void setFreeformCompilationUnits() throws FreeformPluginException {
        this.addMainCompilationUnits();
        this.log.debug((CharSequence)"main compilation unit added");
        this.addTestCompilationUnits();
        this.log.debug((CharSequence)"test compilation unit added");
    }

    protected void setFreeformContextMenuItems() {
        this.setMenuRefreshProject();
        this.log.debug((CharSequence)"set refresh project context menu element");
        this.setMenuBuild();
        this.log.debug((CharSequence)"set build context menu element");
        this.setMenuClean();
        this.log.debug((CharSequence)"set clean context menu element");
        this.setMenuRebuild();
        this.log.debug((CharSequence)"set rebuld context menu element");
        this.setMenuJavadoc();
        this.log.debug((CharSequence)"set javadoc context menu element");
        this.setMenuRun();
        this.log.debug((CharSequence)"set run context menu element");
        this.setMenuTest();
        this.log.debug((CharSequence)"set test context menu element");
        this.setMenuJalopy();
        this.log.debug((CharSequence)"set jalopy context menu element");
    }

    protected void setFreeformIdeActions() {
        this.setActionBuild();
        this.log.debug((CharSequence)"set build ide action");
        this.setActionClean();
        this.log.debug((CharSequence)"set clean ide action");
        this.setActionRebuild();
        this.log.debug((CharSequence)"set rebuild ide action");
        this.setActionJavadoc();
        this.log.debug((CharSequence)"set javadoc ide action");
        this.setActionRun();
        this.log.debug((CharSequence)"set run ide action");
        this.setActionTest();
        this.log.debug((CharSequence)"set test ide action");
    }

    protected void setFreeformProjectName() {
        this.freeformProject.setName(this.mavenProject.getName());
    }

    protected void setFreeformProperties() {
        this.addMavencallScript();
        this.log.debug((CharSequence)"maven call reference property added");
        this.addPropertyFile();
        this.log.debug((CharSequence)"project proerties file added");
    }

    protected void setFreeformSourceFolders() {
        this.addSourceFolders();
        this.log.debug((CharSequence)"main sources added");
        this.addTestSourceFolders();
        this.log.debug((CharSequence)"test sources added");
    }

    protected void setFreeformSubprojects() {
        if (this.mavenProject != null && this.mavenProject.getModules() != null) {
            Iterator subprojects = this.mavenProject.getModules().iterator();
            while (subprojects.hasNext()) {
                String subprojectName = (String)subprojects.next();
                this.addSubproject(subprojectName);
                this.log.debug((CharSequence)("subproject " + subprojectName + " added"));
            }
        }
    }

    protected void setFreeformViewItems() {
        this.setViewPom();
        this.log.debug((CharSequence)"pom view set");
        this.setViewMavencall();
        this.log.debug((CharSequence)"mavencall view set");
        this.addCompileSourceRoots();
        this.log.debug((CharSequence)"main sources views set");
        this.addTestCompileSourceRoots();
        this.log.debug((CharSequence)"test sources views set");
        this.addResources();
        this.log.debug((CharSequence)"main resources views set");
        this.addTestResources();
        this.log.debug((CharSequence)"test resources views set");
        this.addSiteDirectoy();
        this.log.debug((CharSequence)"site view set");
        this.addTargetDirectory();
        this.log.debug((CharSequence)"target view set");
    }

    protected void setMenuBuild() {
        this.addIdeContextItem("build");
    }

    protected void setMenuClean() {
        this.addIdeContextItem("clean");
    }

    protected void setMenuJalopy() {
        this.addCustomisedContextMenuItem("Format Code", "jalopy");
    }

    protected void setMenuJavadoc() {
        this.addIdeContextItem("javadoc");
    }

    protected void setMenuRebuild() {
        this.addIdeContextItem("rebuild");
    }

    protected void setMenuRefreshProject() {
        this.addCustomisedContextMenuItem("Refresh Project", "refresh-project");
    }

    protected void setMenuRun() {
        this.addIdeContextItem("run");
    }

    protected void setMenuTest() {
        this.addIdeContextItem("test");
    }

    protected void setTargetBuild() {
        this.addAntTarget("build", "package", "Build");
    }

    protected void setTargetClean() {
        this.addAntTarget("clean", "clean:clean", "Clean");
    }

    protected void setTargetJalopy() {
        this.addAntTarget("jalopy", "jalopy:format", "Format Code");
    }

    protected void setTargetJavadoc() {
        this.addAntTarget("javadoc", "site:site", "Javadoc");
    }

    protected void setTargetRefreshProject() {
        if (this.mavenpath == null) {
            this.addAntTarget("refresh-project", "netbeans-freeform:generate-netbeans-project", "Refresh Project");
        } else {
            this.addAntTarget("refresh-project", "netbeans-freeform:generate-netbeans-project", "-Dfreeform.mavenpath=" + this.mavenpath, "Refresh Project");
        }
    }

    protected void setTargetRun() {
        this.addAntTarget("run", "install", "Install Locally");
    }

    protected void setTargetTest() {
        this.addAntTarget("test", "test", "Test Project");
    }

    protected void setViewPom() {
        this.addFileViewItem("pom", "pom.xml");
    }

    protected void addAntTarget(String name, String comment) {
        AntTarget antTarget = new AntTarget();
        antTarget.setName(name);
        antTarget.setComment(comment);
        antTarget.addGoal(name);
        this.antTargets.add(antTarget);
    }

    protected void addAntTarget(String name, String mavenGoal, String comment) {
        AntTarget antTarget = new AntTarget();
        antTarget.setName(name);
        antTarget.setComment(comment);
        antTarget.addGoal(mavenGoal);
        this.antTargets.add(antTarget);
    }

    protected void addAntTarget(String name, String mavenGoal, String option, String comment) {
        AntTarget antTarget = new AntTarget();
        antTarget.setName(name);
        antTarget.setComment(comment);
        antTarget.addGoal(mavenGoal);
        antTarget.addOption(option);
        this.antTargets.add(antTarget);
    }

    protected void addCompilationUnit(String relativeOutputDirectory, boolean unitTest, List relativeSourceRoots, List classpathElements, File mavenProjectBasedir, File localRepositoryBasedir) {
        CompilationUnit compilationUnit = new CompilationUnit();
        compilationUnit.setPackageRoot(relativeSourceRoots);
        compilationUnit.setBuiltTo(relativeOutputDirectory);
        compilationUnit.setSourceLevel("1.4");
        compilationUnit.setUnitTest(unitTest);
        compilationUnit.setClasspath(this.toRelativeArtifactPaths(classpathElements, mavenProjectBasedir, localRepositoryBasedir));
        this.freeformProject.addCompilationUnit(compilationUnit);
    }

    protected void addCompileSourceRoots() {
        if (this.mavenExecutedProject != null && this.mavenExecutedProject.getCompileSourceRoots() != null) {
            Iterator compileSourceRoots = this.mavenExecutedProject.getCompileSourceRoots().iterator();
            while (compileSourceRoots.hasNext()) {
                String sourceRoot = (String)compileSourceRoots.next();
                this.addSourceFolderViewItem(sourceRoot);
            }
        }
    }

    protected void addCustomisedContextMenuItem(String name, String targets) {
        CustomisedContextMenuItem customisedContextMenuItem = new CustomisedContextMenuItem();
        customisedContextMenuItem.setName(name);
        StringTokenizer stringTokenizer = new StringTokenizer(targets, " ");
        ArrayList<String> targetList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            targetList.add(stringTokenizer.nextToken());
        }
        customisedContextMenuItem.setTarget(targetList);
        customisedContextMenuItem.setScript("${ant.script}");
        this.freeformProject.addContextMenuItem(customisedContextMenuItem);
    }

    protected void addFileViewItem(String label, String location) {
        FileViewItem fileViewItem = new FileViewItem();
        fileViewItem.setLabel(label);
        fileViewItem.setLocation((this.freeformProject.isUseOutputDirectory() ? "${project.directory}/" : "") + location);
        this.freeformProject.addViewItem(fileViewItem);
    }

    protected void addIdeAction(String name, String targets) {
        NamedNetbeansAction netbeansAction = new NamedNetbeansAction();
        netbeansAction.setName(name);
        netbeansAction.setScript("${ant.script}");
        StringTokenizer stringTokenizer = new StringTokenizer(targets, " ");
        ArrayList<String> targetList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            targetList.add(stringTokenizer.nextToken());
        }
        netbeansAction.setTarget(targetList);
        this.freeformProject.addNetbeansAction(netbeansAction);
    }

    protected void addIdeContextItem(String name) {
        IdeContextMenuItem ideContextMenuItem = new IdeContextMenuItem();
        ideContextMenuItem.setName(name);
        this.freeformProject.addContextMenuItem(ideContextMenuItem);
    }

    protected void addMainCompilationUnits() throws FreeformPluginException {
        if (this.mavenProject != null && this.mavenProject.getBasedir() != null && this.mavenProject.getBuild() != null && this.mavenProject.getBuild().getOutputDirectory() != null && this.mavenExecutedProject != null && this.mavenExecutedProject.getCompileSourceRoots() != null) {
            String outputDirectory = this.mavenProject.getBuild().getOutputDirectory();
            String relativeOutputDirectory = (this.freeformProject.isUseOutputDirectory() ? "${project.directory}/" : "") + BaseAnalyser.toRelative(this.mavenProject.getBasedir(), outputDirectory);
            boolean unitTest = false;
            Iterator sourceRoots = this.mavenExecutedProject.getCompileSourceRoots().iterator();
            ArrayList<String> relativeSourceRoots = new ArrayList<String>();
            while (sourceRoots.hasNext()) {
                String sourceRoot = (String)sourceRoots.next();
                String relativeSourceRoot = (this.freeformProject.isUseOutputDirectory() ? "${project.directory}/" : "") + BaseAnalyser.toRelative(this.mavenProject.getBasedir(), sourceRoot);
                relativeSourceRoots.add(relativeSourceRoot);
            }
            ArrayList<String> classpathElements = new ArrayList<String>();
            Iterator iterator = this.mavenProject.getRuntimeArtifacts().iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                classpathElements.add(artifact.getFile().getAbsolutePath());
            }
            classpathElements.remove(relativeOutputDirectory);
            this.addCompilationUnit(relativeOutputDirectory, unitTest, relativeSourceRoots, classpathElements, this.mavenProject.getBasedir(), new File(this.localRepository.getBasedir()));
        }
    }

    protected void addMavencallScript() {
        NamedProperty property = new NamedProperty();
        property.setName("ant.script");
        property.setValue("nbproject/mavencall.xml");
        this.freeformProject.addProperty(property);
    }

    protected void addPropertyFile() {
        FileProperty property = new FileProperty();
        property.setLocation("nbproject/project.properties");
        this.freeformProject.addProperty(property);
    }

    protected void addResourceFolderViewItem(String resourceFolder) {
        String relativeResourceFolder = BaseAnalyser.toRelative(this.mavenProject.getBasedir(), resourceFolder);
        FolderViewItem folderViewItem = new FolderViewItem();
        folderViewItem.setLabel(relativeResourceFolder);
        folderViewItem.setLocation((this.freeformProject.isUseOutputDirectory() ? "${project.directory}/" : "") + relativeResourceFolder);
        folderViewItem.setStyle("tree");
        this.freeformProject.addViewItem(folderViewItem);
    }

    protected void addResources() {
        if (this.mavenExecutedProject != null && this.mavenExecutedProject.getBuild() != null && this.mavenExecutedProject.getBuild().getResources() != null) {
            Iterator resources = this.mavenExecutedProject.getBuild().getResources().iterator();
            while (resources.hasNext()) {
                String resource = ((Resource)resources.next()).getDirectory();
                this.addResourceFolderViewItem(resource);
            }
        }
    }

    protected void addSiteDirectoy() {
        this.addResourceFolderViewItem("src/site");
    }

    protected void addSourceFolder(String sourceRoot) {
        String relativeSourceRoot = BaseAnalyser.toRelative(this.mavenProject.getBasedir(), sourceRoot);
        SourceFolder sourceFolder = new SourceFolder();
        sourceFolder.setType("java");
        sourceFolder.setLabel(relativeSourceRoot);
        sourceFolder.setLocation((this.freeformProject.isUseOutputDirectory() ? "${project.directory}/" : "") + relativeSourceRoot);
        this.freeformProject.addSourceFolder(sourceFolder);
    }

    protected void addSourceFolderViewItem(String sourceFolder) {
        String relativeSourceFolder = BaseAnalyser.toRelative(this.mavenProject.getBasedir(), sourceFolder);
        FolderViewItem folderViewItem = new FolderViewItem();
        folderViewItem.setLabel(relativeSourceFolder);
        folderViewItem.setLocation((this.freeformProject.isUseOutputDirectory() ? "${project.directory}/" : "") + relativeSourceFolder);
        folderViewItem.setStyle("packages");
        this.freeformProject.addViewItem(folderViewItem);
    }

    protected void addSourceFolders() {
        if (this.mavenExecutedProject != null && this.mavenExecutedProject.getCompileSourceRoots() != null) {
            Iterator compileSourceRoots = this.mavenExecutedProject.getCompileSourceRoots().iterator();
            while (compileSourceRoots.hasNext()) {
                String sourceRoot = (String)compileSourceRoots.next();
                this.addSourceFolder(sourceRoot);
            }
        }
    }

    protected void addSubproject(String subprojectName) {
        Subproject subproject = new Subproject();
        subproject.setSubproject(subprojectName);
        this.freeformProject.addSubproject(subproject);
    }

    protected void addTargetDirectory() {
        this.addResourceFolderViewItem("target");
    }

    protected void addTestCompilationUnits() throws FreeformPluginException {
        if (this.mavenProject != null && this.mavenProject.getBasedir() != null && this.mavenProject.getBuild() != null && this.mavenProject.getBuild().getTestOutputDirectory() != null && this.mavenExecutedProject != null && this.mavenExecutedProject.getTestCompileSourceRoots() != null) {
            String outputDirectory = this.mavenProject.getBuild().getTestOutputDirectory();
            String relativeOutputDirectory = (this.freeformProject.isUseOutputDirectory() ? "${project.directory}/" : "") + BaseAnalyser.toRelative(this.mavenProject.getBasedir(), outputDirectory);
            boolean unitTest = true;
            Iterator sourceRoots = this.mavenExecutedProject.getTestCompileSourceRoots().iterator();
            ArrayList<String> relativeSourceRoots = new ArrayList<String>();
            while (sourceRoots.hasNext()) {
                String sourceRoot = (String)sourceRoots.next();
                String relativeSourceRoot = (this.freeformProject.isUseOutputDirectory() ? "${project.directory}/" : "") + BaseAnalyser.toRelative(this.mavenProject.getBasedir(), sourceRoot);
                relativeSourceRoots.add(relativeSourceRoot);
            }
            ArrayList<String> classpathElements = new ArrayList<String>();
            classpathElements.add(this.mavenProject.getBuild().getOutputDirectory());
            Iterator iterator = this.mavenProject.getTestArtifacts().iterator();
            while (iterator.hasNext()) {
                Artifact artifact = (Artifact)iterator.next();
                classpathElements.add(artifact.getFile().getAbsolutePath());
            }
            this.addCompilationUnit(relativeOutputDirectory, unitTest, relativeSourceRoots, classpathElements, this.mavenProject.getBasedir(), new File(this.localRepository.getBasedir()));
        }
    }

    protected void addTestCompileSourceRoots() {
        if (this.mavenExecutedProject != null && this.mavenExecutedProject.getTestCompileSourceRoots() != null) {
            Iterator testCompilesourceRoots = this.mavenExecutedProject.getTestCompileSourceRoots().iterator();
            while (testCompilesourceRoots.hasNext()) {
                String resource = (String)testCompilesourceRoots.next();
                this.addSourceFolderViewItem(resource);
            }
        }
    }

    protected void addTestResources() {
        if (this.mavenExecutedProject != null && this.mavenExecutedProject.getBuild() != null && this.mavenExecutedProject.getBuild().getTestResources() != null) {
            Iterator testResources = this.mavenExecutedProject.getBuild().getTestResources().iterator();
            while (testResources.hasNext()) {
                String testResource = ((Resource)testResources.next()).getDirectory();
                this.addResourceFolderViewItem(testResource);
            }
        }
    }

    protected void addTestSourceFolders() {
        if (this.mavenExecutedProject != null && this.mavenExecutedProject.getTestCompileSourceRoots() != null) {
            Iterator testCompileSourceRoots = this.mavenExecutedProject.getTestCompileSourceRoots().iterator();
            while (testCompileSourceRoots.hasNext()) {
                String sourceRoot = (String)testCompileSourceRoots.next();
                this.addSourceFolder(sourceRoot);
            }
        }
    }

    protected List toRelativeArtifactPaths(List classpathElements, File mavenProjectBasedir, File localRepositoryBasedir) {
        ArrayList<String> relativeclasspathElements = new ArrayList<String>();
        Iterator iterator = classpathElements.iterator();
        while (iterator.hasNext()) {
            String classpathElement = (String)iterator.next();
            String relativeclasspathElement = BaseAnalyser.toRelative(localRepositoryBasedir, classpathElement);
            relativeclasspathElement = relativeclasspathElement.length() == classpathElement.length() ? (this.freeformProject.isUseOutputDirectory() ? "${project.directory}/" : "") + BaseAnalyser.toRelative(mavenProjectBasedir, classpathElement) : "${local.repository}/" + relativeclasspathElement;
            relativeclasspathElements.add(relativeclasspathElement);
        }
        return relativeclasspathElements;
    }

    private void setViewMavencall() {
        this.addFileViewItem("mavencall", "nbproject/mavencall.xml");
    }
}

