/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.native2ascii.mojo;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.native2ascii.Native2Ascii;
import org.codehaus.mojo.native2ascii.mojo.AbstractNative2AsciiMojo;

@Mojo(name="resources", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class Native2AsciiMojo
extends AbstractNative2AsciiMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    public File targetDir;
    @Parameter(defaultValue="src/main/native2ascii")
    public File srcDir;

    @Override
    protected File getSourceDirectory() {
        return this.srcDir;
    }

    protected File getTargetDirectory() {
        return this.targetDir;
    }

    @Override
    public void executeTransformation(Iterator<File> files) throws MojoExecutionException {
        if (!this.getTargetDirectory().exists()) {
            this.getTargetDirectory().mkdirs();
        }
        while (files.hasNext()) {
            File file = files.next();
            try {
                File targetFile = this.getTargetFile(file);
                this.getLog().info((CharSequence)("Converting '" + file + "' to '" + targetFile + "'"));
                new Native2Ascii(this.getLog()).nativeToAscii(file, targetFile, this.encoding);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to convert " + file.getAbsolutePath(), (Exception)e);
            }
        }
    }

    private File getTargetFile(File sourceFile) throws IOException {
        return new File(StringUtils.replace((String)sourceFile.getCanonicalPath(), (String)this.getSourceDirectory().getCanonicalPath(), (String)this.getTargetDirectory().getCanonicalPath()));
    }
}

