/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.natives.NativeSources;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

@Mojo(name="inczip", defaultPhase=LifecyclePhase.PACKAGE)
public class NativeBundleIncludeFilesMojo
extends AbstractNativeMojo {
    @Parameter
    private NativeSources[] sources = new NativeSources[0];
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}.inczip", required=true)
    private File incZipFile;
    @Parameter(defaultValue="false")
    private boolean skipIncludeDeployment;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        if (this.skipIncludeDeployment) {
            return;
        }
        if (this.sources.length != 0) {
            try {
                ZipArchiver archiver = new ZipArchiver();
                boolean zipIt = false;
                for (int i = 0; i < this.sources.length; ++i) {
                    if (!this.sources[i].isDeployable()) continue;
                    DefaultFileSet fileSet = new DefaultFileSet();
                    fileSet.setUsingDefaultExcludes(true);
                    fileSet.setDirectory(this.sources[i].getDirectory());
                    fileSet.setIncludes(this.sources[i].getIncludes());
                    fileSet.setExcludes(this.sources[i].getExcludes());
                    archiver.addFileSet((FileSet)fileSet);
                    zipIt = true;
                }
                if (zipIt) {
                    archiver.setDestFile(this.incZipFile);
                    archiver.createArchive();
                    this.projectHelper.attachArtifact(this.project, "inczip", null, this.incZipFile);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }
}

