/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.minijar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.minijar.AbstractPluginMojo;
import org.vafer.dependency.Clazz;
import org.vafer.dependency.Console;
import org.vafer.dependency.resources.ResourceHandler;
import org.vafer.dependency.resources.Version;
import org.vafer.dependency.utils.Jar;
import org.vafer.dependency.utils.JarUtils;

public final class MiniJarsMojo
extends AbstractPluginMojo {
    protected String name;

    public void execute(final Set pRemovable, Set pDependencies, Set pRelocateDependencies) throws MojoExecutionException {
        Iterator i = pDependencies.iterator();
        while (i.hasNext()) {
            final Artifact dependency = (Artifact)i.next();
            HashMap<String, String> variables = new HashMap<String, String>();
            variables.put("artifactId", dependency.getArtifactId());
            variables.put("groupId", dependency.getGroupId());
            variables.put("version", dependency.getVersion());
            String newName = this.replaceVariables(variables, this.name);
            File inputJar = dependency.getFile();
            File outputJar = new File(this.buildDirectory, newName);
            try {
                Jar jar = new Jar(inputJar, false);
                JarUtils.processJars((Jar[])new Jar[]{jar}, (ResourceHandler)new ResourceHandler(){

                    public void onStartProcessing(JarOutputStream pOutput) throws IOException {
                    }

                    public void onStartJar(Jar pJar, JarOutputStream pOutput) throws IOException {
                    }

                    public InputStream onResource(Jar jar, String oldName, String newName, Version[] versions, InputStream inputStream) {
                        if (jar != versions[0].getJar()) {
                            MiniJarsMojo.this.getLog().info((CharSequence)("Ignoring resource " + oldName));
                            return null;
                        }
                        String clazzName = oldName.replace('/', '.').substring(0, oldName.length() - ".class".length());
                        if (pRemovable.contains(new Clazz(clazzName))) {
                            if (MiniJarsMojo.this.isInKeepUnusedClassesFromArtifacts(dependency)) {
                                return inputStream;
                            }
                            if (MiniJarsMojo.this.isInKeepUnusedClasses(MiniJarsMojo.this.name)) {
                                return inputStream;
                            }
                            return null;
                        }
                        return inputStream;
                    }

                    public void onStopJar(Jar pJar, JarOutputStream pOutput) throws IOException {
                    }

                    public void onStopProcessing(JarOutputStream pOutput) throws IOException {
                    }
                }, (FileOutputStream)new FileOutputStream(outputJar), (Console)new Console(){

                    public void println(String pString) {
                        MiniJarsMojo.this.getLog().debug((CharSequence)pString);
                    }
                });
            }
            catch (ZipException ze) {
                this.getLog().info((CharSequence)("No references to jar " + inputJar.getName() + ". You can safely omit that dependency."));
                if (!outputJar.exists()) continue;
                outputJar.delete();
                continue;
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not create mini jar " + outputJar, e);
            }
            this.getLog().info((CharSequence)("Original length of " + inputJar.getName() + " was " + inputJar.length() + " bytes. " + "Was able shrink it to " + outputJar.getName() + " at " + outputJar.length() + " bytes (" + (int)(100L * outputJar.length() / inputJar.length()) + "%)"));
        }
    }
}

