/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jpox;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JpoxEnhancerMojo
extends AbstractMojo {
    private File classes;
    private List classpathElements;
    private List pluginArtifacts;

    public void execute() throws MojoExecutionException {
        List files = this.findMappingFiles();
        if (files.size() == 0) {
            System.out.println("No files to enhance.");
            return;
        }
        URL log4jProperties = ((Object)((Object)this)).getClass().getResource("/log4j.configuration");
        try {
            this.enhance(this.classes, this.pluginArtifacts, log4jProperties, files);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error while executing the JPox enhancer tool.", (Exception)((Object)e));
        }
    }

    private List findMappingFiles() throws MojoExecutionException {
        List files;
        try {
            files = FileUtils.getFiles((File)this.classes, (String)"**/*.jdo", (String)"");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while scanning for '**/*.jdo' in '" + this.classes.getAbsolutePath() + "'.", (Exception)e);
        }
        return files;
    }

    private void enhance(File classes, List pluginArtifacts, URL log4jProperties, List files) throws CommandLineException, MojoExecutionException {
        Commandline cl = new Commandline();
        cl.setExecutable("java");
        StringBuffer cpBuffer = new StringBuffer();
        Iterator it = this.classpathElements.iterator();
        while (it.hasNext()) {
            cpBuffer.append((String)it.next());
            if (!it.hasNext()) continue;
            cpBuffer.append(File.pathSeparator);
        }
        it = pluginArtifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            try {
                cpBuffer.append(File.pathSeparator).append(artifact.getFile().getCanonicalPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
            }
        }
        cl.createArgument().setValue("-cp");
        cl.createArgument().setValue(cpBuffer.toString());
        cl.createArgument().setValue("-Dlog4j.configuration=" + log4jProperties);
        cl.createArgument().setValue("org.jpox.enhancer.JPOXEnhancer");
        cl.createArgument().setValue("-v");
        it = files.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            cl.createArgument().setValue(file.getAbsolutePath());
        }
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        System.err.println("Executing command line:");
        System.err.println(cl.toString());
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        System.err.println("exit code: " + exitCode);
        System.err.println("--------------------");
        System.err.println(" Standard output from the JPox enhancer tool:");
        System.err.println("--------------------");
        System.err.println(stdout.getOutput());
        System.err.println("--------------------");
        String stream = stderr.getOutput();
        if (stream.trim().length() > 0) {
            System.err.println("--------------------");
            System.err.println(" Standard error from the JPox enhancer tool:");
            System.err.println("--------------------");
            System.err.println(stderr.getOutput());
            System.err.println("--------------------");
        }
        if (exitCode != 0) {
            throw new MojoExecutionException("The JPox enhancer tool exited with a non-null exit code.");
        }
    }
}

