/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.localconfig;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.mojo.localconfig.ConfigurationArchive;
import org.codehaus.mojo.tools.fs.archive.ArchiveExpander;
import org.codehaus.mojo.tools.fs.archive.ArchiveExpansionException;
import org.codehaus.mojo.tools.fs.archive.ArchiveExpansionRequest;
import org.codehaus.plexus.util.FileUtils;

public class LocalConfigMojo
extends AbstractMojo {
    private List configurationArchives;
    private File tempExpansionDir;
    private ArchiveExpander archiveExpander;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Iterator it = this.configurationArchives.iterator();
        while (it.hasNext()) {
            ConfigurationArchive archive = (ConfigurationArchive)((Object)it.next());
            try {
                this.expandConfigurationArchive(archive);
            }
            catch (ArchiveExpansionException e) {
                throw new MojoExecutionException("Failed to expand configuration archive: " + (Object)((Object)archive), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to process configuration archive: " + (Object)((Object)archive), (Exception)e);
            }
            try {
                this.copyIntoLocalEnvironment(archive);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to process configuration archive: " + (Object)((Object)archive), (Exception)e);
            }
        }
    }

    private void copyIntoLocalEnvironment(ConfigurationArchive archive) throws IOException {
        FileSetManager mgr = new FileSetManager(this.getLog());
        String[] includedFiles = mgr.getIncludedFiles((FileSet)archive);
        File archiveDir = new File(archive.getDirectory()).getCanonicalFile();
        File outputDir = new File(archive.getOutputDirectory()).getCanonicalFile();
        for (int i = 0; i < includedFiles.length; ++i) {
            String path = includedFiles[i];
            File from = new File(archiveDir, path);
            File to = new File(outputDir, path);
            FileUtils.copyFile((File)from, (File)to);
        }
    }

    private void expandConfigurationArchive(ConfigurationArchive archive) throws ArchiveExpansionException, IOException {
        this.tempExpansionDir.mkdirs();
        File archiveSource = archive.getSource();
        String tempDirName = archiveSource.getPath().replace('/', '_').replace('\\', '_').replaceAll(":", "");
        File archiveWorkDir = new File(this.tempExpansionDir, tempDirName);
        ArchiveExpansionRequest request = new ArchiveExpansionRequest();
        request.setSourceArchive(archiveSource);
        request.setExpandTarget(archiveWorkDir);
        request.setOverwrite(true);
        this.archiveExpander.expand(request);
        archive.setExpandedDirectory(archiveWorkDir.getCanonicalPath());
    }
}

