/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header.transformer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.mojo.license.header.FileHeader;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.mojo.license.model.Copyright;

public abstract class AbstractFileHeaderTransformer
implements FileHeaderTransformer {
    static final Pattern COPYRIGHT_PATTERN = Pattern.compile("(.[^\\d]+)?\\s(\\d{4})?(\\s+-\\s+(\\d{4})?){0,1}\\s+(.+)?", 32);
    private String name;
    private String description;
    private String sectionDelimiter = "%%";
    private String processStartTag = "#%L";
    private String processEndTag = "#L%";
    private String commentStartTag;
    private String commentEndTag;
    private String commentLinePrefix;
    private boolean emptyLineAfterHeader;
    private boolean trimHeaderLine;
    private String lineSeparator;
    private static final Pattern REMOVE_SPACE_PATTERN = Pattern.compile("(\\s+)");

    protected AbstractFileHeaderTransformer(String name, String description, String commentStartTag, String commentEndTag, String commentLinePrefix) {
        this.name = name;
        this.description = description;
        if (commentStartTag.equals(commentLinePrefix)) {
            throw new IllegalStateException("commentStartTag can not be equals to commentPrefixLine, but was [" + commentStartTag + "]");
        }
        if (commentEndTag.equals(commentLinePrefix)) {
            throw new IllegalStateException("commentEndTag can not be equals to commentPrefixLine, but was [" + commentEndTag + "]");
        }
        this.commentStartTag = commentStartTag;
        this.commentEndTag = commentEndTag;
        this.commentLinePrefix = commentLinePrefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getSectionDelimiter() {
        return this.sectionDelimiter;
    }

    @Override
    public void setSectionDelimiter(String sectionDelimiter) {
        this.sectionDelimiter = sectionDelimiter;
    }

    @Override
    public String getProcessStartTag() {
        return this.processStartTag;
    }

    @Override
    public void setProcessStartTag(String processStartTag) {
        this.processStartTag = processStartTag;
    }

    @Override
    public String getProcessEndTag() {
        return this.processEndTag;
    }

    @Override
    public void setProcessEndTag(String processEndTag) {
        this.processEndTag = processEndTag;
    }

    @Override
    public String getCommentStartTag() {
        return this.commentStartTag;
    }

    @Override
    public void setCommentStartTag(String commentStartTag) {
        this.commentStartTag = commentStartTag;
    }

    @Override
    public String getCommentEndTag() {
        return this.commentEndTag;
    }

    @Override
    public void setCommentEndTag(String commentEndTag) {
        this.commentEndTag = commentEndTag;
    }

    @Override
    public String getCommentLinePrefix() {
        return this.commentLinePrefix;
    }

    @Override
    public String getLineSeparator() {
        if (this.lineSeparator == null) {
            this.lineSeparator = LINE_SEPARATOR;
            return this.lineSeparator;
        }
        return this.lineSeparator;
    }

    @Override
    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    @Override
    public String addHeader(String header, String content) {
        String line;
        String[] contentSplit;
        if (this.isEmptyLineAfterHeader() && (contentSplit = content.split("\\r?\\n", 2)).length > 0 && (line = contentSplit[0].trim()).length() > 0) {
            return header + this.getLineSeparator() + content;
        }
        return header + content;
    }

    @Override
    public void setCommentLinePrefix(String commentLinePrefix) {
        this.commentLinePrefix = commentLinePrefix;
    }

    @Override
    public boolean isEmptyLineAfterHeader() {
        return this.emptyLineAfterHeader;
    }

    @Override
    public void setEmptyLineAfterHeader(boolean emptyLine) {
        this.emptyLineAfterHeader = emptyLine;
    }

    @Override
    public boolean isTrimHeaderLine() {
        return this.trimHeaderLine;
    }

    @Override
    public void setTrimHeaderLine(boolean trimLine) {
        this.trimHeaderLine = trimLine;
    }

    @Override
    public FileHeader toFileHeader(String header) {
        FileHeader model = new FileHeader();
        String[] sections = header.split(this.getSectionDelimiter());
        if (sections.length != 3) {
            throw new IllegalStateException("could not find 3 sections in\n" + header);
        }
        String description = sections[0].trim();
        model.setDescription(description);
        String copyrightModel = sections[1].trim();
        Matcher matcher = COPYRIGHT_PATTERN.matcher(copyrightModel);
        if (!matcher.matches()) {
            throw new IllegalStateException("copyright [" + copyrightModel + "] is not valid");
        }
        String firstYear = matcher.group(2);
        String lastYear = matcher.group(4);
        String holder = matcher.group(5);
        Copyright copyright1 = Copyright.newCopyright(Integer.valueOf(firstYear), lastYear == null ? null : Integer.valueOf(lastYear.trim()), holder.trim());
        model.setCopyright(copyright1);
        String license = sections[2].trim();
        model.setLicense(license);
        return model;
    }

    @Override
    public String toString(FileHeader model) {
        if (model == null) {
            throw new NullPointerException("model can not be null!");
        }
        StringBuilder buffer = new StringBuilder();
        String sectionDelimiter = this.getLineSeparator() + this.getSectionDelimiter() + this.getLineSeparator();
        buffer.append(model.getDescription().trim());
        buffer.append(sectionDelimiter);
        buffer.append(model.getCopyright().getText().trim());
        buffer.append(sectionDelimiter);
        buffer.append(model.getLicense().trim()).append(this.getLineSeparator());
        return buffer.toString();
    }

    @Override
    public String toHeaderContent(FileHeader model) {
        String result = this.toString(model);
        result = this.boxProcessTag(result);
        result = this.boxComment(result, false);
        int index = result.indexOf(this.getProcessStartTag());
        int lastIndex = result.lastIndexOf(this.getProcessEndTag()) + this.getProcessEndTag().length();
        result = result.substring(index, lastIndex);
        return result;
    }

    @Override
    public String boxComment(String header, boolean withTags) {
        StringBuilder buffer = new StringBuilder();
        if (withTags) {
            buffer.append(this.getCommentStartTag()).append(this.getLineSeparator());
        }
        for (String line : header.split("\\r?\\n")) {
            if (this.isTrimHeaderLine()) {
                StringBuilder lineBuffer = new StringBuilder();
                lineBuffer.append(this.getCommentLinePrefix());
                lineBuffer.append(line);
                buffer.append(StringUtils.stripEnd((String)lineBuffer.toString(), null));
            } else {
                buffer.append(this.getCommentLinePrefix());
                buffer.append(line);
            }
            buffer.append(this.getLineSeparator());
        }
        if (withTags) {
            buffer.append(this.getCommentEndTag()).append(this.getLineSeparator());
        }
        return buffer.toString();
    }

    @Override
    public String unboxComent(String header) {
        StringBuilder buffer = new StringBuilder();
        int prefixLength = this.getCommentLinePrefix().length();
        for (String line : header.split(this.getLineSeparator() + "")) {
            String s;
            if (StringUtils.isEmpty((CharSequence)line) || line.contains(this.getCommentStartTag()) || line.contains(this.getCommentEndTag())) continue;
            int index = line.indexOf(this.getCommentLinePrefix());
            line = index > -1 ? line.substring(index + prefixLength) : (line.startsWith(s = this.getCommentLinePrefix().trim()) ? line.substring(s.length()) : "");
            buffer.append(line).append(this.getLineSeparator());
        }
        return buffer.toString();
    }

    @Override
    public String boxProcessTag(String header) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getProcessStartTag()).append(this.getLineSeparator());
        buffer.append(header.trim()).append(this.getLineSeparator());
        buffer.append(this.getProcessEndTag()).append(this.getLineSeparator());
        return buffer.toString();
    }

    @Override
    public String unboxProcessTag(String boxedHeader) {
        StringBuilder buffer = new StringBuilder();
        for (String line : boxedHeader.split(this.getLineSeparator() + "")) {
            if (StringUtils.isEmpty((CharSequence)line) || line.contains(this.getProcessStartTag()) || line.contains(this.getProcessEndTag())) continue;
            buffer.append(line).append(this.getLineSeparator());
        }
        return buffer.toString();
    }

    @Override
    public boolean isDescriptionEquals(FileHeader header1, FileHeader header2) {
        return header1.getDescription().equals(header2.getDescription());
    }

    @Override
    public boolean isCopyrightEquals(FileHeader header1, FileHeader header2) {
        return header1.getCopyright().equals(header2.getCopyright());
    }

    @Override
    public boolean isLicenseEquals(FileHeader header1, FileHeader header2) {
        String license1 = this.removeSpaces(header1.getLicense());
        String license2 = this.removeSpaces(header2.getLicense());
        return license1.equals(license2);
    }

    private String removeSpaces(String str) {
        Matcher matcher = REMOVE_SPACE_PATTERN.matcher(str);
        String result = matcher.find() ? matcher.replaceAll("") : str;
        return result;
    }
}

