/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.license.LicenseMojoUtils;
import org.codehaus.mojo.license.api.FreeMarkerHelper;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.mojo.license.utils.SortedProperties;
import org.codehaus.mojo.license.utils.UrlRequester;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultThirdPartyTool
implements ThirdPartyTool {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultThirdPartyTool.class);
    private static final String DESCRIPTOR_CLASSIFIER = "third-party";
    private static final String DESCRIPTOR_TYPE = "properties";
    private static final Pattern GAV_PLUS_TYPE_PATTERN = Pattern.compile("(.+)--(.+)--(.+)--(.+)");
    private static final Pattern GAV_PLUS_TYPE_AND_CLASSIFIER_PATTERN = Pattern.compile("(.+)--(.+)--(.+)--(.+)--(.+)");
    public static final String LICENSE_DB_TYPE = "license.properties";
    private final RepositorySystem aetherRepoSystem;
    private final Provider<MavenSession> mavenSessionProvider;
    private final MavenProjectHelper projectHelper;
    private final FreeMarkerHelper freeMarkerHelper = FreeMarkerHelper.newDefaultHelper();
    private final Comparator<MavenProject> projectComparator = MojoHelper.newMavenProjectComparator();
    private boolean verbose;

    @Inject
    DefaultThirdPartyTool(RepositorySystem aetherRepoSystem, Provider<MavenSession> mavenSessionProvider, MavenProjectHelper projectHelper) {
        this.aetherRepoSystem = aetherRepoSystem;
        this.mavenSessionProvider = mavenSessionProvider;
        this.projectHelper = projectHelper;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public void attachThirdPartyDescriptor(MavenProject project, File file) {
        this.projectHelper.attachArtifact(project, DESCRIPTOR_TYPE, DESCRIPTOR_CLASSIFIER, file);
    }

    @Override
    public SortedSet<MavenProject> getProjectsWithNoLicense(LicenseMap licenseMap) {
        SortedSet unsafeDependencies = (SortedSet)licenseMap.get("Unknown license");
        if (CollectionUtils.isEmpty((Collection)unsafeDependencies)) {
            LOG.debug("There is no dependency with no license from poms.");
        } else if (LOG.isDebugEnabled()) {
            boolean plural = unsafeDependencies.size() > 1;
            String message = String.format("There %s %d %s with no license from poms :", plural ? "are" : "is", unsafeDependencies.size(), plural ? "dependencies" : "dependency");
            LOG.debug(message);
            for (MavenProject dep : unsafeDependencies) {
                LOG.debug(" - {}", (Object)MojoHelper.getArtifactId(dep.getArtifact()));
            }
        }
        return unsafeDependencies;
    }

    @Override
    public SortedProperties loadThirdPartyDescriptorsForUnsafeMapping(Set<Artifact> topLevelDependencies, String encoding, Collection<MavenProject> projects, SortedSet<MavenProject> unsafeDependencies, LicenseMap licenseMap, List<RemoteRepository> remoteRepositories) throws ThirdPartyToolException, IOException {
        SortedProperties result = new SortedProperties(encoding);
        HashMap<String, MavenProject> unsafeProjects = new HashMap<String, MavenProject>();
        for (MavenProject unsafeDependency : unsafeDependencies) {
            String id = MojoHelper.getArtifactId(unsafeDependency.getArtifact());
            unsafeProjects.put(id, unsafeDependency);
        }
        for (MavenProject mavenProject : projects) {
            if (CollectionUtils.isEmpty(unsafeDependencies)) break;
            File thirdPartyDescriptor = this.resolvThirdPartyDescriptor(mavenProject, remoteRepositories);
            if (thirdPartyDescriptor == null || !thirdPartyDescriptor.exists() || thirdPartyDescriptor.length() <= 0L) continue;
            LOG.info("Detects third party descriptor {}", (Object)thirdPartyDescriptor);
            SortedProperties unsafeMappings = new SortedProperties(encoding);
            if (thirdPartyDescriptor.exists()) {
                LOG.info("Load missing file {}", (Object)thirdPartyDescriptor);
                unsafeMappings.load(thirdPartyDescriptor);
            }
            this.resolveUnsafe(unsafeDependencies, licenseMap, unsafeProjects, unsafeMappings, result);
        }
        try {
            this.loadGlobalLicenses(topLevelDependencies, remoteRepositories, unsafeDependencies, licenseMap, unsafeProjects, result);
        }
        catch (ArtifactResolutionException | ArtifactNotFoundException e) {
            throw new ThirdPartyToolException("Failed to load global licenses", (Exception)e);
        }
        return result;
    }

    private void resolveUnsafe(SortedSet<MavenProject> unsafeDependencies, LicenseMap licenseMap, Map<String, MavenProject> unsafeProjects, SortedProperties unsafeMappings, SortedProperties result) {
        for (String id : unsafeProjects.keySet()) {
            String license;
            if (!unsafeMappings.containsKey(id) || StringUtils.isEmpty((CharSequence)(license = (String)unsafeMappings.get(id)))) continue;
            MavenProject resolvedProject = unsafeProjects.get(id);
            unsafeDependencies.remove(resolvedProject);
            result.put(id, license.trim());
            this.addLicense(licenseMap, resolvedProject, license);
        }
    }

    @Override
    public File resolvThirdPartyDescriptor(MavenProject project, List<RemoteRepository> remoteRepositories) throws ThirdPartyToolException {
        if (project == null) {
            throw new IllegalArgumentException("The parameter 'project' can not be null");
        }
        if (remoteRepositories == null) {
            throw new IllegalArgumentException("The parameter 'remoteRepositories' can not be null");
        }
        try {
            return this.resolveThirdPartyDescriptor(project, remoteRepositories);
        }
        catch (ArtifactResolutionException e) {
            throw new ThirdPartyToolException("ArtifactResolutionException: Unable to locate third party descriptor: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    @Override
    public void addLicense(LicenseMap licenseMap, MavenProject project, String ... licenseNames) {
        ArrayList<License> licenses = new ArrayList<License>();
        for (String licenseName : licenseNames) {
            License license = new License();
            license.setName(licenseName.trim());
            license.setUrl(licenseName.trim());
            licenses.add(license);
        }
        this.addLicense(licenseMap, project, licenses);
    }

    @Override
    public void addLicense(LicenseMap licenseMap, MavenProject project, License license) {
        this.addLicense(licenseMap, project, Collections.singletonList(license));
    }

    @Override
    public void addLicense(LicenseMap licenseMap, MavenProject project, List<?> licenses) {
        if ("system".equals(project.getArtifact().getScope())) {
            return;
        }
        if (CollectionUtils.isEmpty(licenses)) {
            licenseMap.put("Unknown license", project);
            return;
        }
        for (Object o : licenses) {
            String id = MojoHelper.getArtifactId(project.getArtifact());
            if (o == null) {
                LOG.warn("could not acquire the license for {}", (Object)id);
                continue;
            }
            License license = (License)o;
            String licenseKey = license.getName();
            if (StringUtils.isEmpty((CharSequence)license.getName())) {
                LOG.warn("The license for {} has no name (but exist)", (Object)id);
                licenseKey = license.getUrl();
            }
            if (StringUtils.isEmpty((CharSequence)licenseKey)) {
                LOG.warn("No license url defined for {}", (Object)id);
                licenseKey = "Unknown license";
            }
            licenseMap.put(licenseKey, project);
        }
    }

    @Override
    public void mergeLicenses(LicenseMap licenseMap, String mainLicense, Set<String> licenses) {
        if (licenses.isEmpty()) {
            return;
        }
        TreeSet<MavenProject> mainSet = (TreeSet<MavenProject>)licenseMap.get(mainLicense);
        if (mainSet == null) {
            if (this.isVerbose()) {
                LOG.warn("No license [{}] found, will create it.", (Object)mainLicense);
            }
            mainSet = new TreeSet<MavenProject>(this.projectComparator);
            licenseMap.put(mainLicense, mainSet);
        }
        for (String license : licenses) {
            SortedSet set = (SortedSet)licenseMap.get(license);
            if (set == null) {
                if (!this.isVerbose()) continue;
                LOG.warn("No license [{}] found, skip the merge to [{}]", (Object)license, (Object)mainLicense);
                continue;
            }
            if (this.isVerbose()) {
                LOG.info("Merge license [{}] to [{}] ({} dependencies).", new Object[]{license, mainLicense, set.size()});
            }
            mainSet.addAll(set);
            set.clear();
            licenseMap.remove(license);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedProperties loadUnsafeMapping(LicenseMap licenseMap, SortedMap<String, MavenProject> artifactCache, String encoding, File missingFile, String missingFileUrl) throws IOException {
        String id;
        HashMap<String, MavenProject> snapshots = new HashMap<String, MavenProject>();
        SortedMap<String, MavenProject> sortedMap = artifactCache;
        synchronized (sortedMap) {
            for (Map.Entry<String, MavenProject> entry : artifactCache.entrySet()) {
                MavenProject mavenProject = entry.getValue();
                if (!mavenProject.getVersion().endsWith("SNAPSHOT")) continue;
                snapshots.put(entry.getKey(), mavenProject);
            }
        }
        for (Map.Entry entry : snapshots.entrySet()) {
            artifactCache.remove(entry.getKey());
            MavenProject mavenProject = (MavenProject)entry.getValue();
            String id2 = MojoHelper.getArtifactId(mavenProject.getArtifact());
            artifactCache.put(id2, mavenProject);
        }
        SortedSet<MavenProject> unsafeDependencies = this.getProjectsWithNoLicense(licenseMap);
        SortedProperties sortedProperties = new SortedProperties(encoding);
        if (missingFile.exists()) {
            LOG.info("Load missingFile {}", (Object)missingFile);
            sortedProperties.load(missingFile);
        }
        if (UrlRequester.isStringUrl(missingFileUrl)) {
            String httpRequestResult = UrlRequester.getFromUrl(missingFileUrl);
            sortedProperties.load(new ByteArrayInputStream(httpRequestResult.getBytes()));
        }
        ArrayList<String> unknownDependenciesId = new ArrayList<String>();
        Map<String, String> migrateKeys = this.migrateMissingFileKeys(sortedProperties.keySet());
        for (String string : migrateKeys.keySet()) {
            id = string;
            String migratedId = migrateKeys.get(id);
            MavenProject project = (MavenProject)artifactCache.get(migratedId);
            if (project == null) {
                unknownDependenciesId.add(id);
                continue;
            }
            if (id.equals(migratedId)) continue;
            LOG.info("Migrates [{}] to [{}] in the missing file.", (Object)id, (Object)migratedId);
            Object value = sortedProperties.get(id);
            sortedProperties.remove(id);
            sortedProperties.put(migratedId, value);
        }
        if (!unknownDependenciesId.isEmpty()) {
            for (String string : unknownDependenciesId) {
                LOG.warn("dependency [{}] does not exist in project, remove it from the missing file.", (Object)string);
                sortedProperties.remove(string);
            }
            unknownDependenciesId.clear();
        }
        for (Object object : sortedProperties.keySet()) {
            id = (String)object;
            MavenProject project = (MavenProject)artifactCache.get(id);
            if (project == null) {
                LOG.warn("dependency [{}] does not exist in project.", (Object)id);
                continue;
            }
            String license = (String)sortedProperties.get(id);
            Object[] licenses = StringUtils.split((String)license, (char)'|');
            if (ArrayUtils.isEmpty((Object[])licenses)) continue;
            this.addLicense(licenseMap, project, (String[])licenses);
            unsafeDependencies.remove(project);
        }
        if (unsafeDependencies.isEmpty()) {
            licenseMap.remove("Unknown license");
        } else {
            for (MavenProject mavenProject : unsafeDependencies) {
                id = MojoHelper.getArtifactId(mavenProject.getArtifact());
                LOG.debug("dependency [{}] has no license, add it in the missing file.", (Object)id);
                sortedProperties.setProperty(id, "");
            }
        }
        return sortedProperties;
    }

    @Override
    public void overrideLicenses(LicenseMap licenseMap, SortedMap<String, MavenProject> artifactCache, String encoding, String overrideUrl) throws IOException {
        if (LicenseMojoUtils.isValid(overrideUrl)) {
            SortedProperties overrideMappings = new SortedProperties(encoding);
            try (StringReader reader = new StringReader(UrlRequester.getFromUrl(overrideUrl, encoding));){
                overrideMappings.load(reader);
            }
            boolean isExternalUrl = UrlRequester.isExternalUrl(overrideUrl);
            for (Object o : overrideMappings.keySet()) {
                String id = (String)o;
                MavenProject project = (MavenProject)artifactCache.get(id);
                if (project == null) {
                    if (isExternalUrl) {
                        LOG.debug("dependency [{}] does not exist in project.", (Object)id);
                        continue;
                    }
                    LOG.warn("dependency [{}] does not exist in project.", (Object)id);
                    continue;
                }
                String license = (String)overrideMappings.get(id);
                Object[] licenses = StringUtils.split((String)license, (char)'|');
                if (ArrayUtils.isEmpty((Object[])licenses)) continue;
                List<String> removedFrom = licenseMap.removeProject(project);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Overriding license(s) for dependency [{}] with [{}], overriden license(s): [{}]", new Object[]{id, "(" + StringUtils.join((Object[])licenses, (String)") (") + ")", "(" + StringUtils.join((Object[])removedFrom.toArray(), (String)") (") + ")"});
                }
                this.addLicense(licenseMap, project, (String[])licenses);
            }
        }
    }

    @Override
    public void writeThirdPartyFile(LicenseMap licenseMap, File thirdPartyFile, boolean verbose, String encoding, String lineFormat) throws IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("licenseMap", licenseMap.entrySet());
        properties.put("dependencyMap", licenseMap.toDependencyMap().entrySet());
        String content = this.freeMarkerHelper.renderTemplate(lineFormat, properties);
        LOG.info("Writing third-party file to " + thirdPartyFile);
        if (verbose) {
            LOG.info(content);
        }
        FileUtil.printString(thirdPartyFile, content, encoding);
    }

    @Override
    public void writeBundleThirdPartyFile(File thirdPartyFile, File outputDirectory, String bundleThirdPartyPath) throws IOException {
        File bundleTarget = new File(outputDirectory, bundleThirdPartyPath);
        LOG.info("Writing bundled third-party file to {}", (Object)bundleTarget);
        FileUtil.copyFile(thirdPartyFile, bundleTarget);
    }

    private void loadGlobalLicenses(Set<Artifact> dependencies, List<RemoteRepository> remoteRepositories, SortedSet<MavenProject> unsafeDependencies, LicenseMap licenseMap, Map<String, MavenProject> unsafeProjects, SortedProperties result) throws IOException, ArtifactNotFoundException, ArtifactResolutionException {
        for (Artifact dep : dependencies) {
            if (!LICENSE_DB_TYPE.equals(dep.getType())) continue;
            this.loadOneGlobalSet(unsafeDependencies, licenseMap, unsafeProjects, dep, remoteRepositories, result);
        }
    }

    private void loadOneGlobalSet(SortedSet<MavenProject> unsafeDependencies, LicenseMap licenseMap, Map<String, MavenProject> unsafeProjects, Artifact dep, List<RemoteRepository> remoteRepositories, SortedProperties result) throws IOException, ArtifactResolutionException {
        File propFile = this.resolveArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getType(), dep.getClassifier(), remoteRepositories);
        LOG.info("Loading global license map from {}: {}", (Object)dep.toString(), (Object)propFile.getAbsolutePath());
        SortedProperties props = new SortedProperties("utf-8");
        try (InputStream propStream = Files.newInputStream(propFile.toPath(), new OpenOption[0]);){
            props.load(propStream);
        }
        catch (IOException e) {
            throw new IOException("Unable to load " + propFile.getAbsolutePath(), e);
        }
        for (Object keyObj : props.keySet()) {
            String key = (String)keyObj;
            String val = (String)props.get(key);
            result.put(key, val);
        }
        this.resolveUnsafe(unsafeDependencies, licenseMap, unsafeProjects, props, result);
    }

    private File resolveThirdPartyDescriptor(MavenProject project, List<RemoteRepository> remoteRepositories) throws ArtifactResolutionException {
        File result;
        try {
            result = this.resolveArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), DESCRIPTOR_TYPE, DESCRIPTOR_CLASSIFIER, remoteRepositories);
            if (result.length() == 0L) {
                LOG.debug("Skipped third party descriptor");
            }
        }
        catch (ArtifactResolutionException e) {
            if (e.getCause() instanceof ArtifactNotFoundException) {
                ArtifactNotFoundException artifactNotFoundException = (ArtifactNotFoundException)e.getCause();
                LOG.debug("Unable to locate third party files descriptor", (Throwable)artifactNotFoundException);
                Object artifact = artifactNotFoundException.getArtifact() == null ? new DefaultArtifact(project.getGroupId(), project.getArtifactId(), DESCRIPTOR_CLASSIFIER, null, project.getVersion(), (ArtifactType)new DefaultArtifactType(DESCRIPTOR_TYPE)) : artifactNotFoundException.getArtifact();
                RepositorySystemSession aetherSession = ((MavenSession)this.mavenSessionProvider.get()).getRepositorySession();
                result = new File(aetherSession.getLocalRepository().getBasedir(), aetherSession.getLocalRepositoryManager().getPathForLocalArtifact(artifact));
            }
            throw e;
        }
        return result;
    }

    @Override
    public File resolveMissingLicensesDescriptor(String groupId, String artifactId, String version, List<RemoteRepository> remoteRepositories) throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        return this.resolveArtifact(groupId, artifactId, version, DESCRIPTOR_TYPE, DESCRIPTOR_CLASSIFIER, remoteRepositories);
    }

    private File resolveArtifact(String groupId, String artifactId, String version, String type, String classifier, List<RemoteRepository> remoteRepositories) throws ArtifactResolutionException {
        DefaultArtifact artifact2 = new DefaultArtifact(groupId, artifactId, classifier, null, version, (ArtifactType)new DefaultArtifactType(type));
        ArtifactRequest artifactRequest = new ArtifactRequest().setArtifact((org.eclipse.aether.artifact.Artifact)artifact2).setRepositories(remoteRepositories);
        ArtifactResult result = this.aetherRepoSystem.resolveArtifact(((MavenSession)this.mavenSessionProvider.get()).getRepositorySession(), artifactRequest);
        return result.getArtifact().getFile();
    }

    private Map<String, String> migrateMissingFileKeys(Set<Object> missingFileKeys) {
        HashMap<String, String> migrateKeys = new HashMap<String, String>();
        for (Object object : missingFileKeys) {
            String id;
            String newId = id = (String)object;
            Matcher matcher = GAV_PLUS_TYPE_AND_CLASSIFIER_PATTERN.matcher(id);
            if (matcher.matches()) {
                newId = matcher.group(1) + "--" + matcher.group(2) + "--" + matcher.group(3);
            } else {
                matcher = GAV_PLUS_TYPE_PATTERN.matcher(id);
                if (matcher.matches()) {
                    newId = matcher.group(1) + "--" + matcher.group(2) + "--" + matcher.group(3);
                }
            }
            migrateKeys.put(id, newId);
        }
        return migrateKeys;
    }
}

