/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.utils;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MojoHelper {
    protected static final double[] TIME_FACTORS = new double[]{1000000.0, 1000.0, 60.0, 60.0, 24.0};
    protected static final String[] TIME_UNITES = new String[]{"ns", "ms", "s", "m", "h", "d"};

    public static boolean addResourceDir(File dir, MavenProject project, String ... includes) {
        List resources = project.getResources();
        return MojoHelper.addResourceDir(dir, project, resources, includes);
    }

    public static boolean addResourceDir(File dir, MavenProject project, List<?> resources, String ... includes) {
        String newresourceDir = dir.getAbsolutePath();
        boolean shouldAdd = true;
        for (Object o : resources) {
            Resource r = (Resource)o;
            if (!r.getDirectory().equals(newresourceDir)) continue;
            for (String i : includes) {
                if (r.getIncludes().contains(i)) continue;
                r.addInclude(i);
            }
            shouldAdd = false;
            break;
        }
        if (shouldAdd) {
            Resource r = new Resource();
            r.setDirectory(newresourceDir);
            for (String i : includes) {
                if (r.getIncludes().contains(i)) continue;
                r.addInclude(i);
            }
            project.addResource(r);
        }
        return shouldAdd;
    }

    public static Comparator<MavenProject> newMavenProjectComparator() {
        return new Comparator<MavenProject>(){

            @Override
            public int compare(MavenProject o1, MavenProject o2) {
                String id1 = MojoHelper.getArtifactId(o1.getArtifact());
                String id2 = MojoHelper.getArtifactId(o2.getArtifact());
                return id1.compareTo(id2);
            }
        };
    }

    public static String convertTime(long value) {
        return MojoHelper.convert(value, TIME_FACTORS, TIME_UNITES);
    }

    public static String convert(long value, double[] factors, String[] unites) {
        long sign = value == 0L ? 1L : value / Math.abs(value);
        int i = 0;
        for (double tmp = (double)Math.abs(value); i < factors.length && i < unites.length && tmp > factors[i]; tmp /= factors[i++]) {
        }
        String result = MessageFormat.format("{0,number,0.###}{1}", tmp *= (double)sign, unites[i]);
        return result;
    }

    public static URL getUrl(URL baseUrl, String suffix) {
        String url = baseUrl.toString() + "/" + suffix;
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("could not obtain url " + url, ex);
        }
    }

    public static String getArtifactId(Artifact artifact) {
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getGroupId());
        sb.append("--");
        sb.append(artifact.getArtifactId());
        sb.append("--");
        sb.append(artifact.getVersion());
        return sb.toString();
    }

    public static String getArtifactName(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        if (project.getName().startsWith("Unnamed -")) {
            sb.append(project.getArtifactId());
        } else {
            sb.append(project.getName());
        }
        sb.append(" (");
        sb.append(project.getGroupId());
        sb.append(":");
        sb.append(project.getArtifactId());
        sb.append(":");
        sb.append(project.getVersion());
        sb.append(" - ");
        String url = project.getUrl();
        sb.append(url == null ? "no url defined" : url);
        sb.append(")");
        return sb.toString();
    }

    public static List<String> getParams(String params) {
        String[] split = params == null ? new String[]{} : params.split(",");
        return Arrays.asList(split);
    }
}

