/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.download;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.mojo.license.download.License;

public class LicensedArtifact {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final List<License> licenses;
    private final List<String> errorMessages;

    public static Builder builder(String groupId, String artifactId, String version) {
        return new Builder(groupId, artifactId, version);
    }

    LicensedArtifact(String groupId, String artifactId, String version, List<License> licenses, List<String> errorMessages) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.licenses = licenses;
        this.errorMessages = errorMessages;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.licenses == null ? 0 : this.licenses.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LicensedArtifact other = (LicensedArtifact)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.licenses == null ? other.licenses != null : !this.licenses.equals(other.licenses)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public static class Builder {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private List<License> licenses = new ArrayList<License>();
        private List<String> errorMessages = new ArrayList<String>();

        public Builder(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessages.add(errorMessage);
            return this;
        }

        public Builder license(License license) {
            this.licenses.add(license);
            return this;
        }

        public LicensedArtifact build() {
            List<License> lics = Collections.unmodifiableList(this.licenses);
            this.licenses = null;
            List<String> msgs = Collections.unmodifiableList(this.errorMessages);
            this.errorMessages = null;
            return new LicensedArtifact(this.groupId, this.artifactId, this.version, lics, msgs);
        }
    }
}

