/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.api;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.codehaus.mojo.license.api.ArtifactFilters;
import org.codehaus.mojo.license.api.DependenciesToolException;
import org.codehaus.mojo.license.api.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.api.ResolvedProjectDependencies;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=DependenciesTool.class, hint="default")
public class DependenciesTool
extends AbstractLogEnabled {
    public static final String INVALID_PATTERN_MESSAGE = "The pattern specified by expression <%s> seems to be invalid.";
    @Requirement
    private MavenProjectBuilder mavenProjectBuilder;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactMetadataSource artifactMetadataSource;

    public SortedMap<String, MavenProject> loadProjectDependencies(ResolvedProjectDependencies artifacts, MavenProjectDependenciesConfigurator configuration, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, SortedMap<String, MavenProject> cache) {
        ArtifactFilters artifactFilters = configuration.getArtifactFilters();
        boolean excludeTransitiveDependencies = configuration.isExcludeTransitiveDependencies();
        Set<Artifact> depArtifacts = configuration.isIncludeTransitiveDependencies() ? artifacts.getAllDependencies() : artifacts.getDirectDependencies();
        boolean verbose = configuration.isVerbose();
        TreeMap<String, MavenProject> result = new TreeMap<String, MavenProject>();
        HashMap<String, Artifact> excludeArtifacts = new HashMap<String, Artifact>();
        HashMap<String, Artifact> includeArtifacts = new HashMap<String, Artifact>();
        TreeMap<String, MavenProject> localCache = new TreeMap<String, MavenProject>();
        if (cache != null) {
            localCache.putAll(cache);
        }
        Logger log = this.getLogger();
        for (Artifact artifact : depArtifacts) {
            MavenProject depMavenProject;
            excludeArtifacts.put(artifact.getId(), artifact);
            if ("license.properties".equals(artifact.getType())) continue;
            if (!artifactFilters.isIncluded(artifact)) {
                if (!verbose) continue;
                log.debug("Excluding artifact " + artifact);
                continue;
            }
            String id = MojoHelper.getArtifactId(artifact);
            if (verbose) {
                log.info("detected artifact " + id);
            }
            if ((depMavenProject = (MavenProject)localCache.get(id)) != null) {
                if (verbose) {
                    log.info("add dependency [" + id + "] (from cache)");
                }
            } else {
                block16: {
                    try {
                        depMavenProject = this.mavenProjectBuilder.buildFromRepository(artifact, remoteRepositories, localRepository, true);
                        depMavenProject.getArtifact().setScope(artifact.getScope());
                        if (!depMavenProject.getGroupId().equals(artifact.getGroupId())) {
                            depMavenProject.setGroupId(artifact.getGroupId());
                            depMavenProject.getArtifact().setGroupId(artifact.getGroupId());
                        }
                        if (!depMavenProject.getArtifactId().equals(artifact.getArtifactId())) {
                            depMavenProject.setArtifactId(artifact.getArtifactId());
                            depMavenProject.getArtifact().setArtifactId(artifact.getArtifactId());
                        }
                        if (depMavenProject.getVersion().equals(artifact.getVersion())) break block16;
                        depMavenProject.setVersion(artifact.getVersion());
                        depMavenProject.getArtifact().setVersion(artifact.getVersion());
                    }
                    catch (ProjectBuildingException e) {
                        log.warn("Unable to obtain POM for artifact : " + artifact, (Throwable)e);
                        continue;
                    }
                }
                if (verbose) {
                    log.info("add dependency [" + id + "]");
                }
                localCache.put(id, depMavenProject);
            }
            result.put(id, depMavenProject);
            excludeArtifacts.remove(artifact.getId());
            includeArtifacts.put(artifact.getId(), artifact);
        }
        if (excludeTransitiveDependencies) {
            for (Map.Entry entry : includeArtifacts.entrySet()) {
                List dependencyTrail = ((Artifact)entry.getValue()).getDependencyTrail();
                boolean remove = false;
                for (int i = 1; i < dependencyTrail.size() - 1; ++i) {
                    if (!excludeArtifacts.containsKey(dependencyTrail.get(i))) continue;
                    remove = true;
                    break;
                }
                if (!remove) continue;
                result.remove(MojoHelper.getArtifactId((Artifact)entry.getValue()));
            }
        }
        if (cache != null) {
            cache.putAll(result);
        }
        return result;
    }

    public ResolvedProjectDependencies loadProjectArtifacts(ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, MavenProject project, List<MavenProject> reactorProjects) throws DependenciesToolException {
        HashMap<String, MavenProject> idToReactorProject = new HashMap<String, MavenProject>();
        if (reactorProjects != null) {
            for (MavenProject reactorProject : reactorProjects) {
                idToReactorProject.put(String.format("%s:%s", reactorProject.getGroupId(), reactorProject.getArtifactId()), reactorProject);
            }
        }
        ArrayList<Dependency> directDependencies = new ArrayList<Dependency>(project.getDependencies());
        HashMap<Object, ArrayList<Dependency>> reactorProjectToTransitiveDependencies = new HashMap<Object, ArrayList<Dependency>>();
        ArrayDeque<Pair> dependenciesToCheck = new ArrayDeque<Pair>();
        for (Dependency dependency : directDependencies) {
            dependenciesToCheck.add(Pair.of((Object)project, (Object)dependency));
        }
        if (reactorProjects != null) {
            while (!dependenciesToCheck.isEmpty()) {
                Dependency dependency;
                Pair pair = (Pair)dependenciesToCheck.remove();
                dependency = (Dependency)pair.getRight();
                String id = String.format("%s:%s", dependency.getGroupId(), dependency.getArtifactId());
                MavenProject dependencyReactorProject = (MavenProject)idToReactorProject.get(id);
                if (dependencyReactorProject != null) {
                    for (Dependency dependency2 : dependencyReactorProject.getDependencies()) {
                        dependenciesToCheck.add(Pair.of((Object)dependencyReactorProject, (Object)dependency2));
                    }
                }
                if (directDependencies.contains(dependency)) continue;
                List<Object> transitiveForSameProject = (List)reactorProjectToTransitiveDependencies.get(pair.getLeft());
                if (transitiveForSameProject == null) {
                    transitiveForSameProject = new ArrayList<Dependency>();
                    reactorProjectToTransitiveDependencies.put(pair.getLeft(), (ArrayList<Dependency>)transitiveForSameProject);
                }
                transitiveForSameProject.add(dependency);
            }
        }
        Set<Artifact> directDependencyArtifacts = this.createDependencyArtifacts(project, directDependencies);
        HashMap reactorProjectToDependencyArtifacts = new HashMap();
        for (Map.Entry entry : reactorProjectToTransitiveDependencies.entrySet()) {
            reactorProjectToDependencyArtifacts.put(entry.getKey(), this.createDependencyArtifacts((MavenProject)entry.getKey(), (List)entry.getValue()));
        }
        HashSet<Artifact> reactorArtifacts = new HashSet<Artifact>();
        HashSet<Artifact> directArtifactsToResolve = new HashSet<Artifact>();
        if (reactorProjects == null) {
            directArtifactsToResolve.addAll(directDependencyArtifacts);
        } else {
            this.partitionByIsReactorProject(directDependencyArtifacts, reactorArtifacts, directArtifactsToResolve, idToReactorProject.keySet());
            for (Map.Entry entry : reactorProjectToDependencyArtifacts.entrySet()) {
                HashSet<Artifact> nonReactorArtifacts = new HashSet<Artifact>();
                this.partitionByIsReactorProject((Set)entry.getValue(), reactorArtifacts, nonReactorArtifacts, idToReactorProject.keySet());
                entry.setValue(nonReactorArtifacts);
            }
        }
        HashSet<Artifact> allDependencies = new HashSet<Artifact>(reactorArtifacts);
        allDependencies.addAll(this.resolve(directArtifactsToResolve, project.getArtifact(), localRepository, remoteRepositories).getArtifacts());
        for (Map.Entry entry : reactorProjectToDependencyArtifacts.entrySet()) {
            MavenProject reactorProject = (MavenProject)entry.getKey();
            Set toResolve = (Set)entry.getValue();
            Artifact reactorProjectArtifact = reactorProject.getArtifact();
            List reactorRemoteRepositories = reactorProject.getRemoteArtifactRepositories();
            allDependencies.addAll(this.resolve(toResolve, reactorProjectArtifact, localRepository, reactorRemoteRepositories).getArtifacts());
        }
        return new ResolvedProjectDependencies(allDependencies, directDependencyArtifacts);
    }

    private Set<Artifact> createDependencyArtifacts(MavenProject project, List<Dependency> dependencies) throws DependenciesToolException {
        try {
            return MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, dependencies, null, null, (MavenProject)project);
        }
        catch (InvalidDependencyVersionException e) {
            throw new DependenciesToolException(e);
        }
    }

    private void partitionByIsReactorProject(Set<Artifact> artifacts, Set<Artifact> reactorArtifacts, Set<Artifact> nonReactorArtifacts, Set<String> reactorProjectIds) {
        for (Artifact dependencyArtifact : artifacts) {
            String artifactKey = String.format("%s:%s", dependencyArtifact.getGroupId(), dependencyArtifact.getArtifactId());
            if (reactorProjectIds.contains(artifactKey)) {
                reactorArtifacts.add(dependencyArtifact);
                continue;
            }
            nonReactorArtifacts.add(dependencyArtifact);
        }
    }

    private ArtifactResolutionResult resolve(Set<Artifact> artifacts, Artifact projectArtifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws DependenciesToolException {
        try {
            return this.artifactResolver.resolveTransitively(artifacts, projectArtifact, remoteRepositories, localRepository, this.artifactMetadataSource);
        }
        catch (ArtifactResolutionException e) {
            throw new DependenciesToolException(e);
        }
        catch (ArtifactNotFoundException e) {
            throw new DependenciesToolException(e);
        }
    }
}

