/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractAddThirdPartyMojo;
import org.codehaus.mojo.license.AddThirdPartyMojo;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.SortedProperties;

@Mojo(name="aggregate-add-third-party", aggregator=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class AggregatorAddThirdPartyMojo
extends AbstractAddThirdPartyMojo {
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="license.skipAggregateAddThirdParty", defaultValue="false")
    private boolean skipAggregateAddThirdParty;
    @Deprecated
    @Parameter(property="license.aggregateMissingLicensesFileArtifact")
    private String aggregateMissingLicensesFileArtifact;
    @Deprecated
    @Parameter(property="license.aggregateMissingLicensesFile")
    private File aggregateMissingLicensesFile;

    @Override
    public boolean isSkip() {
        return this.skipAggregateAddThirdParty;
    }

    @Override
    protected boolean checkPackaging() {
        return this.acceptPackaging("pom");
    }

    @Override
    protected boolean checkSkip() {
        if (!this.doGenerate && !this.doGenerateBundle) {
            this.getLog().info((CharSequence)"All files are up to date, skip goal execution.");
            return false;
        }
        return super.checkSkip();
    }

    @Override
    protected void init() throws Exception {
        if (this.aggregateMissingLicensesFile != null && !this.aggregateMissingLicensesFile.equals(this.missingFile)) {
            this.getLog().warn((CharSequence)"");
            this.getLog().warn((CharSequence)"You should use *missingFile* parameter instead of deprecated *aggregateMissingLicensesFile*.");
            this.getLog().warn((CharSequence)"");
            this.missingFile = this.aggregateMissingLicensesFile;
        }
        if (this.aggregateMissingLicensesFileArtifact != null && !this.aggregateMissingLicensesFileArtifact.equals(this.missingLicensesFileArtifact)) {
            this.getLog().warn((CharSequence)"");
            this.getLog().warn((CharSequence)"You should use *missingLicensesFileArtifact* parameter instead of deprecated *aggregateMissingLicensesFileArtifact*.");
            this.getLog().warn((CharSequence)"");
            this.missingLicensesFileArtifact = this.aggregateMissingLicensesFileArtifact;
        }
        super.init();
    }

    @Override
    protected void doAction() throws Exception {
        Log log = this.getLog();
        if (this.isVerbose()) {
            log.info((CharSequence)("After executing on " + this.reactorProjects.size() + " project(s)"));
        }
        this.licenseMap = new LicenseMap();
        Artifact pluginArtifact = (Artifact)this.project.getPluginArtifactMap().get("org.codehaus.mojo:license-maven-plugin");
        String groupId = null;
        String artifactId = null;
        String version = null;
        if (pluginArtifact == null) {
            Plugin plugin = (Plugin)this.project.getPluginManagement().getPluginsAsMap().get("org.codehaus.mojo:license-maven-plugin");
            if (plugin != null) {
                groupId = plugin.getGroupId();
                artifactId = plugin.getArtifactId();
                version = plugin.getVersion();
            }
        } else {
            groupId = pluginArtifact.getGroupId();
            artifactId = pluginArtifact.getArtifactId();
            version = pluginArtifact.getVersion();
        }
        if (groupId == null) {
            throw new IllegalStateException("Can't find license-maven-plugin");
        }
        String addThirdPartyRoleHint = groupId + ":" + artifactId + ":" + version + ":add-third-party";
        for (MavenProject mavenProject : this.reactorProjects) {
            if (this.getProject().equals((Object)mavenProject) && !this.acceptPomPackaging) continue;
            AddThirdPartyMojo mojo = (AddThirdPartyMojo)this.getSession().lookup(AddThirdPartyMojo.ROLE, addThirdPartyRoleHint);
            mojo.initFromMojo(this, mavenProject, new ArrayList<MavenProject>(this.reactorProjects));
            LicenseMap childLicenseMap = mojo.licenseMap;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)String.format("Found %d license(s) in module %s:%s", childLicenseMap.size(), mojo.project.getGroupId(), mojo.project.getArtifactId()));
            }
            this.licenseMap.putAll(childLicenseMap);
        }
        this.getLog().info((CharSequence)(this.licenseMap.size() + " detected license(s)."));
        if (this.isVerbose()) {
            for (Map.Entry entry : this.licenseMap.entrySet()) {
                this.getLog().info((CharSequence)(" - " + (String)entry.getKey() + " for " + ((SortedSet)entry.getValue()).size() + " artifact(s)."));
            }
        }
        this.consolidate();
        this.checkUnsafeDependencies();
        boolean safeLicense = this.checkForbiddenLicenses();
        this.checkBlacklist(safeLicense);
        this.writeThirdPartyFile();
        this.checkMissing(CollectionUtils.isNotEmpty((Collection)this.unsafeDependencies));
    }

    @Override
    protected SortedMap<String, MavenProject> loadDependencies() {
        return this.getHelper().getArtifactCache();
    }

    @Override
    protected SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException, MojoExecutionException {
        String path = this.missingFile.getAbsolutePath().substring(this.getProject().getBasedir().getAbsolutePath().length() + 1);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Use missing file path : " + path));
        }
        SortedProperties unsafeMappings = new SortedProperties(this.getEncoding());
        for (MavenProject o : this.reactorProjects) {
            SortedSet<MavenProject> unsafe;
            MavenProject p = o;
            File file = new File(p.getBasedir(), path);
            if (file.exists()) {
                SortedProperties tmp = this.getHelper().loadUnsafeMapping(this.licenseMap, file, null, this.projectDependencies);
                unsafeMappings.putAll((Map<?, ?>)tmp);
            }
            if (!CollectionUtils.isEmpty(unsafe = this.getHelper().getProjectsWithNoLicense(this.licenseMap))) continue;
            break;
        }
        return unsafeMappings;
    }
}

