/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.l10n;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="report")
public class L10NStatusReport
extends AbstractMavenReport {
    @Parameter
    private List<String> locales;
    @Parameter
    private List<String> excludes;
    @Parameter
    private List<String> includes;
    @Parameter(defaultValue="false", property="maven.l10n.aggregate")
    protected boolean aggregate;
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.properties"};
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public boolean canGenerateReport() {
        if (this.aggregate && !this.project.isExecutionRoot()) {
            return false;
        }
        return !this.constructResourceDirs().isEmpty();
    }

    protected Map<MavenProject, List<Resource>> constructResourceDirs() {
        HashMap<MavenProject, List<Resource>> sourceDirs = new HashMap<MavenProject, List<Resource>>();
        if (this.aggregate) {
            for (MavenProject prj : this.reactorProjects) {
                if (prj.getResources() == null || prj.getResources().isEmpty()) continue;
                sourceDirs.put(prj, prj.getResources());
            }
        } else if (this.project.getResources() != null && !this.project.getResources().isEmpty()) {
            sourceDirs.put(this.project, this.project.getResources());
        }
        return sourceDirs;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        TreeSet<Wrapper> included = new TreeSet<Wrapper>(new WrapperComparator());
        Map<MavenProject, List<Resource>> res = this.constructResourceDirs();
        for (Map.Entry<MavenProject, List<Resource>> entry : res.entrySet()) {
            MavenProject prj = entry.getKey();
            List<Resource> lst = entry.getValue();
            for (Resource resource : lst) {
                String[] includedFiles;
                File resourceDirectory = new File(resource.getDirectory());
                if (!resourceDirectory.exists()) {
                    this.getLog().info((CharSequence)("Resource directory does not exist: " + resourceDirectory));
                    continue;
                }
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(resource.getDirectory());
                ArrayList<String> allIncludes = new ArrayList<String>();
                if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
                    allIncludes.addAll(resource.getIncludes());
                }
                if (this.includes != null && !this.includes.isEmpty()) {
                    allIncludes.addAll(this.includes);
                }
                if (allIncludes.isEmpty()) {
                    scanner.setIncludes(DEFAULT_INCLUDES);
                } else {
                    scanner.setIncludes(allIncludes.toArray(EMPTY_STRING_ARRAY));
                }
                ArrayList<String> allExcludes = new ArrayList<String>();
                if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
                    allExcludes.addAll(resource.getExcludes());
                } else if (this.excludes != null && !this.excludes.isEmpty()) {
                    allExcludes.addAll(this.excludes);
                }
                scanner.setExcludes(allExcludes.toArray(EMPTY_STRING_ARRAY));
                scanner.addDefaultExcludes();
                scanner.scan();
                for (String name : includedFiles = scanner.getIncludedFiles()) {
                    File source = new File(resource.getDirectory(), name);
                    included.add(new Wrapper(name, source, prj));
                }
            }
        }
        L10NStatusRenderer r = new L10NStatusRenderer(this.getSink(), L10NStatusReport.getBundle(locale), included, locale);
        r.render();
    }

    public String getDescription(Locale locale) {
        return L10NStatusReport.getBundle(locale).getString("report.l10n.description");
    }

    public String getName(Locale locale) {
        return L10NStatusReport.getBundle(locale).getString("report.l10n.name");
    }

    public String getOutputName() {
        return "l10n-status";
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("l10n-status-report", locale, L10NStatusReport.class.getClassLoader());
    }

    private static class WrapperComparator
    implements Comparator<Wrapper> {
        private WrapperComparator() {
        }

        @Override
        public int compare(Wrapper wr1, Wrapper wr2) {
            int comp1 = wr1.getProject().getBasedir().compareTo(wr2.getProject().getBasedir());
            if (comp1 != 0) {
                return comp1;
            }
            return wr1.getFile().compareTo(wr2.getFile());
        }
    }

    static class Wrapper {
        private final String path;
        private final File file;
        private final MavenProject proj;
        private final Map<String, Properties> properties;
        static final String DEFAULT_LOCALE = "Default";

        public Wrapper(String p, File f, MavenProject prj) {
            this.path = p;
            this.file = f;
            this.proj = prj;
            this.properties = new HashMap<String, Properties>();
        }

        public File getFile() {
            return this.file;
        }

        public String getPath() {
            return this.path;
        }

        public MavenProject getProject() {
            return this.proj;
        }

        public Map<String, Properties> getProperties() {
            return this.properties;
        }
    }

    class L10NStatusRenderer
    extends AbstractMavenReportRenderer {
        private final ResourceBundle bundle;
        private final Locale rendererLocale;
        private final Set<Wrapper> files;
        private final Pattern localedPattern;

        public L10NStatusRenderer(Sink sink, ResourceBundle bundle, Set<Wrapper> files, Locale rendererLocale) {
            super(sink);
            this.localedPattern = Pattern.compile(".*_[a-zA-Z]{2}[_]?[a-zA-Z]{0,2}?\\.properties");
            this.bundle = bundle;
            this.files = files;
            this.rendererLocale = rendererLocale;
        }

        public String getTitle() {
            return this.bundle.getString("report.l10n.title");
        }

        public void renderBody() {
            this.startSection(this.getTitle());
            this.paragraph(this.bundle.getString("report.l10n.intro"));
            this.startSection(this.bundle.getString("report.l10n.summary"));
            this.startTable();
            this.tableCaption(this.bundle.getString("report.l10n.summary.caption"));
            String defaultLocaleColumnName = this.bundle.getString("report.l10n.column.default");
            String pathColumnName = this.bundle.getString("report.l10n.column.path");
            String missingFileLabel = this.bundle.getString("report.l10n.missingFile");
            String missingKeysLabel = this.bundle.getString("report.l10n.missingKey");
            String okLabel = this.bundle.getString("report.l10n.ok");
            String totalLabel = this.bundle.getString("report.l10n.total");
            String additionalKeysLabel = this.bundle.getString("report.l10n.additional");
            String nontranslatedKeysLabel = this.bundle.getString("report.l10n.nontranslated");
            String[] headers = new String[L10NStatusReport.this.locales != null ? L10NStatusReport.this.locales.size() + 2 : 2];
            HashMap<String, String> localeDisplayNames = new HashMap<String, String>();
            headers[0] = pathColumnName;
            headers[1] = defaultLocaleColumnName;
            if (L10NStatusReport.this.locales != null) {
                int ind = 2;
                Iterator iterator = L10NStatusReport.this.locales.iterator();
                while (iterator.hasNext()) {
                    String localeCode;
                    headers[ind] = localeCode = (String)iterator.next();
                    ++ind;
                    Locale locale = this.createLocale(localeCode);
                    if (locale == null) {
                        localeDisplayNames.put(localeCode, localeCode);
                        continue;
                    }
                    localeDisplayNames.put(localeCode, locale.getDisplayName(this.rendererLocale));
                }
            }
            this.tableHeader(headers);
            int[] count = new int[L10NStatusReport.this.locales != null ? L10NStatusReport.this.locales.size() + 1 : 1];
            Arrays.fill(count, 0);
            MavenProject lastPrj = null;
            TreeSet<Wrapper> usedFiles = new TreeSet<Wrapper>(new WrapperComparator());
            for (Wrapper wr : this.files) {
                if (L10NStatusReport.this.reactorProjects.size() > 1 && (lastPrj == null || lastPrj != wr.getProject())) {
                    lastPrj = wr.getProject();
                    this.sink.tableRow();
                    String name = wr.getProject().getName();
                    if (name == null) {
                        name = wr.getProject().getGroupId() + ":" + wr.getProject().getArtifactId();
                    }
                    this.tableCell("<b><i>" + name + "</b></i>", true);
                    this.sink.tableRow_();
                }
                if (!wr.getFile().getName().endsWith(".properties") || this.localedPattern.matcher(wr.getFile().getName()).matches()) continue;
                usedFiles.add(wr);
                this.sink.tableRow();
                this.tableCell(wr.getPath());
                Properties props = new Properties();
                try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(wr.getFile().toPath(), new OpenOption[0]));){
                    props.load(in);
                    wr.getProperties().put("Default", props);
                    this.tableCell("" + props.size(), true);
                    count[0] = count[0] + props.size();
                    if (L10NStatusReport.this.locales != null) {
                        int i = 1;
                        for (String loc : L10NStatusReport.this.locales) {
                            String nm = wr.getFile().getName();
                            String fn = nm.substring(0, nm.length() - ".properties".length());
                            File file = new File(wr.getFile().getParentFile(), (String)fn + "_" + loc + ".properties");
                            if (file.exists()) {
                                Properties props2 = new Properties();
                                try (BufferedInputStream in2 = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                                    props2.load(in2);
                                    wr.getProperties().put(loc, props2);
                                    HashSet<String> missing = new HashSet<String>(props.stringPropertyNames());
                                    missing.removeAll(props2.stringPropertyNames());
                                    HashSet<String> additional = new HashSet<String>(props2.stringPropertyNames());
                                    additional.removeAll(props.stringPropertyNames());
                                    HashSet<String> nonTranslated = new HashSet<String>();
                                    for (String k : props.stringPropertyNames()) {
                                        String val2;
                                        String val1 = props.getProperty(k);
                                        if (!val1.equals(val2 = props2.getProperty(k))) continue;
                                        nonTranslated.add(k);
                                    }
                                    count[i] = count[i] + (props.size() - missing.size() - nonTranslated.size());
                                    StringBuilder statusRows = new StringBuilder();
                                    if (!missing.isEmpty()) {
                                        statusRows.append("<tr><td>").append(missingKeysLabel).append("</td><td><b>").append(missing.size()).append("</b></td></tr>");
                                    } else {
                                        statusRows.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
                                    }
                                    if (!additional.isEmpty()) {
                                        statusRows.append("<tr><td>").append(additionalKeysLabel).append("</td><td><b>").append(additional.size()).append("</b></td></tr>");
                                    } else {
                                        statusRows.append("<tr><td>&nbsp;</td><td>&nbsp;</td></tr>");
                                    }
                                    if (!nonTranslated.isEmpty()) {
                                        statusRows.append("<tr><td>").append(nontranslatedKeysLabel).append("</td><td><b>").append(nonTranslated.size()).append("</b></td></tr>");
                                    }
                                    this.tableCell(this.wrapInTable(okLabel, statusRows.toString()), true);
                                }
                            } else {
                                this.tableCell(missingFileLabel);
                                int n = i;
                                count[n] = count[n] + 0;
                            }
                            ++i;
                        }
                    }
                }
                catch (IOException ex) {
                    L10NStatusReport.this.getLog().error((Throwable)ex);
                }
                this.sink.tableRow_();
            }
            this.sink.tableRow();
            this.tableCell(totalLabel);
            for (int i = 0; i < count.length; ++i) {
                if (i != 0 && count[0] != 0) {
                    this.tableCell("<b>" + count[i] + "</b><br />(" + count[i] * 100 / count[0] + "&nbsp;%)", true);
                    continue;
                }
                if (i != 0) continue;
                this.tableCell("<b>" + count[i] + "</b>", true);
            }
            this.sink.tableRow_();
            this.endTable();
            this.paragraph(this.bundle.getString("report.l10n.legend"));
            this.sink.list();
            this.sink.listItem();
            this.text(this.bundle.getString("report.l10n.list1"));
            this.sink.listItem_();
            this.sink.listItem();
            this.text(this.bundle.getString("report.l10n.list2"));
            this.sink.listItem_();
            this.sink.listItem();
            this.text(this.bundle.getString("report.l10n.list3"));
            this.sink.listItem_();
            this.sink.list_();
            this.sink.paragraph();
            this.text(this.bundle.getString("report.l10n.note"));
            this.sink.paragraph_();
            this.endSection();
            if (L10NStatusReport.this.locales != null) {
                this.sink.list();
                for (String x : L10NStatusReport.this.locales) {
                    this.sink.listItem();
                    this.link("#" + x, x + " - " + (String)localeDisplayNames.get(x));
                    this.sink.listItem_();
                }
                this.sink.list_();
                for (String x : L10NStatusReport.this.locales) {
                    this.startSection(x + " - " + (String)localeDisplayNames.get(x));
                    this.sink.anchor(x);
                    this.sink.anchor_();
                    this.startTable();
                    this.tableCaption(this.bundle.getString("report.l10n.locale") + " " + (String)localeDisplayNames.get(x));
                    this.tableHeader(new String[]{this.bundle.getString("report.l10n.tableheader1"), this.bundle.getString("report.l10n.tableheader2"), this.bundle.getString("report.l10n.tableheader3"), this.bundle.getString("report.l10n.tableheader4")});
                    for (Wrapper wr : usedFiles) {
                        this.sink.tableRow();
                        this.tableCell(wr.getPath());
                        Properties defs = wr.getProperties().get("Default");
                        Properties locals = wr.getProperties().get(x);
                        if (locals == null) {
                            locals = new Properties();
                        }
                        TreeSet<String> missing = new TreeSet<String>(defs.stringPropertyNames());
                        missing.removeAll(locals.stringPropertyNames());
                        String cell = "";
                        for (String string : missing) {
                            cell = cell + "<tr><td>" + string + "</td></tr>";
                        }
                        this.tableCell(this.wrapInTable(okLabel, cell), true);
                        TreeSet<String> additional = new TreeSet<String>(locals.stringPropertyNames());
                        additional.removeAll(defs.stringPropertyNames());
                        cell = "";
                        for (String ex : additional) {
                            cell = cell + "<tr><td>" + ex + "</td></tr>";
                        }
                        this.tableCell(this.wrapInTable(okLabel, cell), true);
                        TreeSet<String> treeSet = new TreeSet<String>();
                        for (String k : defs.stringPropertyNames()) {
                            String val2;
                            String val1 = defs.getProperty(k);
                            if (!val1.equals(val2 = locals.getProperty(k))) continue;
                            treeSet.add(k);
                        }
                        cell = "";
                        for (String n : treeSet) {
                            cell = cell + "<tr><td>" + n + "</td><td>\"" + defs.getProperty(n) + "\"</td></tr>";
                        }
                        this.tableCell(this.wrapInTable(okLabel, cell), true);
                        this.sink.tableRow_();
                    }
                    this.endTable();
                    this.endSection();
                }
            }
            this.endSection();
        }

        private Locale createLocale(String localeCode) {
            String[] localeComponents = StringUtils.split((String)localeCode, (String)"_");
            Locale locale = null;
            if (localeComponents.length == 1) {
                locale = new Locale(localeComponents[0]);
            } else if (localeComponents.length == 2) {
                locale = new Locale(localeComponents[0], localeComponents[1]);
            } else if (localeComponents.length == 3) {
                locale = new Locale(localeComponents[0], localeComponents[1], localeComponents[2]);
            }
            return locale;
        }

        private String wrapInTable(String okLabel, String cell) {
            cell = cell.isEmpty() ? okLabel : "<table><tbody>" + cell + "</tbody></table>";
            return cell;
        }
    }
}

