/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.cli.Commandline;
import org.codehaus.mojo.keytool.AbstractKeyToolRequestWithKeyStoreAndAliasParametersMojo;
import org.codehaus.mojo.keytool.requests.KeyToolGenerateCertificateRequestRequest;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="generateCertificateRequest", requiresProject=true, threadSafe=true)
public class GenerateCertificateRequestMojo
extends AbstractKeyToolRequestWithKeyStoreAndAliasParametersMojo<KeyToolGenerateCertificateRequestRequest> {
    @Parameter
    private String keypass;
    @Parameter
    private File file;
    @Parameter
    private String sigalg;
    @Deprecated
    @Parameter
    private String ext;
    @Parameter
    private List<String> exts;
    @Parameter
    private String dname;

    public GenerateCertificateRequestMojo() {
        super(KeyToolGenerateCertificateRequestRequest.class);
    }

    @Override
    public void execute() throws MojoExecutionException {
        this.createParentDirIfNecessary(this.file.getPath());
        super.execute();
    }

    @Override
    protected KeyToolGenerateCertificateRequestRequest createKeytoolRequest() {
        KeyToolGenerateCertificateRequestRequest request = (KeyToolGenerateCertificateRequestRequest)super.createKeytoolRequest();
        request.setSigalg(this.sigalg);
        if (this.exts != null && !this.exts.isEmpty()) {
            request.setExts(this.exts);
        } else {
            request.setExt(this.ext);
        }
        request.setDname(this.dname);
        request.setFile(this.file);
        request.setKeypass(this.keypass);
        return request;
    }

    @Override
    protected String getCommandlineInfo(Commandline commandLine) {
        String commandLineInfo = super.getCommandlineInfo(commandLine);
        commandLineInfo = StringUtils.replace((String)commandLineInfo, (String)this.keypass, (String)"'*****'");
        return commandLineInfo;
    }
}

