/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.mojo.keytool.AbstractKeyToolMojo;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GenkeyMojo
extends AbstractKeyToolMojo {
    private String keyalg;
    private String keysize;
    private String sigalg;
    private String storetype;
    private String storepass;
    private String keypass;
    private String validity;
    private String dname;
    private String alias;
    private boolean verbose;

    public void execute() throws MojoExecutionException {
        ArrayList<String> arguments = new ArrayList<String>();
        Commandline commandLine = new Commandline();
        commandLine.setExecutable(this.getKeytoolPath());
        arguments.add("-genkey");
        this.addArgIf(arguments, this.verbose, "-v");
        this.addArgIfNotEmpty(arguments, "-dname", this.dname);
        this.addArgIfNotEmpty(arguments, "-alias", this.alias);
        this.addArgIfNotEmpty(arguments, "-keypass", this.keypass);
        this.addArgIfNotEmpty(arguments, "-keystore", this.keystore);
        this.addArgIfNotEmpty(arguments, "-storepass", this.storepass);
        this.addArgIfNotEmpty(arguments, "-validity", this.validity);
        this.addArgIfNotEmpty(arguments, "-keyalg", this.keyalg);
        this.addArgIfNotEmpty(arguments, "-keysize", this.keysize);
        this.addArgIfNotEmpty(arguments, "-sigalg", this.sigalg);
        this.addArgIfNotEmpty(arguments, "-storetype", this.storetype);
        Iterator it = arguments.iterator();
        while (it.hasNext()) {
            commandLine.createArgument().setValue(it.next().toString());
        }
        if (this.workingDirectory != null) {
            commandLine.setWorkingDirectory(this.workingDirectory.getAbsolutePath());
        }
        this.createParentDirIfNecessary(this.keystore);
        this.getLog().debug((CharSequence)("Executing: " + commandLine));
        InputStream inputStream = new InputStream(){

            public int read() {
                return -1;
            }
        };
        StreamConsumer outConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                GenkeyMojo.this.getLog().info((CharSequence)line);
            }
        };
        final StringBuffer errBuffer = new StringBuffer();
        StreamConsumer errConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                GenkeyMojo.this.getLog().warn((CharSequence)line);
                errBuffer.append(line);
            }
        };
        try {
            int result = this.executeCommandLine(commandLine, inputStream, outConsumer, errConsumer);
            if (result != 0) {
                throw new MojoExecutionException("Result of " + commandLine + " execution is: '" + result + "': " + errBuffer.toString() + ".");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("command execution failed", (Exception)((Object)e));
        }
    }

    private void createParentDirIfNecessary(String file) {
        File fileDir;
        if (file != null && (fileDir = new File(file).getParentFile()) != null) {
            boolean mkdirs = fileDir.mkdirs();
            this.getLog().debug((CharSequence)("mdkirs: " + mkdirs + " " + fileDir));
        }
    }

    private String getKeytoolPath() {
        return GenkeyMojo.getJDKCommandPath("keytool", this.getLog());
    }

    private static String getJDKCommandPath(String command, Log logger) {
        String path = GenkeyMojo.getJDKCommandExe(command).getAbsolutePath();
        logger.debug((CharSequence)(command + " executable=[" + path + "]"));
        return path;
    }

    private static File getJDKCommandExe(String command) {
        String fullCommand = command + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        File exe = SystemUtils.IS_OS_AIX ? new File(SystemUtils.getJavaHome() + "/../sh", fullCommand) : (SystemUtils.IS_OS_MAC_OSX ? new File(SystemUtils.getJavaHome() + "/bin", fullCommand) : new File(SystemUtils.getJavaHome() + "/../bin", fullCommand));
        return exe;
    }

    private void addArgIf(List arguments, boolean b, String value) {
        if (b) {
            arguments.add(value);
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value) {
        this.addArgIfNotEmpty2(arguments, key, value, false);
    }

    private void addArgIfNotEmpty2(List arguments, String key, String value, boolean ignored) {
        if (!StringUtils.isEmpty((String)value)) {
            arguments.add(key);
            arguments.add(value);
        }
    }

    private void addArgIfNotEmpty(List arguments, String key, String value, boolean repeatKey) {
        if (!StringUtils.isEmpty((String)value)) {
            arguments.add(key);
            StringTokenizer token = new StringTokenizer(value, ",");
            while (token.hasMoreTokens()) {
                String current = token.nextToken().trim();
                if (StringUtils.isEmpty((String)current)) continue;
                arguments.add(current);
                if (!token.hasMoreTokens() || !repeatKey) continue;
                arguments.add(key);
            }
        }
    }

    protected int executeCommandLine(Commandline commandLine, InputStream inputStream, StreamConsumer stream1, StreamConsumer stream2) throws CommandLineException {
        return CommandLineUtils.executeCommandLine((Commandline)commandLine, (InputStream)inputStream, (StreamConsumer)stream1, (StreamConsumer)stream2);
    }

    public void setKeypass(String keypass) {
        this.keypass = keypass;
    }

    public void setStorepass(String storepass) {
        this.storepass = storepass;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setKeyalg(String keyalg) {
        this.keyalg = keyalg;
    }

    public void setSigalg(String sigalg) {
        this.sigalg = sigalg;
    }

    public void setKeysize(String keysize) {
        this.keysize = keysize;
    }

    public void setStoretype(String storetype) {
        this.storetype = storetype;
    }

    public void setValidity(String validity) {
        this.validity = validity;
    }

    public void setDname(String dname) {
        this.dname = dname;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

