/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jspc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jasper.JspC;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.codehaus.mojo.jspc.JspcMojoClassLoader;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractJspcMojo
extends AbstractMojo {
    private static final String PS = File.pathSeparator;
    private static final String DEFAULT_INJECTION = "</web-app>";
    private MavenProject project;
    protected String javaEncoding;
    protected String source;
    protected String target;
    protected String workingDirectory;
    protected boolean setCompile;
    protected String webFragmentFile;
    protected String warSourceDirectory;
    protected String inputWebXml;
    protected String injectString;
    protected String outputWebXml;
    protected String packageName;
    protected boolean verbose;
    protected boolean showSuccess;
    protected boolean setSmapDumped;
    protected boolean setSmapSupressed;
    protected boolean listErrors;
    protected boolean validateXml;

    protected abstract List getClasspathElements();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (!"war".equalsIgnoreCase(this.project.getPackaging())) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"Packaging is not war. Plugin irrelevant");
            }
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Source directory: " + this.warSourceDirectory));
            this.getLog().debug((CharSequence)("Classpath: " + this.getClasspathElements().toString().replace(',', '\n')));
            this.getLog().debug((CharSequence)("Output directory: " + this.workingDirectory));
        }
        try {
            FileUtils.forceMkdir((File)new File(this.workingDirectory));
            FileUtils.forceMkdir((File)new File(this.webFragmentFile).getParentFile());
            FileUtils.forceMkdir((File)new File(this.outputWebXml).getParentFile());
            FileUtils.forceMkdir((File)new File(this.project.getBuild().getDirectory()));
            FileUtils.forceMkdir((File)new File(this.project.getBuild().getOutputDirectory()));
            String toolsJar = null;
            toolsJar = System.getProperty("os.name").equals("Mac OS X") ? System.getProperty("java.home") + "/../Classes/classes.jar" : System.getProperty("java.home") + File.separatorChar + ".." + File.separatorChar + "lib" + File.separatorChar + "tools.jar";
            List classpathElements = this.getClasspathElements();
            String classPath = this.getPathString(classpathElements);
            ArrayList args = this.getJspcArgs(classPath);
            String[] strArgs = args.toArray(new String[args.size()]);
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            JspcMojoClassLoader cl = new JspcMojoClassLoader(parent);
            cl.addURL(new File(toolsJar).getAbsoluteFile().toURL());
            Thread.currentThread().setContextClassLoader(cl);
            try {
                JspC jspc = new JspC();
                jspc.setArgs(strArgs);
                jspc.setSmapDumped(this.setSmapDumped);
                jspc.setSmapSuppressed(this.setSmapSupressed);
                jspc.setCompile(this.setCompile);
                jspc.setValidateXml(this.validateXml);
                jspc.setFailOnError(true);
                if (this.source != null) {
                    jspc.setCompilerSourceVM(this.source);
                }
                if (this.target != null) {
                    jspc.setCompilerTargetVM(this.target);
                }
                jspc.execute();
                if (this.setCompile) {
                    this.moveClassFiles();
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            this.writeWebXml();
            this.project.addCompileSourceRoot(this.workingDirectory);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("JSPC Error", e);
        }
    }

    private ArrayList getJspcArgs(String classPath) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-uriroot");
        args.add(this.warSourceDirectory);
        args.add("-d");
        args.add(this.workingDirectory);
        if (this.javaEncoding != null) {
            args.add("-javaEncoding");
            args.add(this.javaEncoding);
        }
        if (this.showSuccess) {
            args.add("-s");
        }
        if (this.listErrors) {
            args.add("-l");
        }
        args.add("-webinc");
        args.add(this.webFragmentFile);
        args.add("-p");
        args.add(this.packageName);
        if (this.verbose) {
            args.add("-v");
        }
        args.add("-classpath");
        args.add(classPath);
        this.getLog().debug((CharSequence)("jspc args: " + args));
        return args;
    }

    private void writeWebXml() throws Exception {
        int pos;
        String webXml = this.getFile(this.inputWebXml);
        String fragmentXml = this.getFile(this.webFragmentFile);
        String searchString = this.injectString;
        if (searchString == null) {
            searchString = DEFAULT_INJECTION;
        }
        if ((pos = webXml.indexOf(searchString)) < 0) {
            throw new MojoExecutionException("injectString('" + searchString + "') not found in webXml(" + this.inputWebXml + "')");
        }
        String output = webXml.substring(0, pos) + fragmentXml + (this.injectString == null ? DEFAULT_INJECTION : "") + webXml.substring(pos + searchString.length(), webXml.length());
        FileWriter fw = new FileWriter(this.outputWebXml);
        fw.write(output);
        fw.close();
    }

    private String getFile(String fName) throws Exception {
        String line;
        File f = new File(fName);
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        br.close();
        fr.close();
        return sb.toString();
    }

    public String getPathString(List pathElements) {
        StringBuffer sb = new StringBuffer();
        Iterator it = pathElements.iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append(PS);
        }
        return sb.toString();
    }

    protected void moveClassFiles() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.workingDirectory);
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.scan();
        String[] sourceDirectorySources = scanner.getIncludedFiles();
        for (int j = 0; j < sourceDirectorySources.length; ++j) {
            File from = new File(this.workingDirectory, sourceDirectorySources[j]);
            File to = new File(this.project.getBuild().getOutputDirectory(), sourceDirectorySources[j]);
            File parent = to.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            from.renameTo(to);
        }
    }
}

