/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jpox;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.jpox.AbstractJpoxMojo;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class AbstractJpoxSchemaMojo
extends AbstractJpoxMojo {
    private static final String TOOL_NAME_JPOX_SCHEMA_TOOL = "org.jpox.SchemaTool";
    private static final String[] requiredProperties = new String[]{"javax.jdo.option.ConnectionDriverName", "javax.jdo.option.ConnectionURL", "javax.jdo.option.ConnectionUserName", "javax.jdo.option.ConnectionPassword"};
    private Properties toolProperties;

    protected void executeJpoxTool(List pluginArtifacts, URL log4jProperties, List files) throws CommandLineException, MojoExecutionException {
        this.executeSchemaTool(pluginArtifacts, log4jProperties, files);
    }

    private void executeSchemaTool(List pluginArtifacts, URL log4jProperties, List files) throws CommandLineException, MojoExecutionException {
        Properties systemProperties = System.getProperties();
        Set toolPropertyKeys = ((Hashtable)this.toolProperties).keySet();
        Iterator it = toolPropertyKeys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!((Hashtable)systemProperties).containsKey(key)) continue;
            ((Hashtable)this.toolProperties).put(key, systemProperties.getProperty(key));
            this.getLog().warn((CharSequence)("Property '" + key + "' value specified in pom configuration will be overridden."));
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < requiredProperties.length; ++i) {
            if (((Hashtable)this.toolProperties).containsKey(requiredProperties[i])) continue;
            if (sb.length() == 0) {
                sb.append("Missing required properties:\n");
            }
            sb.append(requiredProperties[i] + "\n");
        }
        if (sb.length() > 0) {
            throw new MojoExecutionException(sb.toString());
        }
        Commandline cl = new Commandline();
        cl.setExecutable("java");
        StringBuffer cpBuffer = new StringBuffer();
        Iterator<Object> it2 = this.getUniqueClasspathElements().iterator();
        while (it2.hasNext()) {
            cpBuffer.append((String)it2.next());
            if (!it2.hasNext()) continue;
            cpBuffer.append(File.pathSeparator);
        }
        it2 = pluginArtifacts.iterator();
        while (it2.hasNext()) {
            Artifact artifact = (Artifact)it2.next();
            try {
                cpBuffer.append(File.pathSeparator).append(artifact.getFile().getCanonicalPath());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
            }
        }
        cl.createArgument().setValue("-cp");
        cl.createArgument().setValue(cpBuffer.toString());
        it2 = toolPropertyKeys.iterator();
        while (it2.hasNext()) {
            String key = (String)it2.next();
            String val = null != this.toolProperties.getProperty(key) ? this.toolProperties.getProperty(key) : "";
            cl.createArgument().setValue("-D" + key + "=" + val);
        }
        cl.createArgument().setValue(TOOL_NAME_JPOX_SCHEMA_TOOL);
        this.prepareModeSpecificCommandLineArguments(cl);
        cl.createArgument().setValue("-v");
        it2 = files.iterator();
        while (it2.hasNext()) {
            File file = (File)it2.next();
            cl.createArgument().setValue(file.getAbsolutePath());
        }
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLog().debug((CharSequence)"Executing command line:");
        this.getLog().debug((CharSequence)cl.toString());
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        this.getLog().debug((CharSequence)("Exit code: " + exitCode));
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().debug((CharSequence)" Standard output from the JPox schema tool:");
        this.getLog().debug((CharSequence)"--------------------");
        this.getLog().info((CharSequence)stdout.getOutput());
        this.getLog().debug((CharSequence)"--------------------");
        String stream = stderr.getOutput();
        if (stream.trim().length() > 0) {
            this.getLog().error((CharSequence)"--------------------");
            this.getLog().error((CharSequence)" Standard error from the JPox schema tool:");
            this.getLog().error((CharSequence)"--------------------");
            this.getLog().error((CharSequence)stderr.getOutput());
            this.getLog().error((CharSequence)"--------------------");
        }
        if (exitCode != 0) {
            throw new MojoExecutionException("The JPox schema tool exited with a non-null exit code.");
        }
    }

    protected abstract void prepareModeSpecificCommandLineArguments(Commandline var1);

    protected String getToolName() {
        return TOOL_NAME_JPOX_SCHEMA_TOOL;
    }
}

