/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jdepend;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import jdepend.xmlui.JDepend;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.jdepend.JDependXMLReportParser;
import org.codehaus.mojo.jdepend.ReportGenerator;

public abstract class AbstractJDependMojo
extends AbstractMavenReport {
    JDependXMLReportParser xmlParser;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/site", property="jdepend.outputDirectory", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${basedir}", property="jdepend.projectDirectory")
    private String projectDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="jdepend.classDirectory", required=true)
    private String classDirectory;
    @Parameter(defaultValue="${project.build.directory}/jdepend-report.xml", required=true, readonly=true)
    private String reportFile;
    @Parameter(defaultValue="false", property="jdepend.skip")
    private boolean skip;
    @Component
    private Renderer siteRenderer;

    public void executeReport(Locale locale) throws MavenReportException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution on behalf of user");
            return;
        }
        try {
            boolean success;
            File outputDirFile = new File(this.outputDirectory);
            if (!outputDirFile.exists() && !(success = outputDirFile.mkdirs())) {
                throw new MavenReportException("Could not create directory " + this.outputDirectory);
            }
            JDepend.main((String[])this.getArgumentList(this.getArgument(), this.getReportFile(), this.getClassDirectory()));
            this.xmlParser = new JDependXMLReportParser(new File(this.getReportFile()));
            this.generateReport(locale);
        }
        catch (Exception e) {
            throw new MavenReportException("Failed to execute JDepend", e);
        }
    }

    public boolean canGenerateReport() {
        return new File(this.classDirectory).exists();
    }

    private String[] getArgumentList(String argument, String locationXMLreportFile, String classDir) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(argument);
        argList.add(locationXMLreportFile);
        argList.add(classDir);
        return argList.toArray(new String[0]);
    }

    public void generateReport(Locale locale) throws MavenReportException {
        ReportGenerator report = new ReportGenerator();
        try {
            Sink sink = this.getSink();
            report.doGenerateReport(this.getBundle(locale), sink, this.xmlParser);
        }
        catch (Exception e) {
            throw new MavenReportException("Failed to generate JDepend report", e);
        }
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.jdepend.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.jdepend.name");
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("org.codehaus.mojo.jdepend.jdepend-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public String getOutputName() {
        return "jdepend-report";
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getArgument() {
        return "-file";
    }

    public String getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(String reportFile) {
        this.reportFile = reportFile;
    }

    public Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void setSiteRenderer(Renderer siteRenderer) {
        this.siteRenderer = siteRenderer;
    }

    public String getProjectDirectory() {
        return this.projectDirectory;
    }

    public void setProjectDirectory(String projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public String getClassDirectory() {
        return this.classDirectory;
    }

    public void setClassDirectory(String classDirectory) {
        this.classDirectory = classDirectory;
    }
}

