/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.jboss.packaging;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractPackagingMojo
extends AbstractMojo {
    private MavenProject project;
    private String outputDirectory;
    private File classesDirectory;
    private File packagingDirectory;
    protected File deploymentDescriptorFile;
    private File libDirectory;
    private String archiveName;
    Set excludes;
    JarArchiver jarArchiver;
    MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    public abstract void execute() throws MojoExecutionException;

    public MavenProject getProject() {
        return this.project;
    }

    public File getPackagingDirectory() {
        return this.packagingDirectory;
    }

    public abstract String getDeploymentDescriptorFilename();

    public String[] getAlternateDeploymentDescriptorFilenames() {
        return null;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void buildExplodedPackaging() throws MojoExecutionException {
        this.buildExplodedPackaging(Collections.EMPTY_SET);
    }

    public void buildExplodedPackaging(Set excludes) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Exploding JBoss packaging...");
        if (excludes == null) {
            excludes = Collections.EMPTY_SET;
        }
        this.packagingDirectory.mkdirs();
        this.libDirectory.mkdirs();
        try {
            File packagingFileTargetParent;
            File packagingFileTarget;
            this.getLog().info((CharSequence)("Assembling JBoss packaging " + this.project.getArtifactId() + " in " + this.packagingDirectory));
            if (this.classesDirectory.exists() && !this.classesDirectory.equals(this.packagingDirectory)) {
                FileUtils.copyDirectoryStructure((File)this.classesDirectory, (File)this.packagingDirectory);
            }
            if (!(packagingFileTarget = new File(packagingFileTargetParent = new File(this.packagingDirectory, "META-INF"), this.getDeploymentDescriptorFilename())).exists()) {
                if (!packagingFileTargetParent.exists()) {
                    packagingFileTargetParent.mkdirs();
                }
                if (this.deploymentDescriptorFile == null || !this.deploymentDescriptorFile.exists()) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(this.getDeploymentDescriptorFilename());
                    String[] alternateDescriptorFilenames = this.getAlternateDeploymentDescriptorFilenames();
                    if (alternateDescriptorFilenames != null) {
                        for (int i = 0; i < alternateDescriptorFilenames.length; ++i) {
                            buffer.append(", ");
                            buffer.append(alternateDescriptorFilenames[i]);
                            this.deploymentDescriptorFile = new File(packagingFileTargetParent, alternateDescriptorFilenames[i]);
                            if (this.deploymentDescriptorFile != null && this.deploymentDescriptorFile.exists()) break;
                        }
                    }
                    if (this.deploymentDescriptorFile == null || !this.deploymentDescriptorFile.exists()) {
                        throw new MojoExecutionException("Could not find descriptor files: " + buffer.toString());
                    }
                }
                FileUtils.copyFile((File)this.deploymentDescriptorFile, (File)packagingFileTarget);
            }
            Set artifacts = this.project.getArtifacts();
            ArrayList<Artifact> rejects = new ArrayList<Artifact>();
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"    Including artifacts: ");
            this.getLog().info((CharSequence)"    -------------------");
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
                if (artifact.isOptional() || !filter.include(artifact)) continue;
                String type = artifact.getType();
                String descriptor = artifact.getGroupId() + ":" + artifact.getArtifactId();
                if ("jar".equals(type) && !excludes.contains(descriptor)) {
                    this.getLog().info((CharSequence)("        o " + descriptor));
                    FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)this.libDirectory);
                    continue;
                }
                rejects.add(artifact);
            }
            if (!excludes.isEmpty()) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"    Excluded artifacts: ");
                this.getLog().info((CharSequence)"    ------------------");
                for (int ii = 0; ii < rejects.size(); ++ii) {
                    this.getLog().info((CharSequence)("        o " + rejects.get(ii)));
                }
            } else {
                this.getLog().info((CharSequence)"No artifacts have been excluded.");
            }
            this.getLog().info((CharSequence)"");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not explode JBoss packaging...", (Exception)e);
        }
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    protected void performPackaging(File archiveFile) throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException, MojoExecutionException {
        this.buildExplodedPackaging(this.excludes);
        this.getLog().info((CharSequence)("Generating JBoss packaging " + archiveFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(archiveFile);
        this.jarArchiver.addDirectory(this.getPackagingDirectory());
        archiver.createArchive(this.getProject(), this.archive);
        this.getProject().getArtifact().setFile(archiveFile);
    }
}

