/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jaxb2.shared.version;

import org.codehaus.mojo.jaxb2.shared.Validate;

public class DependencyInfo
implements Comparable<DependencyInfo> {
    private static final String GROUP_ARTIFACT_SEPARATOR = "/";
    private String groupId;
    private String artifactId;
    private String version;
    private String scope = "compile";
    private String type = "jar";

    public DependencyInfo(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getScope() {
        return this.scope;
    }

    public void setType(String type) {
        Validate.notEmpty(type, "type");
        this.type = type;
    }

    public void setScope(String scope) {
        Validate.notEmpty(scope, "scope");
        this.scope = scope;
    }

    public String getGroupArtifactKey() {
        return this.getGroupId() + GROUP_ARTIFACT_SEPARATOR + this.getArtifactId();
    }

    public int hashCode() {
        return this.groupId.hashCode() + this.artifactId.hashCode() + this.version.hashCode() + this.type.hashCode();
    }

    public String toString() {
        return this.groupId + GROUP_ARTIFACT_SEPARATOR + this.artifactId + GROUP_ARTIFACT_SEPARATOR + this.version + GROUP_ARTIFACT_SEPARATOR + this.scope + GROUP_ARTIFACT_SEPARATOR + this.type;
    }

    @Override
    public int compareTo(DependencyInfo that) {
        if (that == this) {
            return 0;
        }
        if (that == null) {
            return -1;
        }
        int toReturn = this.getGroupId().compareTo(that.getGroupId());
        if (toReturn == 0) {
            toReturn = this.getArtifactId().compareTo(that.getArtifactId());
        }
        if (toReturn == 0) {
            toReturn = this.getVersion().compareTo(that.getVersion());
        }
        if (toReturn == 0) {
            toReturn = this.getType().compareTo(that.getType());
        }
        return toReturn;
    }
}

